/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.pd;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSArray;
import org.verapdf.cos.COSInteger;
import org.verapdf.cos.COSName;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.cos.COSString;
import org.verapdf.gf.model.impl.containers.StaticContainers;
import org.verapdf.gf.model.impl.cos.GFCosBM;
import org.verapdf.gf.model.impl.cos.GFCosLang;
import org.verapdf.gf.model.impl.cos.GFCosNumber;
import org.verapdf.gf.model.impl.pd.GFPDContentStream;
import org.verapdf.gf.model.impl.pd.GFPDObject;
import org.verapdf.gf.model.impl.pd.GFPDSemanticContentStream;
import org.verapdf.gf.model.impl.pd.actions.GFPDAction;
import org.verapdf.gf.model.impl.pd.actions.GFPDAdditionalActions;
import org.verapdf.gf.model.impl.pd.annotations.GFPD3DAnnot;
import org.verapdf.gf.model.impl.pd.annotations.GFPDLinkAnnot;
import org.verapdf.gf.model.impl.pd.annotations.GFPDPrinterMarkAnnot;
import org.verapdf.gf.model.impl.pd.annotations.GFPDTrapNetAnnot;
import org.verapdf.gf.model.impl.pd.annotations.GFPDWidgetAnnot;
import org.verapdf.gf.model.impl.pd.util.PDResourcesHandler;
import org.verapdf.model.coslayer.CosBM;
import org.verapdf.model.coslayer.CosLang;
import org.verapdf.model.coslayer.CosNumber;
import org.verapdf.model.pdlayer.PDAction;
import org.verapdf.model.pdlayer.PDAdditionalActions;
import org.verapdf.model.pdlayer.PDAnnot;
import org.verapdf.model.pdlayer.PDContentStream;
import org.verapdf.pd.PDAnnotation;
import org.verapdf.pd.PDAppearanceEntry;
import org.verapdf.pd.PDAppearanceStream;
import org.verapdf.pd.PDGroup;
import org.verapdf.pd.PDPage;
import org.verapdf.pd.actions.PDAnnotationAdditionalActions;
import org.verapdf.pd.annotations.PDWidgetAnnotation;
import org.verapdf.pd.structure.PDNumberTreeNode;
import org.verapdf.pd.structure.PDStructTreeRoot;
import org.verapdf.pd.structure.StructureElementAccessObject;
import org.verapdf.pdfa.flavours.PDFAFlavour;

public class GFPDAnnot
extends GFPDObject
implements PDAnnot {
    public static final String ANNOTATION_TYPE = "PDAnnot";
    public static final String DICT = "Dict";
    public static final String STREAM = "Stream";
    public static final String APPEARANCE = "appearance";
    public static final String C = "C";
    public static final String IC = "IC";
    public static final String A = "A";
    public static final String ADDITIONAL_ACTION = "AA";
    public static final String LANG = "Lang";
    public static final String BM = "BM";
    public static final String LINK = "Link";
    public static final String PRINTER_MARK = "PrinterMark";
    public static final String WIDGET = "Widget";
    public static final String TRAP_NET = "TrapNet";
    public static final String TYPE_3D = "3D";
    public static final int X_AXIS = 0;
    public static final int Y_AXIS = 1;
    protected final PDResourcesHandler resources;
    private final PDPage page;
    private List<CosBM> blendMode = null;
    private List<PDContentStream> appearance = null;
    private boolean containsTransparency = false;

    public GFPDAnnot(PDAnnotation annot, PDResourcesHandler pageResources, PDPage page) {
        this(annot, pageResources, page, ANNOTATION_TYPE);
    }

    public GFPDAnnot(PDAnnotation annot, PDResourcesHandler pageResources, PDPage page, String type) {
        super(annot, type);
        this.resources = pageResources;
        this.page = page;
    }

    @Override
    public String getSubtype() {
        ASAtom subtype = ((PDAnnotation)this.simplePDObject).getSubtype();
        return subtype == null ? null : subtype.getValue();
    }

    @Override
    public String getAP() {
        COSObject apLocal = ((PDAnnotation)this.simplePDObject).getCOSAP();
        if (apLocal != null) {
            StringBuilder result = new StringBuilder();
            for (ASAtom key : apLocal.getKeySet()) {
                result.append(key.getValue());
                result.append(' ');
            }
            return result.length() <= 0 ? result.toString() : result.substring(0, result.length() - 1);
        }
        return null;
    }

    @Override
    public Long getF() {
        return ((PDAnnotation)this.simplePDObject).getF();
    }

    @Override
    public Double getCA() {
        return ((PDAnnotation)this.simplePDObject).getCA();
    }

    @Override
    public String getN_type() {
        PDAppearanceEntry normalAppearance = ((PDAnnotation)this.simplePDObject).getNormalAppearance();
        if (normalAppearance == null) {
            return null;
        }
        if (normalAppearance.isSubDictionary()) {
            return DICT;
        }
        return STREAM;
    }

    @Override
    public String getFT() {
        ASAtom ft = ((PDAnnotation)this.simplePDObject).getFT();
        return ft == null ? null : ft.getValue();
    }

    @Override
    public Double getwidth() {
        return GFPDAnnot.getDifference(((PDAnnotation)this.simplePDObject).getRect(), 0);
    }

    @Override
    public Double getheight() {
        return GFPDAnnot.getDifference(((PDAnnotation)this.simplePDObject).getRect(), 1);
    }

    @Override
    public Boolean getcontainsAA() {
        return this.simplePDObject.knownKey(ASAtom.AA);
    }

    @Override
    public String getstructParentType() {
        PDStructTreeRoot structTreeRoot = StaticContainers.getDocument().getStructTreeRoot();
        Long structParent = ((PDAnnotation)this.simplePDObject).getStructParent();
        if (structTreeRoot != null && structParent != null) {
            COSObject structureElement;
            PDNumberTreeNode parentTreeRoot = structTreeRoot.getParentTree();
            COSObject cOSObject = structureElement = parentTreeRoot == null ? null : parentTreeRoot.getObject(structParent);
            if (structureElement != null && structureElement.getType() == COSObjType.COS_DICT) {
                return structureElement.getStringKey(ASAtom.S);
            }
        }
        return null;
    }

    private List<CosLang> getLang() {
        PDStructTreeRoot structTreeRoot = StaticContainers.getDocument().getStructTreeRoot();
        Long structParent = ((PDAnnotation)this.simplePDObject).getStructParent();
        if (structTreeRoot != null && structParent != null) {
            COSObject baseLang;
            COSObject structureElement;
            PDNumberTreeNode parentTreeRoot = structTreeRoot.getParentTree();
            COSObject cOSObject = structureElement = parentTreeRoot == null ? null : parentTreeRoot.getObject(structParent);
            if (structureElement != null && (baseLang = structureElement.getKey(ASAtom.LANG)) != null && baseLang.getType() == COSObjType.COS_STRING) {
                ArrayList<GFCosLang> list = new ArrayList<GFCosLang>(1);
                list.add(new GFCosLang((COSString)baseLang.getDirectBase()));
                return Collections.unmodifiableList(list);
            }
        }
        return Collections.emptyList();
    }

    private List<CosBM> getBM() {
        if (this.blendMode == null) {
            this.blendMode = this.parseBM();
        }
        return this.blendMode;
    }

    private List<CosBM> parseBM() {
        if (StaticContainers.getFlavour().getPart() != PDFAFlavour.Specification.ISO_19005_4) {
            return Collections.emptyList();
        }
        COSObject BM = ((PDAnnotation)this.simplePDObject).getBM();
        if (BM != null && BM.getType() == COSObjType.COS_NAME) {
            if (!ASAtom.NORMAL.equals(BM.getName())) {
                this.containsTransparency = true;
            }
            ArrayList<GFCosBM> list = new ArrayList<GFCosBM>(1);
            list.add(new GFCosBM((COSName)BM.getDirectBase()));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    @Override
    public String getContents() {
        return ((PDAnnotation)this.simplePDObject).getContents();
    }

    @Override
    public String getAlt() {
        PDStructTreeRoot structTreeRoot = StaticContainers.getDocument().getStructTreeRoot();
        Long structParent = ((PDAnnotation)this.simplePDObject).getStructParent();
        if (structTreeRoot != null && structParent != null) {
            COSObject baseAlt;
            COSObject structureElement;
            PDNumberTreeNode parentTreeRoot = structTreeRoot.getParentTree();
            COSObject cOSObject = structureElement = parentTreeRoot == null ? null : parentTreeRoot.getObject(structParent);
            if (structureElement != null && (baseAlt = structureElement.getKey(ASAtom.ALT)) != null && baseAlt.getType() == COSObjType.COS_STRING) {
                return baseAlt.getDirectBase().toString();
            }
        }
        return null;
    }

    @Override
    public Boolean getisOutsideCropBox() {
        double[] cropBox = this.page.getCropBox();
        double[] rectangle = ((PDAnnotation)this.simplePDObject).getRect();
        if (rectangle != null && rectangle.length >= 4) {
            return cropBox[1] >= rectangle[3] || cropBox[0] >= rectangle[2] || cropBox[3] <= rectangle[1] || cropBox[2] <= rectangle[0];
        }
        return null;
    }

    private static Double getDifference(double[] array, int shift) {
        if (array != null && array.length > shift + 2) {
            return array[shift + 2] - array[shift];
        }
        return null;
    }

    @Override
    public Boolean getcontainsA() {
        return this.simplePDObject.knownKey(ASAtom.A);
    }

    @Override
    public List<? extends org.verapdf.model.baselayer.Object> getLinkedObjects(String link) {
        switch (link) {
            case "AA": {
                return this.getAdditionalActions();
            }
            case "A": {
                return this.getA();
            }
            case "IC": {
                return this.getIC();
            }
            case "C": {
                return this.getC();
            }
            case "appearance": {
                return this.getAppearance();
            }
            case "Lang": {
                return this.getLang();
            }
            case "BM": {
                return this.getBM();
            }
        }
        return super.getLinkedObjects(link);
    }

    private List<PDAdditionalActions> getAdditionalActions() {
        PDAnnotationAdditionalActions additionalActions = ((PDAnnotation)this.simplePDObject).getAdditionalActions();
        if (additionalActions != null) {
            ArrayList<GFPDAdditionalActions> actions = new ArrayList<GFPDAdditionalActions>(1);
            actions.add(new GFPDAdditionalActions(additionalActions));
            return Collections.unmodifiableList(actions);
        }
        return Collections.emptyList();
    }

    private List<PDAction> getA() {
        org.verapdf.pd.actions.PDAction action = ((PDAnnotation)this.simplePDObject).getA();
        if (action != null) {
            ArrayList<PDAction> res = new ArrayList<PDAction>(1);
            res.add(GFPDAction.getAction(action));
            return Collections.unmodifiableList(res);
        }
        return Collections.emptyList();
    }

    private List<CosNumber> getIC() {
        COSObject ic = ((PDAnnotation)this.simplePDObject).getCOSIC();
        if (ic != null) {
            return GFPDAnnot.getNumbersFromArray(ic);
        }
        return Collections.emptyList();
    }

    private List<CosNumber> getC() {
        COSObject c = ((PDAnnotation)this.simplePDObject).getCOSC();
        if (c != null) {
            return GFPDAnnot.getNumbersFromArray(c);
        }
        return Collections.emptyList();
    }

    private static List<CosNumber> getNumbersFromArray(COSObject array) {
        if (array.size() > 0) {
            ArrayList<GFCosNumber> color = new ArrayList<GFCosNumber>();
            for (COSObject colorValue : (COSArray)array.getDirectBase()) {
                if (!colorValue.getType().isNumber()) continue;
                color.add(GFCosNumber.fromPDFParserNumber(colorValue.get()));
            }
            return Collections.unmodifiableList(color);
        }
        ArrayList<CosNumber> res = new ArrayList<CosNumber>(1);
        res.add(GFCosNumber.fromPDFParserNumber(COSInteger.construct(0L).getDirectBase()));
        return res;
    }

    private List<PDContentStream> getAppearance() {
        if (this.appearance == null) {
            this.appearance = this.parseAppearance();
        }
        return this.appearance;
    }

    boolean isContainsTransparency() {
        if (this.appearance == null) {
            this.appearance = this.parseAppearance();
        }
        if (this.blendMode == null) {
            this.blendMode = this.parseBM();
        }
        return this.containsTransparency;
    }

    private List<PDContentStream> parseAppearance() {
        PDAppearanceEntry normalAppearance = ((PDAnnotation)this.simplePDObject).getNormalAppearance();
        PDAppearanceEntry downAppearance = ((PDAnnotation)this.simplePDObject).getDownAppearance();
        PDAppearanceEntry rolloverAppearance = ((PDAnnotation)this.simplePDObject).getRolloverAppearance();
        if (normalAppearance != null || downAppearance != null || rolloverAppearance != null) {
            ArrayList<PDContentStream> appearances = new ArrayList<PDContentStream>();
            this.addContentStreamsFromAppearanceEntry(normalAppearance, appearances);
            this.addContentStreamsFromAppearanceEntry(downAppearance, appearances);
            this.addContentStreamsFromAppearanceEntry(rolloverAppearance, appearances);
            return Collections.unmodifiableList(appearances);
        }
        return Collections.emptyList();
    }

    private void addContentStreamsFromAppearanceEntry(PDAppearanceEntry appearanceEntry, List<PDContentStream> appearances) {
        if (appearanceEntry != null) {
            if (appearanceEntry.isSubDictionary()) {
                Map<ASAtom, PDAppearanceStream> subDictionary = appearanceEntry.getSubDictionary();
                for (PDAppearanceStream stream : subDictionary.values()) {
                    this.addAppearance(appearances, stream);
                }
            } else {
                this.addAppearance(appearances, appearanceEntry.getAppearanceStream());
            }
        }
    }

    private void addAppearance(List<PDContentStream> list, PDAppearanceStream toAdd) {
        if (toAdd != null) {
            PDResourcesHandler resources = this.resources.getExtendedResources(toAdd.getResources());
            List<CosLang> annotLang = this.getLang();
            GFPDContentStream stream = !PDFAFlavour.PDFUA_1.getPart().getFamily().equals(StaticContainers.getFlavour().getPart().getFamily()) && !PDFAFlavour.WCAG2_1.getPart().getFamily().equals(StaticContainers.getFlavour().getPart().getFamily()) ? new GFPDContentStream(toAdd, resources, null, new StructureElementAccessObject(this.simpleCOSObject), this.getstructParentType(), "") : new GFPDSemanticContentStream(toAdd, resources, null, new StructureElementAccessObject(this.simpleCOSObject), this.getstructParentType(), "", annotLang.isEmpty() ? null : annotLang.get(0).getunicodeValue());
            this.containsTransparency |= stream.isContainsTransparency();
            PDGroup group = toAdd.getGroup();
            this.containsTransparency |= group != null && ASAtom.TRANSPARENCY.equals(group.getSubtype());
            list.add(stream);
        }
    }

    public static GFPDAnnot createAnnot(PDAnnotation annot, PDResourcesHandler pageResources, PDPage page) {
        String subtypeString;
        ASAtom subtype = annot.getSubtype();
        if (subtype == null) {
            return new GFPDAnnot(annot, pageResources, page);
        }
        switch (subtypeString = subtype.getValue()) {
            case "Widget": {
                return new GFPDWidgetAnnot((PDWidgetAnnotation)annot, pageResources, page);
            }
            case "3D": {
                return new GFPD3DAnnot(annot, pageResources, page);
            }
            case "TrapNet": {
                return new GFPDTrapNetAnnot(annot, pageResources, page);
            }
            case "Link": {
                return new GFPDLinkAnnot(annot, pageResources, page);
            }
            case "PrinterMark": {
                return new GFPDPrinterMarkAnnot(annot, pageResources, page);
            }
        }
        return new GFPDAnnot(annot, pageResources, page);
    }
}

