/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.pd.font.cmap;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.verapdf.as.ASAtom;
import org.verapdf.as.io.ASInputStream;
import org.verapdf.cos.COSDictionary;
import org.verapdf.cos.COSKey;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.cos.COSStream;
import org.verapdf.exceptions.LoopedException;
import org.verapdf.io.InternalInputStream;
import org.verapdf.io.SeekableInputStream;
import org.verapdf.pd.PDObject;
import org.verapdf.pd.font.cmap.CMap;
import org.verapdf.pd.font.cmap.CMapFactory;

public class PDCMap
extends PDObject {
    private static final Logger LOGGER = Logger.getLogger(PDCMap.class.getCanonicalName());
    private COSDictionary cidSystemInfo;
    private CMap cMapFile = null;
    private PDCMap useCMap = null;
    private boolean parsedCMap = false;
    private Boolean isIdentity;

    public PDCMap(COSObject cMap) {
        super(cMap == null ? COSObject.getEmpty() : cMap);
    }

    public String getCMapName() {
        COSObject cMapName;
        if (this.getObject().getType() == COSObjType.COS_NAME) {
            return this.getObject().getString();
        }
        if (this.getObject().getType() == COSObjType.COS_STREAM && !(cMapName = this.getObject().getKey(ASAtom.CMAPNAME)).empty()) {
            return cMapName.getString();
        }
        return "";
    }

    private String getCMapID() {
        if (this.getObject().getType() == COSObjType.COS_STREAM) {
            return "CMap " + this.getObject().getObjectKey().toString();
        }
        if (this.getObject().getType() == COSObjType.COS_NAME) {
            return this.getObject().getString();
        }
        return "";
    }

    public COSObject getcMap() {
        return this.getObject();
    }

    public CMap getCMapFile() {
        return this.getCMapFile(new HashSet<COSKey>());
    }

    private CMap getCMapFile(Set<COSKey> keys) {
        if (!this.parsedCMap) {
            this.parsedCMap = true;
            if (this.getObject().getType() == COSObjType.COS_STREAM) {
                try (ASInputStream cMapStream = this.getObject().getData(COSStream.FilterFlags.DECODE);){
                    this.cMapFile = CMapFactory.getCMap(this.getCMapID(), cMapStream);
                }
                catch (IOException e) {
                    LOGGER.log(Level.FINE, "Can't close stream", e);
                }
            } else if (this.getObject().getType() == COSObjType.COS_NAME) {
                String name = this.getObject().getString();
                String cMapPath = "/font/cmap/" + name;
                try (ASInputStream cMapStream = PDCMap.loadCMap(cMapPath);){
                    this.cMapFile = CMapFactory.getCMap(this.getCMapID(), cMapStream);
                }
                catch (IOException e) {
                    LOGGER.log(Level.FINE, "Can't close stream", e);
                }
            } else {
                return null;
            }
            this.parseUseCMap();
            if (this.useCMap != null) {
                COSKey key = this.getObject().getKey();
                if (keys.contains(key)) {
                    throw new LoopedException("Loop inside CMap");
                }
                if (key != null) {
                    keys.add(key);
                }
                this.cMapFile.useCMap(this.useCMap.getCMapFile(keys));
            }
        }
        return this.cMapFile;
    }

    public String getRegistry() {
        if (this.getCIDSystemInfo() == null) {
            return null;
        }
        return this.getCIDSystemInfo().getStringKey(ASAtom.REGISTRY);
    }

    public String getOrdering() {
        if (this.getCIDSystemInfo() == null) {
            return null;
        }
        return this.getCIDSystemInfo().getStringKey(ASAtom.ORDERING);
    }

    public Long getSupplement() {
        if (this.getCIDSystemInfo() == null) {
            return null;
        }
        return this.getCIDSystemInfo().getIntegerKey(ASAtom.SUPPLEMENT);
    }

    public COSObject getUseCMap() {
        COSObject res = this.getObject().getKey(ASAtom.USE_CMAP);
        return res == null ? COSObject.getEmpty() : res;
    }

    private COSDictionary getCIDSystemInfo() {
        if (this.getObject().getType() == COSObjType.COS_NAME) {
            String registry = this.getCMapFile().getRegistry();
            String ordering = this.getCMapFile().getOrdering();
            int supplement = this.getCMapFile().getSupplement();
            COSDictionary res = (COSDictionary)COSDictionary.construct(ASAtom.REGISTRY, registry).get();
            res.setStringKey(ASAtom.ORDERING, ordering);
            res.setIntegerKey(ASAtom.SUPPLEMENT, supplement);
            return res;
        }
        if (this.cidSystemInfo == null) {
            COSObject cidSystemInfoObject = this.getObject().getKey(ASAtom.CID_SYSTEM_INFO);
            if (cidSystemInfoObject.getType() == COSObjType.COS_DICT) {
                this.cidSystemInfo = (COSDictionary)cidSystemInfoObject.getDirectBase();
            } else if (cidSystemInfoObject.getType() == COSObjType.COS_ARRAY && (cidSystemInfoObject = cidSystemInfoObject.at(0)) != null && cidSystemInfoObject.getType() == COSObjType.COS_DICT) {
                this.cidSystemInfo = (COSDictionary)cidSystemInfoObject.getDirectBase();
            }
        }
        return this.cidSystemInfo;
    }

    private void parseUseCMap() {
        COSObject useCMap;
        if (this.useCMap == null && !(useCMap = this.getUseCMap()).empty()) {
            this.useCMap = new PDCMap(useCMap);
        }
    }

    private static ASInputStream loadCMap(String cMapName) {
        SeekableInputStream seekableInputStream;
        block10: {
            URL resURL = PDCMap.class.getResource(cMapName);
            if (resURL == null) {
                throw new IOException("CMap " + cMapName + " can't be found.");
            }
            File cMapFile = new File(resURL.getFile());
            if (cMapFile.exists()) {
                return new InternalInputStream(cMapFile);
            }
            InputStream input = PDCMap.class.getResourceAsStream(cMapName);
            try {
                seekableInputStream = SeekableInputStream.getSeekableStream(input);
                if (input == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (input != null) {
                        try {
                            input.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    LOGGER.log(Level.FINE, "Error in opening predefined CMap " + cMapName, e);
                    return null;
                }
            }
            input.close();
        }
        return seekableInputStream;
    }

    public String toUnicode(int code) {
        String res = null;
        if (this.getCMapFile() != null && (res = this.getCMapFile().getUnicode(code)) == null) {
            this.parseUseCMap();
            if (this.useCMap != null) {
                res = this.useCMap.toUnicode(code);
            }
        }
        return res;
    }

    public boolean isIdentity() {
        if (this.isIdentity == null) {
            this.isIdentity = this.getCMapName().startsWith("Identity-");
        }
        return this.isIdentity;
    }
}

