/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.tools;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.verapdf.cos.COSKey;
import org.verapdf.pd.font.FontProgram;
import org.verapdf.pd.font.cmap.CMap;
import org.verapdf.pd.structure.PDStructureNameSpace;
import org.verapdf.tools.resource.ASFileStreamCloser;

public class StaticResources {
    private static final Logger LOGGER = Logger.getLogger(StaticResources.class.getCanonicalName());
    private static final ThreadLocal<Map<String, CMap>> cMapCache = new ThreadLocal();
    private static final ThreadLocal<Map<COSKey, PDStructureNameSpace>> structureNameSpaceCache = new ThreadLocal();
    private static final ThreadLocal<Map<String, FontProgram>> cachedFonts = new ThreadLocal();

    private StaticResources() {
    }

    public static void cacheCMap(String name, CMap cMap) {
        StaticResources.checkForNull(cMapCache);
        cMapCache.get().put(name, cMap);
    }

    public static CMap getCMap(String name) {
        StaticResources.checkForNull(cMapCache);
        return cMapCache.get().get(name);
    }

    public static void cacheStructureNameSpace(PDStructureNameSpace nameSpace) {
        StaticResources.checkForNull(structureNameSpaceCache);
        COSKey key = nameSpace.getObject().getObjectKey();
        structureNameSpaceCache.get().put(key, nameSpace);
    }

    public static PDStructureNameSpace getStructureNameSpace(COSKey key) {
        StaticResources.checkForNull(structureNameSpaceCache);
        return structureNameSpaceCache.get().get(key);
    }

    public static void cacheFontProgram(String key, FontProgram font) {
        StaticResources.checkForNull(cachedFonts);
        if (key != null) {
            cachedFonts.get().put(key, font);
        } else {
            cachedFonts.get().put(String.valueOf(font.hashCode()), font);
        }
    }

    public static FontProgram getCachedFont(String key) {
        StaticResources.checkForNull(cachedFonts);
        if (key == null) {
            return null;
        }
        return cachedFonts.get().get(key);
    }

    public static void clear() {
        StaticResources.checkForNull(cachedFonts);
        for (FontProgram fp : cachedFonts.get().values()) {
            ASFileStreamCloser fpr = fp.getFontProgramResource();
            if (fpr == null) continue;
            try {
                fpr.close();
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, "Exception while closing font program", e);
            }
        }
        cMapCache.set(new HashMap());
        structureNameSpaceCache.set(new HashMap());
        cachedFonts.set(new HashMap());
    }

    private static void checkForNull(ThreadLocal variable) {
        if (variable.get() == null) {
            variable.set(new HashMap());
        }
    }

    public static Map<String, CMap> getcMapCache() {
        return cMapCache.get();
    }

    public static void setcMapCache(Map<String, CMap> cMapCache) {
        StaticResources.cMapCache.set(cMapCache);
    }

    public static Map<COSKey, PDStructureNameSpace> getStructureNameSpaceCache() {
        return structureNameSpaceCache.get();
    }

    public static void setStructureNameSpaceCache(Map<COSKey, PDStructureNameSpace> structureNameSpaceCache) {
        StaticResources.structureNameSpaceCache.set(structureNameSpaceCache);
    }

    public static Map<String, FontProgram> getCachedFonts() {
        return cachedFonts.get();
    }

    public static void setCachedFonts(Map<String, FontProgram> cachedFonts) {
        StaticResources.cachedFonts.set(cachedFonts);
    }
}

