/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.pd;

import org.verapdf.cos.COSKey;
import org.verapdf.cos.COSObject;
import org.verapdf.gf.model.tools.GFIDGenerator;
import org.verapdf.model.GenericModelObject;
import org.verapdf.pd.PDContentStream;
import org.verapdf.pd.PDDocument;
import org.verapdf.pd.PDObject;
import org.verapdf.pd.font.PDFont;
import org.verapdf.pd.font.cmap.PDCMap;

public class GFPDObject
extends GenericModelObject
implements org.verapdf.model.pdlayer.PDObject {
    public static final int MAX_NUMBER_OF_ELEMENTS = 1;
    protected PDDocument document;
    protected PDContentStream contentStream;
    protected PDObject simplePDObject;
    protected PDFont pdFont;
    protected PDCMap pdcMap;
    protected COSObject simpleCOSObject;
    protected String id;

    public GFPDObject(PDDocument document, String type) {
        super(type);
        this.document = document;
    }

    public GFPDObject(PDContentStream contentStream, String type) {
        super(type);
        this.contentStream = contentStream;
        COSObject simpleObject = ((PDObject)((Object)contentStream)).getObject();
        if (simpleObject != null && !simpleObject.empty()) {
            COSKey key = simpleObject.getObjectKey();
            this.id = key != null ? key.getNumber() + " " + key.getGeneration() + " obj " + this.getObjectType() : super.getID();
        }
    }

    public GFPDObject(PDObject simplePDObject, String type) {
        super(type);
        this.simplePDObject = simplePDObject;
        if (simplePDObject != null && !simplePDObject.getObject().empty()) {
            this.simpleCOSObject = simplePDObject.getObject();
            COSKey key = simplePDObject.getObject().getObjectKey();
            this.id = key != null ? key.getNumber() + " " + key.getGeneration() + " obj " + this.getObjectType() : super.getID();
        }
    }

    public GFPDObject(PDFont font, String type) {
        super(type);
        this.pdFont = font;
        if (font != null) {
            this.id = GFIDGenerator.generateID(font);
        }
    }

    public GFPDObject(PDCMap pdcMap, String type) {
        super(type);
        this.pdcMap = pdcMap;
        this.simplePDObject = pdcMap;
        if (this.simplePDObject != null && !this.simplePDObject.getObject().empty()) {
            this.simpleCOSObject = this.simplePDObject.getObject();
            COSKey key = this.simplePDObject.getObject().getObjectKey();
            this.id = key != null ? key.getNumber() + " " + key.getGeneration() + " obj " + this.getObjectType() : super.getID();
        }
    }

    public GFPDObject(COSObject simpleCOSObject, String type) {
        super(type);
        this.simpleCOSObject = simpleCOSObject;
    }

    @Override
    public String getID() {
        return this.id == null ? super.getID() : this.id;
    }
}

