/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gui;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.EnumSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import javax.swing.SwingWorker;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.verapdf.apps.ConfigManager;
import org.verapdf.apps.ProcessType;
import org.verapdf.apps.VeraAppConfig;
import org.verapdf.apps.utils.ApplicationUtils;
import org.verapdf.core.VeraPDFException;
import org.verapdf.core.utils.LogsFileHandler;
import org.verapdf.features.FeatureExtractorConfig;
import org.verapdf.gui.CheckerPanel;
import org.verapdf.pdfa.validation.profiles.ValidationProfile;
import org.verapdf.pdfa.validation.validators.ValidatorConfig;
import org.verapdf.policy.PolicyChecker;
import org.verapdf.processor.BatchProcessor;
import org.verapdf.processor.FormatOption;
import org.verapdf.processor.ProcessorConfig;
import org.verapdf.processor.ProcessorFactory;
import org.verapdf.processor.TaskType;
import org.verapdf.processor.reports.BatchSummary;
import org.verapdf.report.HTMLReport;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

class ValidateWorker
extends SwingWorker<ValidateWorkerSummary, Integer> {
    private static final Logger logger = Logger.getLogger(ValidateWorker.class.getCanonicalName());
    private static final String ERROR_IN_OPEN_STREAMS = "Can't open stream from PDF file or can't open stream to temporary XML report file";
    private static final String ERROR_IN_PROCESSING = "Error during the processing";
    private static final String ERROR_IN_CREATING_TEMP_FILE = "Can't create temporary file for XML report";
    private static final String ERROR_IN_OBTAINING_POLICY_FEATURES = "Can't obtain enabled features from policy files";
    private List<File> pdfs;
    private ValidationProfile customProfile;
    private File policy;
    private CheckerPanel parent;
    private ConfigManager configManager;
    private File xmlReport = null;
    private File htmlReport = null;
    private ValidateWorkerSummary validateWorkerSummary = null;

    ValidateWorker(CheckerPanel parent, List<File> pdfs, ConfigManager configManager, ValidationProfile customProfile, File policy) {
        if (pdfs == null) {
            throw new IllegalArgumentException("List of pdf files can not be null");
        }
        this.parent = parent;
        this.pdfs = pdfs;
        this.configManager = configManager;
        this.customProfile = customProfile;
        this.policy = policy;
    }

    @Override
    protected ValidateWorkerSummary doInBackground() {
        try {
            this.xmlReport = File.createTempFile("veraPDF-tempXMLReport", ".xml");
            this.xmlReport.deleteOnExit();
            this.htmlReport = null;
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, ERROR_IN_CREATING_TEMP_FILE, e);
            this.parent.handleValidationError("Can't create temporary file for XML report: ", e);
        }
        try (FileOutputStream mrrReport = new FileOutputStream(this.xmlReport);){
            VeraAppConfig veraAppConfig = this.parent.appConfigFromState();
            ValidatorConfig validatorConfig = this.configManager.getValidatorConfig();
            LogsFileHandler.setLoggingLevel(validatorConfig.getLoggingLevel());
            ProcessType processType = veraAppConfig.getProcessType();
            boolean isPolicy = (processType == ProcessType.POLICY || processType == ProcessType.POLICY_FIX) && this.policy != null;
            EnumSet<TaskType> tasks = processType.getTasks();
            FeatureExtractorConfig featuresConfig = this.configManager.getFeaturesConfig();
            if (isPolicy) {
                try (FileInputStream policyStream = new FileInputStream(this.policy);){
                    featuresConfig = ApplicationUtils.mergeEnabledFeaturesFromPolicy(featuresConfig, policyStream);
                }
                catch (ParserConfigurationException | XPathExpressionException | SAXException e) {
                    logger.log(Level.SEVERE, ERROR_IN_OBTAINING_POLICY_FEATURES, e);
                    this.parent.handleValidationError("Can't obtain enabled features from policy files: ", e);
                }
            }
            ProcessorConfig resultConfig = this.customProfile == null ? ProcessorFactory.fromValues(validatorConfig, featuresConfig, this.configManager.getPluginsCollectionConfig(), this.configManager.getFixerConfig(), tasks, veraAppConfig.getFixesFolder()) : ProcessorFactory.fromValues(validatorConfig, featuresConfig, this.configManager.getPluginsCollectionConfig(), this.configManager.getFixerConfig(), tasks, this.customProfile, veraAppConfig.getFixesFolder());
            try (BatchProcessor processor = ProcessorFactory.fileBatchProcessor(resultConfig);){
                VeraAppConfig applicationConfig = this.configManager.getApplicationConfig();
                BatchSummary batchSummary = processor.process(this.pdfs, ProcessorFactory.getHandler(FormatOption.MRR, applicationConfig.isVerbose(), mrrReport, validatorConfig.isRecordPasses()));
                this.validateWorkerSummary = new ValidateWorkerSummary(batchSummary);
                if (isPolicy) {
                    this.applyPolicy();
                    this.validateWorkerSummary.setPolicyNonCompliantJobCount(ValidateWorker.countFailedPolicyJobs(this.xmlReport));
                }
            }
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, ERROR_IN_OPEN_STREAMS, e);
            this.parent.handleValidationError("Can't open stream from PDF file or can't open stream to temporary XML report file: ", e);
        }
        catch (ParserConfigurationException | XPathExpressionException | VeraPDFException | SAXException e) {
            logger.log(Level.SEVERE, ERROR_IN_PROCESSING, e);
            this.parent.handleValidationError("Error during the processing: ", e);
        }
        if (this.validateWorkerSummary != null) {
            this.writeHtmlReport();
        }
        return this.validateWorkerSummary;
    }

    private void applyPolicy() throws IOException, VeraPDFException {
        File tempMrrFile = this.xmlReport;
        this.xmlReport = File.createTempFile("veraPDF-tempXMLReport", ".xml");
        this.xmlReport.deleteOnExit();
        File tempPolicyResult = File.createTempFile("policyResult", "veraPDF");
        try (FileInputStream mrrIs = new FileInputStream(tempMrrFile);
             FileOutputStream policyResultOs = new FileOutputStream(tempPolicyResult);
             FileOutputStream mrrReport = new FileOutputStream(this.xmlReport);){
            PolicyChecker.applyPolicy(this.policy, mrrIs, policyResultOs);
            PolicyChecker.insertPolicyReport(tempPolicyResult, tempMrrFile, mrrReport);
        }
        if (!tempPolicyResult.delete()) {
            tempPolicyResult.deleteOnExit();
        }
    }

    @Override
    protected void done() {
        this.parent.validationEnded(this.xmlReport, this.htmlReport);
    }

    private void writeHtmlReport() {
        String extension = "html";
        String ext = ".html";
        try {
            this.htmlReport = File.createTempFile("veraPDF-tempHTMLReport", ".html");
            this.htmlReport.deleteOnExit();
            try (FileInputStream xmlStream = new FileInputStream(this.xmlReport);
                 FileOutputStream htmlStream = new FileOutputStream(this.htmlReport);){
                HTMLReport.writeHTMLReport(xmlStream, htmlStream, this.validateWorkerSummary.getBatchSummary().isMultiJob(), this.configManager.getApplicationConfig().getWikiPath(), true);
            }
            catch (IOException | TransformerException excep) {
                String message = String.format("IOException when saving the %S report.", "html");
                JOptionPane.showMessageDialog(this.parent, String.format("IOException when saving the %S report.", "html"), "Error", 0);
                logger.log(Level.SEVERE, message, excep);
                this.htmlReport = null;
            }
        }
        catch (IOException excep) {
            String message = String.format("IOException when saving the %S report.", "html");
            JOptionPane.showMessageDialog(this.parent, message, "Error", 0);
            logger.log(Level.SEVERE, message, excep);
            this.htmlReport = null;
        }
    }

    private static int countFailedPolicyJobs(File xmlReport) throws XPathExpressionException, ParserConfigurationException, IOException, SAXException {
        DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document document = documentBuilder.parse(xmlReport);
        XPath path = XPathFactory.newInstance().newXPath();
        int failedPolicyJobsCount = ((Number)path.evaluate("count(//policyReport[@failedChecks > 0])", document, XPathConstants.NUMBER)).intValue();
        return failedPolicyJobsCount;
    }

    public class ValidateWorkerSummary {
        private BatchSummary batchSummary;
        private int policyNonCompliantJobCount = -1;

        public ValidateWorkerSummary(BatchSummary batchSummary, int policyNonCompliantJobCount) {
            this.batchSummary = batchSummary;
            this.policyNonCompliantJobCount = policyNonCompliantJobCount;
        }

        public ValidateWorkerSummary(BatchSummary batchSummary) {
            this.batchSummary = batchSummary;
        }

        public BatchSummary getBatchSummary() {
            return this.batchSummary;
        }

        public int getPolicyNonCompliantJobCount() {
            return this.policyNonCompliantJobCount;
        }

        public void setPolicyNonCompliantJobCount(int failedPolicyJobs) {
            this.policyNonCompliantJobCount = failedPolicyJobs;
        }

        public boolean isPolicyApplied() {
            return this.policyNonCompliantJobCount >= 0;
        }
    }
}

