/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.metadata.fixer.gf.impl.model;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSFilters;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.cos.COSStream;
import org.verapdf.cos.COSTrailer;
import org.verapdf.metadata.fixer.entity.InfoDictionary;
import org.verapdf.metadata.fixer.entity.Metadata;
import org.verapdf.metadata.fixer.entity.PDFDocument;
import org.verapdf.metadata.fixer.gf.impl.model.InfoDictionaryImpl;
import org.verapdf.metadata.fixer.gf.impl.model.MetadataImpl;
import org.verapdf.pd.PDCatalog;
import org.verapdf.pd.PDDocument;
import org.verapdf.pd.PDMetadata;
import org.verapdf.pdfa.results.MetadataFixerResult;
import org.verapdf.pdfa.results.MetadataFixerResultImpl;
import org.verapdf.xmp.XMPException;
import org.verapdf.xmp.impl.VeraPDFMeta;

public class PDFDocumentImpl
implements PDFDocument {
    private static final Logger LOGGER = Logger.getLogger(PDFDocumentImpl.class.getCanonicalName());
    private final PDDocument document;
    private MetadataImpl metadata;
    private InfoDictionaryImpl info;
    private boolean isUnfiltered = false;

    public PDFDocumentImpl(InputStream pdfStream) throws IOException {
        this(new PDDocument(pdfStream));
    }

    public PDFDocumentImpl(PDDocument document) {
        if (document == null) {
            throw new IllegalArgumentException("Document representation can not be null");
        }
        this.document = document;
        this.metadata = this.parseMetadata();
        this.info = this.getInfo();
    }

    private MetadataImpl parseMetadata() {
        PDCatalog catalog = this.document.getCatalog();
        PDMetadata meta = catalog.getMetadata();
        if (meta == null) {
            COSObject stream = COSStream.construct();
            catalog.setKey(ASAtom.METADATA, stream);
            this.document.getDocument().addObject(stream);
            VeraPDFMeta xmp = VeraPDFMeta.create();
            return new MetadataImpl(xmp, stream, this.document.getDocument(), true);
        }
        return PDFDocumentImpl.parseMetadata(meta, this.document);
    }

    private static MetadataImpl parseMetadata(PDMetadata meta, PDDocument document) {
        try {
            VeraPDFMeta xmp = VeraPDFMeta.parse(meta.getStream());
            if (xmp != null) {
                return new MetadataImpl(xmp, meta.getObject(), document.getDocument(), false);
            }
        }
        catch (XMPException e) {
            LOGGER.log(Level.FINE, "Problems with XMP parsing. " + e.getMessage(), e);
        }
        return null;
    }

    private InfoDictionaryImpl getInfo() {
        COSTrailer trailer = this.document.getDocument().getTrailer();
        COSObject infoDict = trailer.getInfo();
        return infoDict != null && infoDict.getType() == COSObjType.COS_DICT ? new InfoDictionaryImpl(infoDict, this.document.getDocument()) : null;
    }

    @Override
    public Metadata getMetadata() {
        return this.metadata;
    }

    @Override
    public InfoDictionary getInfoDictionary() {
        return this.info;
    }

    @Override
    public boolean isNeedToBeUpdated() {
        boolean metaUpd = this.metadata != null && this.metadata.isNeedToBeUpdated();
        boolean infoUpd = this.info != null && this.info.isNeedToBeUpdated();
        return metaUpd || infoUpd || this.isUnfiltered;
    }

    @Override
    public MetadataFixerResult saveDocumentIncremental(MetadataFixerResult.RepairStatus status, OutputStream output) {
        MetadataFixerResultImpl.Builder builder = new MetadataFixerResultImpl.Builder();
        try {
            boolean isMetaAdd;
            PDMetadata meta = this.document.getCatalog().getMetadata();
            boolean isMetaPresent = meta != null && this.isNeedToBeUpdated();
            boolean bl = isMetaAdd = meta == null && this.metadata != null;
            if (isMetaPresent || isMetaAdd) {
                this.metadata.updateMetadataStream();
                if (isMetaAdd) {
                    this.document.getDocument().addChangedObject(this.document.getCatalog().getObject());
                }
                this.document.saveTo(output);
                output.close();
                builder.status(PDFDocumentImpl.getStatus(status));
            } else {
                builder.status(status);
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.FINE, e.getMessage(), e);
            builder.status(MetadataFixerResult.RepairStatus.FIX_ERROR).addFix("Problems with document save. " + e.getMessage());
        }
        return builder.build();
    }

    @Override
    public int removeFiltersForAllMetadataObjects() {
        int res = 0;
        List<COSObject> objects = this.document.getDocument().getObjectsByType(ASAtom.METADATA);
        ArrayList<COSStream> metas = new ArrayList<COSStream>();
        for (COSObject obj : objects) {
            if (obj.getType() == COSObjType.COS_STREAM) {
                metas.add((COSStream)obj.getDirectBase());
                continue;
            }
            LOGGER.log(Level.SEVERE, "Found non-stream Metadata dictionary.");
        }
        for (COSStream stream : metas) {
            if (stream.getFilters().size() <= 0) continue;
            try {
                stream.setFilters(new COSFilters());
                ++res;
            }
            catch (IOException e) {
                LOGGER.log(Level.FINE, "Error when removing filter from stream", e);
                return -1;
            }
        }
        this.isUnfiltered = res > 0;
        return res;
    }

    private static MetadataFixerResult.RepairStatus getStatus(MetadataFixerResult.RepairStatus status) {
        return status == MetadataFixerResult.RepairStatus.NO_ACTION ? MetadataFixerResult.RepairStatus.SUCCESS : status;
    }
}

