/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.parser.postscript;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSArray;
import org.verapdf.cos.COSBoolean;
import org.verapdf.cos.COSDictionary;
import org.verapdf.cos.COSInteger;
import org.verapdf.cos.COSName;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.cos.COSReal;
import org.verapdf.parser.postscript.PSObject;
import org.verapdf.parser.postscript.PSProcedure;
import org.verapdf.parser.postscript.PSStackMark;
import org.verapdf.parser.postscript.PostScriptException;

public class PSOperator
extends PSObject {
    private Stack<COSObject> operandStack;
    private Map<ASAtom, COSObject> userDict;
    private final String operator;

    public PSOperator(COSName operator) {
        super(operator);
        this.operator = operator.getString();
    }

    public PSOperator(COSObject operator) {
        super(operator.get());
        this.operator = operator.getString();
    }

    public String getOperator() {
        return this.operator;
    }

    @Override
    public void execute(Stack<COSObject> operandStack, Map<ASAtom, COSObject> userDict) throws PostScriptException {
        this.operandStack = operandStack;
        this.userDict = userDict;
        if (this.operator != null) {
            switch (this.operator) {
                case "{": 
                case "}": {
                    break;
                }
                case "if": {
                    this.opIf();
                    break;
                }
                case "ifelse": {
                    this.opIfElse();
                    break;
                }
                case "dup": {
                    operandStack.push(PSOperator.psCopyObject(operandStack.peek()));
                    break;
                }
                case "exch": {
                    COSObject obj1 = operandStack.pop();
                    COSObject obj2 = operandStack.pop();
                    operandStack.push(obj1);
                    operandStack.push(obj2);
                    break;
                }
                case "pop": {
                    operandStack.pop();
                    break;
                }
                case "copy": {
                    this.copy();
                    break;
                }
                case "index": {
                    this.index();
                    break;
                }
                case "roll": {
                    this.roll();
                    break;
                }
                case "clear": {
                    this.operandStack.clear();
                    break;
                }
                case "count": {
                    COSObject stackSize = COSInteger.construct(this.operandStack.size());
                    this.operandStack.push(stackSize);
                    break;
                }
                case "mark": {
                    this.operandStack.push(PSStackMark.getInstance());
                    break;
                }
                case "cleartomark": {
                    COSObject topObject = this.operandStack.peek();
                    while (!operandStack.empty() && topObject != PSStackMark.getInstance()) {
                        operandStack.pop();
                        topObject = this.operandStack.peek();
                    }
                    break;
                }
                case "counttomark": {
                    this.counttomark();
                    break;
                }
                case "and": 
                case "or": 
                case "xor": {
                    this.executeOperatorOnTopTwoBooleans(this.operator);
                    break;
                }
                case "not": {
                    operandStack.push(COSBoolean.construct(this.getTopBoolean().getBoolean() == false));
                    break;
                }
                case "true": {
                    operandStack.push(COSBoolean.construct(true));
                    break;
                }
                case "false": {
                    operandStack.push(COSBoolean.construct(false));
                    break;
                }
                case "bitshift": 
                case "abs": 
                case "neg": 
                case "ceiling": 
                case "floor": 
                case "round": 
                case "truncate": 
                case "sqrt": 
                case "cos": 
                case "atan": 
                case "sin": 
                case "exp": 
                case "cvi": 
                case "cvr": 
                case "ln": 
                case "log": {
                    this.executeOperatorOnOneTopNumber(this.operator);
                    break;
                }
                case "add": 
                case "div": 
                case "idiv": 
                case "mod": 
                case "mul": 
                case "sub": 
                case "eq": 
                case "ne": 
                case "gt": 
                case "ge": 
                case "lt": 
                case "le": {
                    this.executeOperatorOnTopTwoNumbers(this.operator);
                    break;
                }
                case "dict": {
                    this.getTopNumber();
                    operandStack.push(COSDictionary.construct());
                    break;
                }
                case "begin": {
                    if (operandStack.size() <= 0) break;
                    operandStack.pop();
                    break;
                }
                case "length": {
                    this.length();
                    break;
                }
                case "def": {
                    this.def();
                    break;
                }
                case "load": {
                    this.load();
                    break;
                }
                case "<<": {
                    this.mark();
                    break;
                }
                case ">>": {
                    this.closeDictionary();
                    break;
                }
                case "array": {
                    this.array();
                    break;
                }
                case "put": {
                    this.put();
                    break;
                }
                case "for": {
                    this.opFor();
                    break;
                }
                case "StandardEncoding": {
                    COSObject lastOperand;
                    if (operandStack.empty() || (lastOperand = operandStack.peek()).getType() != COSObjType.COS_NAME || !lastOperand.getString().equals("Encoding")) break;
                    operandStack.pop();
                    userDict.put(lastOperand.getName(), COSName.construct(ASAtom.STANDARD_ENCODING));
                    break;
                }
                default: {
                    COSObject dictEntry = userDict.get(ASAtom.getASAtom(this.operator));
                    if (dictEntry == null) break;
                    PSObject.getPSObject(dictEntry).execute(operandStack, userDict);
                }
            }
        }
    }

    private void closeDictionary() throws PostScriptException {
        COSObject dictionary = COSDictionary.construct();
        while (this.operandStack.size() > 1) {
            COSObject value = this.operandStack.pop();
            if (value == PSStackMark.getInstance()) {
                this.operandStack.add(dictionary);
                return;
            }
            COSObject key = this.operandStack.pop();
            if (key == PSStackMark.getInstance()) {
                throw new PostScriptException("Odd number of arguments between << and >> operators");
            }
            COSObjType keyType = key.getType();
            if (keyType != COSObjType.COS_NAME && keyType != COSObjType.COS_STRING) continue;
            dictionary.setKey(ASAtom.getASAtom(key.getString()), value);
        }
        if (!this.operandStack.empty() && this.operandStack.pop() == PSStackMark.getInstance()) {
            this.operandStack.add(dictionary);
            return;
        }
        throw new PostScriptException("Missing << operator before >> operator");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void opIfElse() throws PostScriptException {
        if (this.operandStack.size() < 3) throw new PostScriptException("No procedures for ifelse operator");
        COSObject falseProcedure = this.operandStack.pop();
        COSObject trueProcedure = this.operandStack.pop();
        COSObject bool = this.operandStack.pop();
        if (!(falseProcedure instanceof PSProcedure) || !(trueProcedure instanceof PSProcedure) || bool.getType() != COSObjType.COS_BOOLEAN) throw new PostScriptException("Can't execute ifelse operator");
        if (bool.getBoolean().booleanValue()) {
            ((PSProcedure)trueProcedure).modifiedExecuteProcedure(this.operandStack, this.userDict);
            return;
        } else {
            ((PSProcedure)falseProcedure).modifiedExecuteProcedure(this.operandStack, this.userDict);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void opIf() throws PostScriptException {
        if (this.operandStack.size() < 2) throw new PostScriptException("No procedures for if operator");
        COSObject procedure = this.operandStack.pop();
        COSObject bool = this.operandStack.pop();
        if (!(procedure instanceof PSProcedure) || bool.getType() != COSObjType.COS_BOOLEAN) throw new PostScriptException("Can't execute if operator");
        if (!bool.getBoolean().booleanValue()) return;
        ((PSProcedure)procedure).modifiedExecuteProcedure(this.operandStack, this.userDict);
    }

    private void copy() throws PostScriptException {
        try {
            ArrayList<COSObject> toAppend;
            COSObject n = this.getTopNumber();
            int size = this.operandStack.size();
            if ((long)size >= n.getInteger()) {
                List toCopy = this.operandStack.subList(size - n.getInteger().intValue(), size);
                toAppend = new ArrayList<COSObject>(toCopy.size());
                for (COSObject object : toCopy) {
                    toAppend.add(PSOperator.psCopyObject(object));
                }
            } else {
                throw new PostScriptException("Stack does not contain " + n.getInteger() + " elements to copy");
            }
            this.operandStack.addAll(toAppend);
        }
        catch (PostScriptException e) {
            throw new PostScriptException("Can't execute copy operator", e);
        }
    }

    private void index() throws PostScriptException {
        try {
            COSObject n = this.getTopNumber();
            if (this.operandStack.size() < n.getInteger().intValue()) {
                throw new PostScriptException("Stack does not contain " + n.getInteger() + " elements");
            }
            COSObject toCopy = (COSObject)this.operandStack.get(this.operandStack.size() - n.getInteger().intValue() - 1);
            this.operandStack.push(PSOperator.psCopyObject(toCopy));
        }
        catch (PostScriptException e) {
            throw new PostScriptException("Can't execute index operator", e);
        }
    }

    private void roll() throws PostScriptException {
        block7: {
            try {
                int size;
                COSObject[] topTwoNumbers = this.getTopTwoNumbers();
                int j = topTwoNumbers[0].getInteger().intValue();
                int n = topTwoNumbers[1].getInteger().intValue();
                if (j < 0) {
                    j = n - Math.abs(j) % n;
                }
                if ((size = this.operandStack.size()) >= n) {
                    int splitPoint;
                    int i;
                    ArrayList<COSObject> lastElements = new ArrayList<COSObject>();
                    for (int i2 = 0; i2 < n; ++i2) {
                        lastElements.add(this.operandStack.pop());
                    }
                    for (i = splitPoint = (j - 1) % n; i >= 0; --i) {
                        this.operandStack.push((COSObject)lastElements.get(i));
                    }
                    for (i = n - 1; i > splitPoint; --i) {
                        this.operandStack.push((COSObject)lastElements.get(i));
                    }
                    break block7;
                }
                throw new PostScriptException("Stack has less than n elements");
            }
            catch (PostScriptException e) {
                throw new PostScriptException("Can't execute roll operator", e);
            }
        }
    }

    private void counttomark() {
        long res = 0L;
        for (int i = this.operandStack.size() - 1; i >= 0; --i) {
            if (this.operandStack.get(i) == PSStackMark.getInstance() || i == 0) {
                this.operandStack.push(COSInteger.construct(res));
                return;
            }
            ++res;
        }
    }

    private void executeOperatorOnTopTwoNumbers(String operator) throws PostScriptException {
        try {
            COSObject res;
            COSObject[] topTwoNumbers = this.getTopTwoNumbers();
            switch (operator) {
                case "add": {
                    res = COSReal.construct(topTwoNumbers[1].getReal() + topTwoNumbers[0].getReal());
                    break;
                }
                case "div": {
                    res = COSReal.construct(topTwoNumbers[1].getReal() / topTwoNumbers[0].getReal());
                    break;
                }
                case "idiv": {
                    res = COSInteger.construct(topTwoNumbers[1].getInteger() / topTwoNumbers[0].getInteger());
                    break;
                }
                case "mod": {
                    res = COSInteger.construct(topTwoNumbers[1].getInteger() % topTwoNumbers[0].getInteger());
                    break;
                }
                case "mul": {
                    res = COSReal.construct(topTwoNumbers[1].getReal() * topTwoNumbers[0].getReal());
                    break;
                }
                case "sub": {
                    res = COSReal.construct(topTwoNumbers[1].getReal() - topTwoNumbers[0].getReal());
                    break;
                }
                case "eq": {
                    res = COSBoolean.construct(topTwoNumbers[1].getReal().equals(topTwoNumbers[0].getReal()));
                    break;
                }
                case "ne": {
                    res = COSBoolean.construct(!topTwoNumbers[1].getReal().equals(topTwoNumbers[0].getReal()));
                    break;
                }
                case "gt": {
                    res = COSBoolean.construct(topTwoNumbers[1].getReal() > topTwoNumbers[0].getReal());
                    break;
                }
                case "ge": {
                    res = COSBoolean.construct(topTwoNumbers[1].getReal() >= topTwoNumbers[0].getReal());
                    break;
                }
                case "lt": {
                    res = COSBoolean.construct(topTwoNumbers[1].getReal() < topTwoNumbers[0].getReal());
                    break;
                }
                case "le": {
                    res = COSBoolean.construct(topTwoNumbers[1].getReal() <= topTwoNumbers[0].getReal());
                    break;
                }
                default: {
                    throw new PostScriptException("Unknown operator " + operator);
                }
            }
            this.operandStack.push(res);
        }
        catch (PostScriptException e) {
            throw new PostScriptException("Can't execute " + operator + " operator", e);
        }
    }

    private void executeOperatorOnTopTwoBooleans(String operator) throws PostScriptException {
        try {
            COSObject res;
            COSObject[] topTwoBooleans = this.getTopTwoBooleans();
            switch (operator) {
                case "and": {
                    res = COSBoolean.construct(topTwoBooleans[1].getBoolean() != false && topTwoBooleans[0].getBoolean() != false);
                    break;
                }
                case "or": {
                    res = COSBoolean.construct(topTwoBooleans[1].getBoolean() != false || topTwoBooleans[0].getBoolean() != false);
                    break;
                }
                case "xor": {
                    res = COSBoolean.construct(topTwoBooleans[1].getBoolean() ^ topTwoBooleans[0].getBoolean());
                    break;
                }
                default: {
                    throw new PostScriptException("Unknown operator " + operator);
                }
            }
            this.operandStack.push(res);
        }
        catch (PostScriptException e) {
            throw new PostScriptException("Can't execute " + operator + " operator", e);
        }
    }

    private void executeOperatorOnOneTopNumber(String operator) throws PostScriptException {
        try {
            COSObject res;
            COSObject argument = this.getTopNumber();
            switch (operator) {
                case "abs": {
                    res = COSReal.construct(Math.abs(argument.getReal()));
                    break;
                }
                case "neg": {
                    res = COSReal.construct(-argument.getReal().doubleValue());
                    break;
                }
                case "ceiling": {
                    res = COSInteger.construct((long)Math.ceil(argument.getReal()));
                    break;
                }
                case "floor": {
                    res = COSInteger.construct((long)Math.floor(argument.getReal()));
                    break;
                }
                case "round": {
                    res = COSInteger.construct(Math.round(argument.getReal()));
                    break;
                }
                case "truncate": {
                    res = COSInteger.construct(argument.getReal().longValue());
                    break;
                }
                case "sqrt": {
                    res = COSReal.construct(Math.sqrt(argument.getReal()));
                    break;
                }
                case "cos": {
                    res = COSReal.construct(Math.cos(argument.getReal()));
                    break;
                }
                case "atan": {
                    res = COSReal.construct(Math.atan(argument.getReal()));
                    break;
                }
                case "sin": {
                    res = COSReal.construct(Math.sin(argument.getReal()));
                    break;
                }
                case "exp": {
                    res = COSReal.construct(Math.exp(argument.getReal()));
                    break;
                }
                case "cvi": {
                    res = COSInteger.construct(argument.getReal().intValue());
                    break;
                }
                case "cvr": {
                    res = COSReal.construct(argument.getReal());
                    break;
                }
                case "ln": {
                    res = COSReal.construct(Math.log(argument.getReal()));
                    break;
                }
                case "log": {
                    res = COSReal.construct(Math.log10(argument.getReal()));
                    break;
                }
                case "bitshift": {
                    res = COSInteger.construct(argument.getInteger() >> 1);
                    break;
                }
                default: {
                    throw new PostScriptException("Unknown operator " + operator);
                }
            }
            this.operandStack.push(res);
        }
        catch (PostScriptException e) {
            throw new PostScriptException("Can't execute " + operator + " operator", e);
        }
    }

    private void length() throws PostScriptException {
        COSObject topObject = this.popTopObject();
        if (topObject.getType().isDictionaryBased() || topObject.getType() == COSObjType.COS_ARRAY) {
            this.operandStack.push(COSInteger.construct(topObject.size().intValue()));
            return;
        }
        throw new PostScriptException("Can't execute length operator");
    }

    private void def() {
        if (this.operandStack.size() > 1) {
            COSObject value = this.operandStack.pop();
            COSObject key = this.operandStack.pop();
            COSObjType keyType = key.getType();
            if (keyType == COSObjType.COS_NAME || keyType == COSObjType.COS_STRING) {
                this.userDict.put(ASAtom.getASAtom(key.getString()), value);
            }
        }
    }

    private void load() throws PostScriptException {
        COSObject key = this.popTopObject();
        if (key.getType() == COSObjType.COS_STRING || key.getType() == COSObjType.COS_NAME) {
            ASAtom mapKey = ASAtom.getASAtom(key.getString());
            if (this.userDict.containsKey(mapKey)) {
                this.operandStack.push(this.userDict.get(mapKey));
            }
            return;
        }
        throw new PostScriptException("Can't execute load operator");
    }

    private void array() throws PostScriptException {
        try {
            int arraySize = this.getTopNumber().getInteger().intValue();
            COSObject array = COSArray.construct(arraySize);
            for (int i = 0; i < arraySize; ++i) {
                array.add(COSObject.getEmpty());
            }
            this.operandStack.push(array);
        }
        catch (PostScriptException e) {
            throw new PostScriptException("Can't execute array operator", e);
        }
    }

    private void put() throws PostScriptException {
        try {
            if (this.operandStack.size() >= 3) {
                COSObject toPut = this.operandStack.pop();
                COSObject index = this.getTopNumber();
                COSObject array = this.operandStack.pop();
                if (array.getType() == COSObjType.COS_ARRAY) {
                    int intIndex = index.getInteger().intValue();
                    if (array.size() <= intIndex || intIndex < 0) {
                        throw new PostScriptException("Index greater than array size or less than 0");
                    }
                    array.remove(intIndex);
                    array.insert(intIndex, toPut);
                    return;
                }
            }
            throw new PostScriptException("Problem with stack");
        }
        catch (PostScriptException e) {
            throw new PostScriptException("Can't execute put operator", e);
        }
    }

    private void opFor() throws PostScriptException {
        try {
            if (this.operandStack.empty()) {
                throw new PostScriptException("Problem with stack");
            }
            COSObject proc = this.operandStack.pop();
            if (!(proc instanceof PSProcedure)) {
                throw new PostScriptException("Object is not a procedure");
            }
            COSObject limit = this.getTopNumber();
            COSObject increment = this.getTopNumber();
            COSObject initial = this.getTopNumber();
            for (long i = initial.getInteger().longValue(); i <= limit.getInteger(); i += increment.getInteger().longValue()) {
                this.operandStack.push(COSInteger.construct(i));
                ((PSProcedure)proc).executeProcedure(this.operandStack, this.userDict);
            }
        }
        catch (PostScriptException e) {
            throw new PostScriptException("Can't execute for operator", e);
        }
    }

    private COSObject[] getTopTwoNumbers() throws PostScriptException {
        COSObject b;
        COSObject a;
        if (this.operandStack.size() > 1 && (a = this.operandStack.pop()).getType().isNumber() && (b = this.operandStack.pop()).getType().isNumber()) {
            return new COSObject[]{a, b};
        }
        throw new PostScriptException("Stack doesn't have two elements or top two elements are not two numbers");
    }

    private COSObject[] getTopTwoBooleans() throws PostScriptException {
        COSObject b;
        COSObject a;
        if (this.operandStack.size() > 1 && (a = this.operandStack.pop()).getType().isBoolean() && (b = this.operandStack.pop()).getType().isBoolean()) {
            return new COSObject[]{a, b};
        }
        throw new PostScriptException("Stack doesn't have two elements or top two elements are not two booleans");
    }

    private COSObject getTopNumber() throws PostScriptException {
        COSObject object = this.popTopObject();
        if (object.getType().isNumber()) {
            return object;
        }
        throw new PostScriptException("Stack is empty or top element is not a number");
    }

    private COSObject getTopBoolean() throws PostScriptException {
        COSObject object = this.popTopObject();
        if (object.getType().isBoolean()) {
            return object;
        }
        throw new PostScriptException("Stack is empty or top element is not a boolean");
    }

    private COSObject popTopObject() throws PostScriptException {
        if (!this.operandStack.empty()) {
            return this.operandStack.pop();
        }
        throw new PostScriptException("Operand stack is empty");
    }

    private static COSObject psCopyObject(COSObject toCopy) {
        switch (toCopy.getType()) {
            case COS_BOOLEAN: {
                return COSBoolean.construct(toCopy.getBoolean());
            }
            case COS_INTEGER: {
                return COSInteger.construct(toCopy.getInteger());
            }
            case COS_NAME: {
                return COSName.construct(toCopy.getName());
            }
            case COS_REAL: {
                return COSReal.construct(toCopy.getReal());
            }
        }
        return toCopy;
    }
}

