/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.pd.colors;

import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSObject;
import org.verapdf.pd.colors.PDCIEDictionaryBased;
import org.verapdf.tools.TypeConverter;

public class PDLab
extends PDCIEDictionaryBased {
    public PDLab() {
    }

    public PDLab(COSObject obj) {
        super(obj);
    }

    @Override
    public int getNumberOfComponents() {
        return 3;
    }

    @Override
    public ASAtom getType() {
        return ASAtom.LAB;
    }

    @Override
    public double[] toRGB(double[] value) {
        double lstar = (value[0] + 16.0) * 0.008620689655172414;
        double x = this.wpX * this.inverse(lstar + value[1] * 0.002);
        double y = this.wpY * this.inverse(lstar);
        double z = this.wpZ * this.inverse(lstar - value[2] * 0.005);
        return this.convXYZtoRGB(x, y, z);
    }

    public double[] getRange() {
        double[] dArray;
        double[] res = TypeConverter.getRealArray(this.dictionary.getKey(ASAtom.RANGE), 4, "Range");
        if (res != null) {
            dArray = res;
        } else {
            double[] dArray2 = new double[4];
            dArray2[0] = -100.0;
            dArray2[1] = 100.0;
            dArray2[2] = -100.0;
            dArray = dArray2;
            dArray2[3] = 100.0;
        }
        return dArray;
    }

    private double inverse(double x) {
        if (x > 0.20689655172413793) {
            return x * x * x;
        }
        return 0.12841854934601665 * (x - 0.13793103448275862);
    }
}

