/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.pd.font;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSArray;
import org.verapdf.cos.COSBase;
import org.verapdf.cos.COSDictionary;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.cos.COSStream;
import org.verapdf.pd.PDResource;
import org.verapdf.pd.font.Encoding;
import org.verapdf.pd.font.FontProgram;
import org.verapdf.pd.font.PDFontDescriptor;
import org.verapdf.pd.font.cmap.PDCMap;
import org.verapdf.pd.font.type1.PDType1Font;
import org.verapdf.pd.font.type3.PDType3Font;

public abstract class PDFont
extends PDResource {
    private static final Map<String, Double> weightNames = new LinkedHashMap<String, Double>();
    private static final Logger LOGGER = Logger.getLogger(PDFont.class.getCanonicalName());
    protected COSDictionary dictionary;
    protected PDFontDescriptor fontDescriptor;
    protected PDCMap toUnicodeCMap;
    protected boolean isFontParsed = false;
    protected FontProgram fontProgram;
    protected Encoding encoding = null;
    private boolean successfullyParsed = false;
    private final String fontName;
    private final String fontNameWithoutSubset;
    private final ASAtom subtype;
    protected double[] boundingBox;
    private Double fontWeight;

    public PDFont(COSDictionary dictionary) {
        super(new COSObject(dictionary));
        if (dictionary == null) {
            dictionary = (COSDictionary)COSDictionary.construct().get();
        }
        this.dictionary = dictionary;
        COSObject fd = dictionary.getKey(ASAtom.FONT_DESC);
        this.fontDescriptor = fd != null && fd.getType() == COSObjType.COS_DICT ? new PDFontDescriptor(fd) : new PDFontDescriptor(COSDictionary.construct());
        this.fontName = this.dictionary.getNameKeyStringValue(ASAtom.BASE_FONT);
        String string = this.fontName != null ? (this.fontName.matches("^[A-Z]{6}+.+") ? this.fontName.substring(7) : this.fontName) : (this.fontNameWithoutSubset = null);
        if (!(this instanceof PDType3Font)) {
            this.boundingBox = this.fontDescriptor.getFontBoundingBox();
            if (this.boundingBox == null) {
                this.boundingBox = new double[]{0.0, 0.0, 1000.0, 1000.0};
            }
        }
        this.subtype = this.dictionary.getNameKey(ASAtom.SUBTYPE);
    }

    public COSDictionary getDictionary() {
        return this.dictionary;
    }

    public PDFontDescriptor getFontDescriptor() {
        return this.fontDescriptor;
    }

    public String getType() {
        String type = this.dictionary.getNameKeyStringValue(ASAtom.TYPE);
        return type == null ? "" : type;
    }

    public ASAtom getSubtype() {
        return this.subtype;
    }

    public boolean isSymbolic() {
        return this.fontDescriptor.isSymbolic();
    }

    public Encoding getEncodingMapping() {
        if (this.encoding == null) {
            this.encoding = this.calculateEncodingMapping();
        }
        return this.encoding;
    }

    protected Encoding calculateEncodingMapping() {
        return PDFont.getEncodingMappingFromCOSObject(this.getEncoding());
    }

    public Double getFontWeight() {
        if (this.fontWeight == null) {
            this.fontWeight = this.fontDescriptor.getFontWeight();
            if (this.fontWeight == null) {
                this.detectFontWeight();
            }
        }
        return this.fontWeight;
    }

    private static Encoding getEncodingMappingFromCOSObject(COSObject e) {
        COSBase cosEncoding = e.getDirectBase();
        if (cosEncoding != null) {
            if (cosEncoding.getType() == COSObjType.COS_NAME) {
                Encoding encodingObj = new Encoding(cosEncoding.getName());
                return encodingObj;
            }
            if (cosEncoding.getType() == COSObjType.COS_DICT) {
                Encoding encodingObj = new Encoding(cosEncoding.getNameKey(ASAtom.BASE_ENCODING), PDFont.getDifferencesFromCosEncoding(e));
                return encodingObj;
            }
        }
        return Encoding.empty();
    }

    public String getName() {
        return this.fontName;
    }

    public String getNameWithoutSubset() {
        return this.fontNameWithoutSubset;
    }

    public double[] getBoundingBox() {
        return this.boundingBox;
    }

    public COSObject getEncoding() {
        return this.dictionary.getKey(ASAtom.ENCODING);
    }

    public Map<Integer, String> getDifferences() {
        return PDFont.getDifferencesFromCosEncoding(this.getEncoding());
    }

    public static Map<Integer, String> getDifferencesFromCosEncoding(COSObject e) {
        COSArray differences;
        COSObject cosDifferences = e.getKey(ASAtom.DIFFERENCES);
        if (cosDifferences == null) {
            return Collections.emptyMap();
        }
        if (cosDifferences.getType() == COSObjType.COS_ARRAY) {
            differences = (COSArray)cosDifferences.getDirectBase();
        } else {
            if (!cosDifferences.empty()) {
                LOGGER.log(Level.SEVERE, "Value of Differences key is not an array. Ignoring Difference");
            }
            differences = null;
        }
        if (differences == null) {
            return Collections.emptyMap();
        }
        HashMap<Integer, String> res = new HashMap<Integer, String>();
        int diffIndex = 0;
        for (COSObject obj : differences) {
            if (obj.getType() == COSObjType.COS_INTEGER) {
                diffIndex = obj.getInteger().intValue();
                continue;
            }
            if (obj.getType() != COSObjType.COS_NAME || diffIndex == -1) continue;
            res.put(diffIndex++, obj.getString());
        }
        return res;
    }

    public COSObject getWidths() {
        return this.dictionary.getKey(ASAtom.WIDTHS);
    }

    public Long getFirstChar() {
        return this.dictionary.getIntegerKey(ASAtom.FIRST_CHAR);
    }

    public Long getLastChar() {
        return this.dictionary.getIntegerKey(ASAtom.LAST_CHAR);
    }

    public int readCode(InputStream stream) throws IOException {
        return stream.read();
    }

    public abstract FontProgram getFontProgram();

    public abstract float getWidthFromProgram(int var1);

    public abstract boolean glyphIsPresent(int var1);

    public String toUnicode(int code) {
        return this.cMapToUnicode(code);
    }

    public String cMapToUnicode(int code) {
        if (this.toUnicodeCMap == null) {
            this.toUnicodeCMap = new PDCMap(this.dictionary.getKey(ASAtom.TO_UNICODE));
        }
        if (this.toUnicodeCMap.getCMapName() != null && this.toUnicodeCMap.isIdentity()) {
            return new String(new char[]{(char)code});
        }
        return this.toUnicodeCMap.toUnicode(code);
    }

    public ASAtom getProgramSubtype() {
        COSStream fontFile = this.fontDescriptor.getFontFile();
        if (fontFile == null && (fontFile = this.fontDescriptor.getFontFile2()) == null) {
            fontFile = this.fontDescriptor.getFontFile3();
        }
        return fontFile == null ? null : fontFile.getNameKey(ASAtom.SUBTYPE);
    }

    public Double getWidth(int code) {
        if (this.dictionary.knownKey(ASAtom.WIDTHS).booleanValue() && this.dictionary.knownKey(ASAtom.FIRST_CHAR).booleanValue() && this.dictionary.knownKey(ASAtom.LAST_CHAR).booleanValue()) {
            int firstChar = this.dictionary.getIntegerKey(ASAtom.FIRST_CHAR).intValue();
            int lastChar = this.dictionary.getIntegerKey(ASAtom.LAST_CHAR).intValue();
            COSObject widths = this.getWidths();
            if (widths.getType() == COSObjType.COS_ARRAY && widths.size() > 0 && code >= firstChar && code <= lastChar) {
                return widths.at(code - firstChar).getReal();
            }
        }
        if (this.fontDescriptor.knownKey(ASAtom.MISSING_WIDTH)) {
            return this.fontDescriptor.getMissingWidth();
        }
        if (this instanceof PDType3Font || this instanceof PDType1Font) {
            return null;
        }
        return 0.0;
    }

    public Double getDefaultWidth() {
        return this.fontDescriptor.getMissingWidth();
    }

    public boolean isSuccessfullyParsed() {
        return this.successfullyParsed;
    }

    public void setSuccessfullyParsed(boolean successfullyParsed) {
        this.successfullyParsed = successfullyParsed;
    }

    protected boolean isSubset() {
        String[] nameSplitting = this.getName().split("\\+");
        return nameSplitting[0].length() == 6;
    }

    public Double getAscent() {
        FontProgram program = this.getFontProgram();
        return program != null ? program.getAscent() : null;
    }

    public Double getDescent() {
        FontProgram program = this.getFontProgram();
        return program != null ? program.getDescent() : null;
    }

    private void detectFontWeight() {
        FontProgram program = this.getFontProgram();
        if (program != null) {
            this.fontWeight = weightNames.get(program.getWeight());
        }
        if (this.fontWeight == null) {
            if (this.fontNameWithoutSubset != null) {
                for (Map.Entry<String, Double> entry : weightNames.entrySet()) {
                    if (!this.fontNameWithoutSubset.contains(entry.getKey())) continue;
                    this.fontWeight = entry.getValue();
                    return;
                }
            }
            this.fontWeight = 400.0;
        }
    }

    static {
        weightNames.put("Thin", 100.0);
        weightNames.put("ExtraLight", 200.0);
        weightNames.put("Extra Light", 200.0);
        weightNames.put("Extra-Light", 200.0);
        weightNames.put("UltraLight", 200.0);
        weightNames.put("Ultra Light", 200.0);
        weightNames.put("Ultra-Light", 200.0);
        weightNames.put("Light", 300.0);
        weightNames.put("Normal", 400.0);
        weightNames.put("Book", 400.0);
        weightNames.put("Regular", 400.0);
        weightNames.put("Medium", 500.0);
        weightNames.put("Semibold", 600.0);
        weightNames.put("SemiBold", 600.0);
        weightNames.put("Semi Bold", 600.0);
        weightNames.put("Semi-Bold", 600.0);
        weightNames.put("DemiBold", 600.0);
        weightNames.put("Demi Bold", 600.0);
        weightNames.put("Demi-Bold", 600.0);
        weightNames.put("ExtraBold", 800.0);
        weightNames.put("Extra Bold", 800.0);
        weightNames.put("Extra-Bold", 800.0);
        weightNames.put("UltraBold", 800.0);
        weightNames.put("Ultra Bold", 800.0);
        weightNames.put("Ultra-Bold", 800.0);
        weightNames.put("Bold", 700.0);
        weightNames.put("Black", 900.0);
        weightNames.put("Heavy", 900.0);
    }
}

