/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.tools;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSKey;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.pd.structure.PDMCRDictionary;
import org.verapdf.pd.structure.PDNameSpaceRoleMapping;
import org.verapdf.pd.structure.PDOBJRDictionary;
import org.verapdf.pd.structure.PDStructElem;
import org.verapdf.pd.structure.PDStructureNameSpace;
import org.verapdf.pd.structure.StructureType;
import org.verapdf.tools.StaticResources;

public class TaggedPDFHelper {
    private static final Logger LOGGER = Logger.getLogger(TaggedPDFHelper.class.getCanonicalName());
    private static final Set<String> PDF_1_4_STANDARD_ROLE_TYPES;
    private static final Set<String> PDF_1_7_STANDARD_ROLE_TYPES;
    private static final Set<String> PDF_2_0_STANDARD_ROLE_TYPES;
    private static final Set<String> WCAG_STANDARD_ROLE_TYPES;
    private static final int MAX_NUMBER_OF_ELEMENTS = 1;
    private static final Map<ASAtom, Set<COSKey>> visitedWithNS;
    private static final Set<ASAtom> visitedWithoutNS;

    private TaggedPDFHelper() {
    }

    public static StructureType getDefaultStructureType(StructureType type) {
        if (type == null) {
            return null;
        }
        visitedWithNS.clear();
        visitedWithoutNS.clear();
        TaggedPDFHelper.addVisited(type);
        StructureType curr = TaggedPDFHelper.getEquivalent(type, StaticResources.getRoleMapHelper().getRoleMap());
        if (curr == null || TaggedPDFHelper.isVisited(curr)) {
            return TaggedPDFHelper.isStandardType(type) ? type : null;
        }
        while (curr != null && !TaggedPDFHelper.isVisited(curr)) {
            if (TaggedPDFHelper.isStandardType(curr)) {
                return curr;
            }
            TaggedPDFHelper.addVisited(curr);
            curr = TaggedPDFHelper.getEquivalent(curr, StaticResources.getRoleMapHelper().getRoleMap());
        }
        return null;
    }

    public static String getRoleMapToSameNamespaceTag(StructureType type) {
        if (type == null) {
            return null;
        }
        visitedWithNS.clear();
        visitedWithoutNS.clear();
        TaggedPDFHelper.addVisited(type);
        StructureType prev = type;
        StructureType curr = TaggedPDFHelper.getEquivalent(prev, Collections.emptyMap());
        while (curr != null) {
            if (curr.getNameSpaceURI() != null && curr.getNameSpaceURI().equals(prev.getNameSpaceURI())) {
                return prev.getNameSpaceURI() + ":" + (prev.getType() != null ? prev.getType().getValue() : null);
            }
            if (TaggedPDFHelper.isVisited(curr) || TaggedPDFHelper.isStandardType(curr)) {
                return null;
            }
            TaggedPDFHelper.addVisited(curr);
            prev = curr;
            curr = TaggedPDFHelper.getEquivalent(prev, Collections.emptyMap());
        }
        return null;
    }

    private static StructureType getEquivalent(StructureType type, Map<ASAtom, ASAtom> roleMap) {
        ASAtom equiv;
        PDStructureNameSpace nameSpace = type.getNameSpace();
        if (nameSpace != null) {
            PDNameSpaceRoleMapping nameSpaceMapping = nameSpace.getNameSpaceMapping();
            if (nameSpaceMapping != null) {
                return nameSpaceMapping.getEquivalentType(type.getType());
            }
            if (!"http://iso.org/pdf/ssn".equals(nameSpace.getNS())) {
                return null;
            }
        }
        return (equiv = roleMap.get(type.getType())) == null ? null : StructureType.createStructureType(equiv);
    }

    public static boolean isStandardType(StructureType type) {
        String structureType = type.getType().getValue();
        PDStructureNameSpace nameSpace = type.getNameSpace();
        if (nameSpace != null && nameSpace.getNS() != null) {
            switch (nameSpace.getNS()) {
                case "http://iso.org/pdf/ssn": {
                    return PDF_1_7_STANDARD_ROLE_TYPES.contains(structureType);
                }
                case "http://iso.org/pdf2/ssn": {
                    return PDF_2_0_STANDARD_ROLE_TYPES.contains(structureType) || structureType.matches("^H[1-9][0-9]*$");
                }
                case "http://www.w3.org/1998/Math/MathML": {
                    return true;
                }
            }
            return false;
        }
        return PDF_1_7_STANDARD_ROLE_TYPES.contains(structureType);
    }

    public static boolean isWCAGStandardType(StructureType type) {
        String structureType = type.getType().getValue();
        return WCAG_STANDARD_ROLE_TYPES.contains(structureType);
    }

    private static void addVisited(StructureType type) {
        ASAtom structType = type.getType();
        PDStructureNameSpace nameSpace = type.getNameSpace();
        if (nameSpace != null) {
            Set<Object> nameSpaces;
            if (visitedWithNS.containsKey(structType)) {
                nameSpaces = visitedWithNS.get(structType);
            } else {
                nameSpaces = new HashSet();
                visitedWithNS.put(structType, nameSpaces);
            }
            COSKey key = nameSpace.getObject().getObjectKey();
            nameSpaces.add(key);
        } else {
            visitedWithoutNS.add(structType);
        }
    }

    private static boolean isVisited(StructureType type) {
        ASAtom structType = type.getType();
        PDStructureNameSpace nameSpace = type.getNameSpace();
        if (nameSpace != null) {
            if (visitedWithNS.containsKey(structType)) {
                Set<COSKey> nameSpaces = visitedWithNS.get(structType);
                COSKey key = nameSpace.getObject().getObjectKey();
                return nameSpaces.contains(key);
            }
            return false;
        }
        return visitedWithoutNS.contains(structType);
    }

    public static List<PDStructElem> getStructNodeStructChildren(COSObject parent) {
        return TaggedPDFHelper.getStructChildren(parent, true);
    }

    public static List<Object> getStructNodeChildren(COSObject parent) {
        return TaggedPDFHelper.getChildren(parent, true);
    }

    private static List<Object> getChildren(COSObject parent, boolean checkType) {
        if (parent == null || parent.getType() != COSObjType.COS_DICT) {
            LOGGER.log(Level.FINE, "Parent element for struct elements is null or not a COSDictionary");
            return Collections.emptyList();
        }
        COSObject children = parent.getKey(ASAtom.K);
        if (children != null) {
            if (TaggedPDFHelper.isStructElem(children, checkType)) {
                ArrayList<PDStructElem> list = new ArrayList<PDStructElem>(1);
                list.add(new PDStructElem(children));
                return Collections.unmodifiableList(list);
            }
            if (TaggedPDFHelper.isMCR(children)) {
                ArrayList<PDMCRDictionary> list = new ArrayList<PDMCRDictionary>(1);
                list.add(new PDMCRDictionary(children));
                return Collections.unmodifiableList(list);
            }
            if (children.getType() == COSObjType.COS_INTEGER) {
                ArrayList<COSObject> list = new ArrayList<COSObject>(1);
                list.add(children);
                return Collections.unmodifiableList(list);
            }
            if (children.getType() == COSObjType.COS_ARRAY) {
                return TaggedPDFHelper.getChildrenFromArray(children, checkType);
            }
            if (TaggedPDFHelper.isOBJR(children)) {
                ArrayList<PDOBJRDictionary> list = new ArrayList<PDOBJRDictionary>(1);
                list.add(new PDOBJRDictionary(children));
                return Collections.unmodifiableList(list);
            }
        }
        return Collections.emptyList();
    }

    private static List<PDStructElem> getStructChildren(COSObject parent, boolean checkType) {
        if (parent == null || parent.getType() != COSObjType.COS_DICT) {
            LOGGER.log(Level.FINE, "Parent element for struct elements is null or not a COSDictionary");
            return Collections.emptyList();
        }
        COSObject children = parent.getKey(ASAtom.K);
        if (children != null) {
            if (TaggedPDFHelper.isStructElem(children, checkType)) {
                ArrayList<PDStructElem> list = new ArrayList<PDStructElem>(1);
                list.add(new PDStructElem(children));
                return Collections.unmodifiableList(list);
            }
            if (children.getType() == COSObjType.COS_ARRAY) {
                return TaggedPDFHelper.getStructChildrenFromArray(children, checkType);
            }
        }
        return Collections.emptyList();
    }

    private static List<PDStructElem> getStructChildrenFromArray(COSObject children, boolean checkType) {
        if (children.size() > 0) {
            ArrayList<PDStructElem> list = new ArrayList<PDStructElem>();
            for (int i = 0; i < children.size(); ++i) {
                COSObject elem = children.at(i);
                if (!TaggedPDFHelper.isStructElem(elem, checkType)) continue;
                list.add(new PDStructElem(elem));
            }
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private static List<Object> getChildrenFromArray(COSObject children, boolean checkType) {
        if (children.size() > 0) {
            ArrayList<Object> list = new ArrayList<Object>();
            for (int i = 0; i < children.size(); ++i) {
                COSObject elem = children.at(i);
                if (TaggedPDFHelper.isStructElem(elem, checkType)) {
                    list.add(new PDStructElem(elem));
                    continue;
                }
                if (TaggedPDFHelper.isMCR(elem)) {
                    list.add(new PDMCRDictionary(elem));
                    continue;
                }
                if (elem.getType() == COSObjType.COS_INTEGER) {
                    list.add(elem);
                    continue;
                }
                if (!TaggedPDFHelper.isOBJR(elem)) continue;
                list.add(new PDOBJRDictionary(elem));
            }
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private static boolean isStructElem(COSObject dictionary, boolean checkType) {
        if (dictionary == null || dictionary.getType() != COSObjType.COS_DICT) {
            return false;
        }
        ASAtom type = dictionary.getNameKey(ASAtom.TYPE);
        return !checkType || type == null || type.equals(ASAtom.STRUCT_ELEM);
    }

    public static boolean isMCR(COSObject obj) {
        if (obj == null || obj.empty()) {
            return false;
        }
        if (!obj.getType().isDictionaryBased()) {
            return false;
        }
        ASAtom type = obj.getNameKey(ASAtom.TYPE);
        return ASAtom.MCR.equals(type);
    }

    public static boolean isOBJR(COSObject obj) {
        if (obj == null || obj.empty()) {
            return false;
        }
        if (!obj.getType().isDictionaryBased()) {
            return false;
        }
        ASAtom type = obj.getNameKey(ASAtom.TYPE);
        return ASAtom.OBJR.equals(type);
    }

    public static boolean isContentItem(COSObject obj) {
        if (obj == null || obj.empty()) {
            return false;
        }
        if (obj.getType() == COSObjType.COS_INTEGER) {
            return true;
        }
        if (!obj.getType().isDictionaryBased()) {
            return false;
        }
        ASAtom type = obj.getNameKey(ASAtom.TYPE);
        return type == ASAtom.MCR || type == ASAtom.OBJR;
    }

    public static Set<String> getPdf14StandardRoleTypes() {
        return PDF_1_4_STANDARD_ROLE_TYPES;
    }

    public static Set<String> getPdf17StandardRoleTypes() {
        return PDF_1_7_STANDARD_ROLE_TYPES;
    }

    public static Set<String> getPdf20StandardRoleTypes() {
        return PDF_2_0_STANDARD_ROLE_TYPES;
    }

    public static Set<String> getWcagStandardRoleTypes() {
        return WCAG_STANDARD_ROLE_TYPES;
    }

    static {
        HashSet<String> tempSet = new HashSet<String>();
        tempSet.add("Document");
        tempSet.add("Part");
        tempSet.add("Div");
        tempSet.add("Caption");
        tempSet.add("Sect");
        tempSet.add("NonStruct");
        tempSet.add("H");
        tempSet.add("P");
        tempSet.add("L");
        tempSet.add("LI");
        tempSet.add("Lbl");
        tempSet.add("LBody");
        tempSet.add("Table");
        tempSet.add("TR");
        tempSet.add("TH");
        tempSet.add("TD");
        tempSet.add("Span");
        tempSet.add("Link");
        tempSet.add("Figure");
        tempSet.add("Formula");
        tempSet.add("Form");
        HashSet<String> pdf_1_7 = new HashSet<String>(tempSet);
        pdf_1_7.add("Art");
        pdf_1_7.add("BlockQuote");
        pdf_1_7.add("TOC");
        pdf_1_7.add("TOCI");
        pdf_1_7.add("Index");
        pdf_1_7.add("Private");
        pdf_1_7.add("Quote");
        pdf_1_7.add("Note");
        pdf_1_7.add("Reference");
        pdf_1_7.add("BibEntry");
        pdf_1_7.add("Code");
        pdf_1_7.add("H1");
        pdf_1_7.add("H2");
        pdf_1_7.add("H3");
        pdf_1_7.add("H4");
        pdf_1_7.add("H5");
        pdf_1_7.add("H6");
        HashSet pdf_1_4 = new HashSet(pdf_1_7);
        HashSet<String> pdf_2_0 = new HashSet<String>(tempSet);
        tempSet = new HashSet();
        tempSet.add("THead");
        tempSet.add("TBody");
        tempSet.add("TFoot");
        tempSet.add("Annot");
        tempSet.add("Ruby");
        tempSet.add("Warichu");
        tempSet.add("RB");
        tempSet.add("RT");
        tempSet.add("RP");
        tempSet.add("WT");
        tempSet.add("WP");
        pdf_1_7.addAll(tempSet);
        pdf_2_0.addAll(tempSet);
        HashSet<String> wcag = new HashSet<String>(pdf_1_7);
        wcag.add("Artifact");
        wcag.add("Title");
        pdf_2_0.add("DocumentFragment");
        pdf_2_0.add("Aside");
        pdf_2_0.add("Title");
        pdf_2_0.add("FENote");
        pdf_2_0.add("Sub");
        pdf_2_0.add("Em");
        pdf_2_0.add("Strong");
        pdf_2_0.add("Artifact");
        PDF_1_4_STANDARD_ROLE_TYPES = Collections.unmodifiableSet(pdf_1_4);
        PDF_1_7_STANDARD_ROLE_TYPES = Collections.unmodifiableSet(pdf_1_7);
        PDF_2_0_STANDARD_ROLE_TYPES = Collections.unmodifiableSet(pdf_2_0);
        WCAG_STANDARD_ROLE_TYPES = Collections.unmodifiableSet(wcag);
        visitedWithNS = new HashMap<ASAtom, Set<COSKey>>();
        visitedWithoutNS = new HashSet<ASAtom>();
    }
}

