/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.pd.font.type1;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.verapdf.as.ASAtom;
import org.verapdf.as.CharTable;
import org.verapdf.as.io.ASInputStream;
import org.verapdf.cos.COSArray;
import org.verapdf.cos.COSKey;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.parser.SeekableBaseParser;
import org.verapdf.parser.Token;
import org.verapdf.parser.postscript.PSObject;
import org.verapdf.parser.postscript.PSOperator;
import org.verapdf.parser.postscript.PSParser;
import org.verapdf.parser.postscript.PostScriptException;
import org.verapdf.pd.font.FontProgram;
import org.verapdf.pd.font.truetype.TrueTypePredefined;
import org.verapdf.pd.font.type1.EexecFilterDecode;
import org.verapdf.pd.font.type1.Type1PrivateParser;
import org.verapdf.tools.resource.ASFileStreamCloser;

public class Type1FontProgram
extends PSParser
implements FontProgram {
    public static final Logger LOGGER = Logger.getLogger(Type1FontProgram.class.getCanonicalName());
    static final double[] DEFAULT_FONT_MATRIX = new double[]{0.001, 0.0, 0.0, 0.001, 0.0, 0.0};
    private final COSKey key;
    private String[] encoding = new String[256];
    private Map<String, Integer> glyphWidths;
    private static final byte[] CLEAR_TO_MARK_BYTES = "cleartomark".getBytes(StandardCharsets.ISO_8859_1);
    private boolean attemptedParsing = false;
    private boolean successfullyParsed = false;
    public static final Set<String> OPERATORS_KEYWORDS;

    public Type1FontProgram(ASInputStream fileStream, COSKey key) throws IOException {
        super(fileStream);
        this.key = key;
    }

    @Override
    public void parseFont() throws IOException {
        if (!this.attemptedParsing) {
            try {
                this.attemptedParsing = true;
                byte first = this.getSource().readByte();
                if (first == -128) {
                    byte second = this.getSource().readByte();
                    if (second == 1) {
                        LOGGER.log(Level.WARNING, "Type 1 fonts in PFB format are not permitted");
                    }
                    this.getSource().unread();
                }
                this.getSource().unread();
                this.getBaseParser().initializeToken();
                this.getBaseParser().skipSpaces(true);
                while (this.getBaseParser().getToken().type != Token.Type.TT_EOF) {
                    this.processObject(this.nextObject());
                }
                this.initializeEncoding();
                if (this.glyphWidths == null) {
                    throw new IOException("Type 1 font doesn't contain charstrings.");
                }
                this.successfullyParsed = true;
            }
            catch (PostScriptException e) {
                throw new IOException("Error in PostScript parsing", e);
            }
            finally {
                this.getSource().close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processObject(COSObject nextObject) throws IOException, PostScriptException {
        block16: {
            if (nextObject.getType() == COSObjType.COS_NAME && nextObject.getString().equals("eexec")) {
                this.skipSpacesExceptNullByte();
                try (ASInputStream eexecEncoded = this.getSource().getStreamUntilToken(CLEAR_TO_MARK_BYTES);){
                    SeekableBaseParser parser = null;
                    try (EexecFilterDecode eexecDecoded = new EexecFilterDecode(eexecEncoded, false);){
                        parser = new Type1PrivateParser(eexecDecoded, this.getFontMatrix(), this.key);
                        ((Type1PrivateParser)parser).parse();
                        this.glyphWidths = ((Type1PrivateParser)parser).getGlyphWidths();
                        break block16;
                    }
                    finally {
                        if (parser != null) {
                            parser.closeInputStream();
                        }
                    }
                }
            }
            this.toExecute(nextObject);
        }
    }

    private void toExecute(COSObject next) throws PostScriptException {
        PSObject operator = PSObject.getPSObject(next);
        if (operator instanceof PSOperator) {
            if (!OPERATORS_KEYWORDS.contains(((PSOperator)operator).getOperator())) {
                COSObject dictEntry = (COSObject)this.userDict.get(ASAtom.getASAtom(((PSOperator)operator).getOperator()));
                if (dictEntry != null) {
                    this.toExecute(dictEntry);
                }
            } else {
                operator.execute(this.operandStack, this.userDict);
            }
        } else {
            operator.execute(this.operandStack, this.userDict);
        }
    }

    @Override
    public float getWidth(int charCode) {
        try {
            Integer res;
            if (this.glyphWidths != null && (res = this.glyphWidths.get(this.getGlyph(charCode))) != null) {
                return res.intValue();
            }
            return -1.0f;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return -1.0f;
        }
    }

    @Override
    public float getWidth(String glyphName) {
        Integer res = this.glyphWidths.get(glyphName);
        return res == null ? -1.0f : (float)res.intValue();
    }

    protected void skipSpacesExceptNullByte() throws IOException {
        while (!this.getSource().isEOF()) {
            byte ch = this.getSource().readByte();
            if (CharTable.isSpace(ch) && ch != 0) continue;
            this.getSource().unread();
            break;
        }
    }

    @Override
    public boolean containsCode(int code) {
        String glyphName = this.getGlyph(code);
        return this.containsGlyph(glyphName);
    }

    @Override
    public boolean containsGlyph(String glyphName) {
        return this.glyphWidths != null && this.glyphWidths.containsKey(glyphName) && !glyphName.equals(".notdef");
    }

    @Override
    public boolean containsCID(int cid) {
        return false;
    }

    @Override
    public boolean isAttemptedParsing() {
        return this.attemptedParsing;
    }

    @Override
    public boolean isSuccessfulParsing() {
        return this.successfullyParsed;
    }

    public String[] getEncoding() {
        return this.encoding;
    }

    public Set<String> getCharSet() {
        return this.glyphWidths.keySet();
    }

    private double[] getFontMatrix() {
        COSObject fontMatrixObject = this.getObjectFromUserDict(ASAtom.getASAtom("FontMatrix"));
        if (fontMatrixObject != null && fontMatrixObject.getType() == COSObjType.COS_ARRAY) {
            double[] res = new double[6];
            int pointer = 0;
            for (COSObject obj : (COSArray)fontMatrixObject.get()) {
                if (!obj.getType().isNumber()) continue;
                res[pointer++] = obj.getReal();
            }
            return res;
        }
        return DEFAULT_FONT_MATRIX;
    }

    private void initializeEncoding() {
        COSObject encoding = this.getObjectFromUserDict(ASAtom.getASAtom("Encoding"));
        if (encoding != null) {
            if (encoding.getType() == COSObjType.COS_ARRAY) {
                int pointer = 0;
                for (COSObject obj : (COSArray)encoding.get()) {
                    if (pointer >= 256) continue;
                    String glyphName = obj.getString();
                    this.encoding[pointer++] = glyphName == null ? "" : glyphName;
                }
            } else if (encoding.getType() == COSObjType.COS_NAME && "StandardEncoding".equals(encoding.getString())) {
                this.encoding = TrueTypePredefined.STANDARD_ENCODING;
            }
        }
    }

    @Override
    public String getGlyphName(int code) {
        if (code > 0 && code < this.encoding.length) {
            return this.encoding[code];
        }
        return null;
    }

    private String getGlyph(int code) {
        if (code < this.encoding.length) {
            return this.encoding[code];
        }
        return ".notdef";
    }

    @Override
    public ASFileStreamCloser getFontProgramResource() {
        return new ASFileStreamCloser(this.getSource());
    }

    @Override
    public String getWeight() {
        return null;
    }

    @Override
    public Double getAscent() {
        return null;
    }

    @Override
    public Double getDescent() {
        return null;
    }

    @Override
    public List<Integer> getCIDList() {
        return Collections.emptyList();
    }

    static {
        HashSet<String> tempSet = new HashSet<String>();
        tempSet.add("abs");
        tempSet.add("floor");
        tempSet.add("mod");
        tempSet.add("add");
        tempSet.add("idiv");
        tempSet.add("mul");
        tempSet.add("div");
        tempSet.add("neg");
        tempSet.add("sub");
        tempSet.add("ceiling");
        tempSet.add("round");
        tempSet.add("copy");
        tempSet.add("exch");
        tempSet.add("pop");
        tempSet.add("dup");
        tempSet.add("index");
        tempSet.add("roll");
        tempSet.add("clear");
        tempSet.add("count");
        tempSet.add("mark");
        tempSet.add("cleartomark");
        tempSet.add("counttomark");
        tempSet.add("dict");
        tempSet.add("begin");
        tempSet.add("length");
        tempSet.add("def");
        tempSet.add("load");
        tempSet.add("array");
        tempSet.add("put");
        tempSet.add("for");
        tempSet.add("StandardEncoding");
        tempSet.add("<<");
        tempSet.add(">>");
        OPERATORS_KEYWORDS = Collections.unmodifiableSet(tempSet);
    }
}

