/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.parser;

import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.verapdf.as.ASAtom;
import org.verapdf.as.io.ASInputStream;
import org.verapdf.cos.COSDocument;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.exceptions.VeraPDFParserException;
import org.verapdf.io.InternalInputStream;
import org.verapdf.io.SeekableInputStream;
import org.verapdf.parser.BaseParser;
import org.verapdf.parser.COSParser;
import org.verapdf.parser.SeekableBaseParser;
import org.verapdf.parser.Token;
import org.verapdf.tools.resource.ASFileStreamCloser;

public class SeekableCOSParser
extends COSParser {
    private static final Logger LOGGER = Logger.getLogger(SeekableCOSParser.class.getCanonicalName());

    public SeekableCOSParser(SeekableInputStream seekableInputStream) throws IOException {
        super(new SeekableBaseParser(seekableInputStream));
    }

    public SeekableCOSParser(String filename) throws IOException {
        super(new SeekableBaseParser(filename));
    }

    public SeekableCOSParser(InputStream fileStream) throws IOException {
        super(new SeekableBaseParser(fileStream));
    }

    public SeekableCOSParser(COSDocument document, String filename) throws IOException {
        this(filename);
        this.document = document;
    }

    public SeekableCOSParser(COSDocument document, InputStream fileStream) throws IOException {
        this(fileStream);
        this.document = document;
    }

    @Override
    protected COSObject getDictionary() throws IOException {
        COSObject dict = super.getDictionary();
        if (dict.getType() != COSObjType.COS_DICT) {
            return dict;
        }
        Token token = this.getBaseParser().getToken();
        long reset = this.getSource().getOffset();
        if (this.flag) {
            this.getBaseParser().nextToken();
        }
        this.flag = false;
        if (token.type == Token.Type.TT_KEYWORD && token.keyword == Token.Keyword.KW_STREAM) {
            return this.getStream(dict);
        }
        this.getSource().seek(reset);
        this.flag = true;
        return dict;
    }

    protected COSObject getStream(COSObject dict) throws IOException {
        if (this.flag) {
            this.getBaseParser().nextToken();
        }
        this.flag = true;
        Token token = this.getBaseParser().getToken();
        if (token.type != Token.Type.TT_KEYWORD || token.keyword != Token.Keyword.KW_STREAM) {
            this.flag = false;
            return dict;
        }
        this.checkStreamSpacings(dict);
        long streamStartOffset = this.getSource().getOffset();
        COSObject length = dict.getKey(ASAtom.LENGTH);
        if (this.keyOfCurrentObject != null && length.isIndirect().booleanValue() && this.keyOfCurrentObject.equals(length.getKey())) {
            throw new VeraPDFParserException(this.getErrorMessage("Object has stream length value which references to its own object key"));
        }
        Long size = length.getInteger();
        this.getSource().seek(streamStartOffset);
        boolean streamLengthValid = this.checkStreamLength(size);
        if (streamLengthValid) {
            dict.setRealStreamSize(size);
            ASInputStream stm = this.getBaseParser().getRandomAccess(size);
            dict.setData(stm);
            if (stm instanceof InternalInputStream) {
                this.document.addFileResource(new ASFileStreamCloser(stm));
            }
        } else {
            long realStreamSize = -1L;
            int bufferLength = 512;
            byte[] buffer = new byte[bufferLength];
            int eolLength = 0;
            boolean isPrevCR = false;
            block0: while (realStreamSize == -1L && !this.getSource().isEOF()) {
                long bytesRead = this.getSource().read(buffer, bufferLength);
                int i = 0;
                while ((long)i < bytesRead) {
                    if (buffer[i] == 101) {
                        long reset = this.getSource().getOffset();
                        long possibleEndStreamOffset = reset - bytesRead + (long)i - (long)eolLength;
                        this.getSource().seek(possibleEndStreamOffset);
                        this.getBaseParser().nextToken();
                        if (token.type == Token.Type.TT_KEYWORD && token.keyword == Token.Keyword.KW_ENDSTREAM) {
                            realStreamSize = possibleEndStreamOffset - streamStartOffset;
                            dict.setRealStreamSize(realStreamSize);
                            this.getSource().seek(streamStartOffset);
                            ASInputStream stm = this.getBaseParser().getRandomAccess(realStreamSize);
                            dict.setData(stm);
                            this.getSource().seek(possibleEndStreamOffset);
                            if (!(stm instanceof InternalInputStream)) continue block0;
                            this.document.addFileResource(new ASFileStreamCloser(stm));
                            continue block0;
                        }
                        this.getSource().seek(reset);
                    }
                    if (BaseParser.isCR(buffer[i])) {
                        eolLength = 1;
                        isPrevCR = true;
                    } else {
                        eolLength = BaseParser.isLF(buffer[i]) ? (isPrevCR ? 2 : 1) : 0;
                        isPrevCR = false;
                    }
                    ++i;
                }
            }
            if (realStreamSize == -1L) {
                throw new IOException(this.getErrorMessage("End of stream is not found"));
            }
        }
        this.checkEndstreamSpacings(dict, streamStartOffset, size);
        return dict;
    }

    private void checkStreamSpacings(COSObject stream) throws IOException {
        byte whiteSpace = this.getSource().readByte();
        if (BaseParser.isCR(whiteSpace)) {
            whiteSpace = this.getSource().readByte();
            if (!BaseParser.isLF(whiteSpace)) {
                stream.setStreamKeywordCRLFCompliant(false);
                this.getSource().unread();
            }
        } else if (!BaseParser.isLF(whiteSpace)) {
            LOGGER.log(Level.WARNING, this.getErrorMessage("Stream has no EOL marker"));
            stream.setStreamKeywordCRLFCompliant(false);
            this.getSource().unread();
        }
    }

    private boolean checkStreamLength(Long streamLength) throws IOException {
        if (streamLength == null) {
            LOGGER.log(Level.WARNING, this.getErrorMessage("Stream length is missing"));
            return false;
        }
        boolean validLength = true;
        long start = this.getSource().getOffset();
        long expectedEndstreamOffset = start + streamLength;
        if (expectedEndstreamOffset > this.getSource().getStreamLength()) {
            validLength = false;
            LOGGER.log(Level.WARNING, this.getErrorMessage("Couldn't find expected endstream keyword", expectedEndstreamOffset));
        } else {
            this.getSource().seek(expectedEndstreamOffset);
            this.getBaseParser().nextToken();
            Token token = this.getBaseParser().getToken();
            if (token.type != Token.Type.TT_KEYWORD || token.keyword != Token.Keyword.KW_ENDSTREAM) {
                validLength = false;
                LOGGER.log(Level.WARNING, this.getErrorMessage("Couldn't find expected endstream keyword", expectedEndstreamOffset));
            }
            this.getSource().seek(start);
        }
        return validLength;
    }

    private void checkEndstreamSpacings(COSObject stream, long streamStartOffset, Long expectedLength) throws IOException {
        this.getBaseParser().skipSpaces();
        long approximateLength = this.getSource().getOffset() - streamStartOffset;
        long expected = expectedLength == null ? 0L : expectedLength;
        this.getSource().unread(2);
        byte firstSymbol = this.getSource().readByte();
        byte secondSymbol = this.getSource().readByte();
        int eolCount = 0;
        if (secondSymbol == 10) {
            long diff;
            eolCount = firstSymbol == 13 ? (int)((byte)((diff = approximateLength - expected) > 1L ? 2 : 1)) : 1;
        } else if (secondSymbol == 13) {
            eolCount = 1;
        } else {
            LOGGER.log(Level.FINE, this.getErrorMessage("End of stream doesn't contain EOL marker"));
            stream.setEndstreamKeywordCRLFCompliant(false);
        }
        stream.setRealStreamSize(approximateLength - (long)eolCount);
        this.getBaseParser().nextToken();
    }

    public COSDocument getDocument() {
        return this.document;
    }

    @Override
    protected String getErrorMessage(String message) {
        return this.getErrorMessage(message, this.getSource().getCurrentOffset());
    }

    protected String getErrorMessage(String message, long offset) {
        if (this.keyOfCurrentObject != null) {
            return message + "(object key = " + this.keyOfCurrentObject + ", offset = " + offset + ')';
        }
        return this.getBaseParser().getErrorMessage(message, offset);
    }

    @Override
    public SeekableBaseParser getBaseParser() {
        return (SeekableBaseParser)super.getBaseParser();
    }

    @Override
    public SeekableInputStream getSource() {
        return this.getBaseParser().getSource();
    }

    public void closeInputStream() throws IOException {
        this.getBaseParser().closeInputStream();
    }
}

