/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.pd.images;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSName;
import org.verapdf.gf.model.factory.colors.ColorSpaceFactory;
import org.verapdf.gf.model.impl.cos.GFCosIIFilter;
import org.verapdf.gf.model.impl.cos.GFCosRenderingIntent;
import org.verapdf.gf.model.impl.pd.GFPDResource;
import org.verapdf.model.baselayer.Object;
import org.verapdf.model.coslayer.CosIIFilter;
import org.verapdf.model.coslayer.CosRenderingIntent;
import org.verapdf.model.pdlayer.PDInlineImage;
import org.verapdf.pd.colors.PDColorSpace;

public class GFPDInlineImage
extends GFPDResource
implements PDInlineImage {
    public static final String F = "F";
    public static final String INLINE_IMAGE_TYPE = "PDInlineImage";
    private PDColorSpace inheritedFillCS;

    public GFPDInlineImage(org.verapdf.pd.images.PDInlineImage simplePDObject, PDColorSpace inheritedFillCS) {
        super(simplePDObject, INLINE_IMAGE_TYPE);
        this.inheritedFillCS = inheritedFillCS;
    }

    @Override
    public Boolean getInterpolate() {
        return ((org.verapdf.pd.images.PDInlineImage)this.simplePDObject).isInterpolate();
    }

    @Override
    public String getSubtype() {
        return null;
    }

    @Override
    public Boolean getisInherited() {
        return ((org.verapdf.pd.images.PDInlineImage)this.simplePDObject).isInherited();
    }

    @Override
    public Boolean getcontainsOPI() {
        return this.simplePDObject.knownKey(ASAtom.OPI);
    }

    @Override
    public Boolean getcontainsSMask() {
        return this.simplePDObject.knownKey(ASAtom.SMASK);
    }

    @Override
    public Boolean getcontainsAlternates() {
        return this.simplePDObject.knownKey(ASAtom.ALTERNATES);
    }

    @Override
    public List<? extends Object> getLinkedObjects(String link) {
        switch (link) {
            case "Intent": {
                return this.getIntent();
            }
            case "imageCS": {
                return this.getImageCS();
            }
            case "SMask": 
            case "OPI": 
            case "Alternates": 
            case "jpxStream": {
                return Collections.emptyList();
            }
            case "F": {
                return this.getFilters();
            }
        }
        return super.getLinkedObjects(link);
    }

    private List<CosIIFilter> getFilters() {
        List<COSName> filters = ((org.verapdf.pd.images.PDInlineImage)this.simplePDObject).getCOSFilters();
        if (!filters.isEmpty()) {
            ArrayList<GFCosIIFilter> result = new ArrayList<GFCosIIFilter>(filters.size());
            for (COSName filter : filters) {
                result.add(new GFCosIIFilter(filter));
            }
            return Collections.unmodifiableList(result);
        }
        return Collections.emptyList();
    }

    private List<org.verapdf.model.pdlayer.PDColorSpace> getImageCS() {
        if (!((org.verapdf.pd.images.PDInlineImage)this.simplePDObject).getImageMask()) {
            org.verapdf.model.pdlayer.PDColorSpace buffer = ColorSpaceFactory.getColorSpace(((org.verapdf.pd.images.PDInlineImage)this.simplePDObject).getImageCS());
            if (buffer != null) {
                ArrayList<org.verapdf.model.pdlayer.PDColorSpace> colorSpaces = new ArrayList<org.verapdf.model.pdlayer.PDColorSpace>(1);
                colorSpaces.add(buffer);
                return Collections.unmodifiableList(colorSpaces);
            }
        } else if (this.inheritedFillCS != null) {
            ArrayList<org.verapdf.model.pdlayer.PDColorSpace> colorSpaces = new ArrayList<org.verapdf.model.pdlayer.PDColorSpace>(1);
            colorSpaces.add(ColorSpaceFactory.getColorSpace(this.inheritedFillCS));
            return Collections.unmodifiableList(colorSpaces);
        }
        return Collections.emptyList();
    }

    private List<CosRenderingIntent> getIntent() {
        COSName intent = ((org.verapdf.pd.images.PDInlineImage)this.simplePDObject).getIntent();
        if (intent != null) {
            ArrayList<GFCosRenderingIntent> intents = new ArrayList<GFCosRenderingIntent>(1);
            intents.add(new GFCosRenderingIntent(intent));
            return Collections.unmodifiableList(intents);
        }
        return Collections.emptyList();
    }
}

