/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.verapdf.ReleaseDetails;
import org.verapdf.component.ComponentDetails;
import org.verapdf.component.Components;
import org.verapdf.core.EncryptedPdfException;
import org.verapdf.core.ModelParsingException;
import org.verapdf.exceptions.InvalidPasswordException;
import org.verapdf.features.AbstractFeaturesExtractor;
import org.verapdf.features.FeatureExtractionResult;
import org.verapdf.features.FeatureExtractorConfig;
import org.verapdf.features.gf.GFFeatureParser;
import org.verapdf.gf.model.impl.containers.StaticContainers;
import org.verapdf.gf.model.impl.cos.GFCosDocument;
import org.verapdf.metadata.fixer.entity.PDFDocument;
import org.verapdf.metadata.fixer.gf.impl.model.PDFDocumentImpl;
import org.verapdf.parser.PDFFlavour;
import org.verapdf.pd.PDDocument;
import org.verapdf.pd.PDMetadata;
import org.verapdf.pdfa.Foundries;
import org.verapdf.pdfa.PDFAParser;
import org.verapdf.pdfa.flavours.PDFAFlavour;
import org.verapdf.tools.StaticResources;
import org.verapdf.xmp.XMPException;
import org.verapdf.xmp.impl.VeraPDFMeta;

public class GFModelParser
implements PDFAParser {
    private static final ReleaseDetails greenfieldDetails = ReleaseDetails.addDetailsFromResource("org/verapdf/release/validation-model.properties");
    private static final URI id = URI.create("http://pdfa.verapdf.org/parser#verapdf");
    private static final ComponentDetails details = Components.veraDetails(id, "VeraPDF Parser", greenfieldDetails.getVersion(), "veraPDF greenfield PDF parser.");
    private static final Logger logger = Logger.getLogger(GFModelParser.class.getCanonicalName());
    private static final String PDFUA_PREFIX = "ua";
    private PDDocument document;
    private final PDFAFlavour flavour;

    private GFModelParser(InputStream docStream, PDFAFlavour flavour, PDFAFlavour defaultFlavour, String password) throws IOException {
        try {
            GFModelParser.clearStaticContainers();
            GFModelParser.initializeStaticResources(password);
            this.document = new PDDocument(docStream);
            this.flavour = GFModelParser.detectFlavour(this.document, flavour, defaultFlavour);
            GFModelParser.initializeStaticContainers(this.document, this.flavour);
        }
        catch (Throwable t) {
            this.close();
            throw t;
        }
    }

    private GFModelParser(File pdfFile, PDFAFlavour flavour, PDFAFlavour defaultFlavour, String password) throws IOException {
        try {
            GFModelParser.clearStaticContainers();
            GFModelParser.initializeStaticResources(password);
            this.document = new PDDocument(pdfFile.getAbsolutePath());
            this.flavour = GFModelParser.detectFlavour(this.document, flavour, defaultFlavour);
            GFModelParser.initializeStaticContainers(this.document, this.flavour);
        }
        catch (Throwable t) {
            this.close();
            throw t;
        }
    }

    private static PDFAFlavour detectFlavour(PDDocument document, PDFAFlavour flavour, PDFAFlavour defaultFlavour) {
        return flavour == PDFAFlavour.NO_FLAVOUR ? GFModelParser.obtainFlavour(document, defaultFlavour != PDFAFlavour.NO_FLAVOUR ? defaultFlavour : Foundries.defaultInstance().defaultFlavour()) : flavour;
    }

    public static GFModelParser createModelWithFlavour(InputStream toLoad, PDFAFlavour flavour) throws ModelParsingException, EncryptedPdfException {
        return GFModelParser.createModelWithFlavour(toLoad, flavour, PDFAFlavour.NO_FLAVOUR);
    }

    public static GFModelParser createModelWithFlavour(InputStream toLoad, PDFAFlavour flavour, PDFAFlavour defaultFlavour) throws ModelParsingException, EncryptedPdfException {
        return GFModelParser.createModelWithFlavour(toLoad, flavour, defaultFlavour, null);
    }

    public static GFModelParser createModelWithFlavour(InputStream toLoad, PDFAFlavour flavour, String password) throws ModelParsingException, EncryptedPdfException {
        return GFModelParser.createModelWithFlavour(toLoad, flavour, PDFAFlavour.NO_FLAVOUR, password);
    }

    public static GFModelParser createModelWithFlavour(InputStream toLoad, PDFAFlavour flavour, PDFAFlavour defaultFlavour, String password) throws ModelParsingException, EncryptedPdfException {
        try {
            return new GFModelParser(toLoad, flavour, defaultFlavour, password);
        }
        catch (InvalidPasswordException excep) {
            throw new EncryptedPdfException("The PDF stream appears to be encrypted.", excep);
        }
        catch (IOException e) {
            throw new ModelParsingException("Couldn't parse stream", e);
        }
    }

    public static GFModelParser createModelWithFlavour(File pdfFile, PDFAFlavour flavour) throws ModelParsingException, EncryptedPdfException {
        return GFModelParser.createModelWithFlavour(pdfFile, flavour, PDFAFlavour.NO_FLAVOUR);
    }

    public static GFModelParser createModelWithFlavour(File pdfFile, PDFAFlavour flavour, PDFAFlavour defaultFlavour) throws ModelParsingException, EncryptedPdfException {
        return GFModelParser.createModelWithFlavour(pdfFile, flavour, defaultFlavour, null);
    }

    public static GFModelParser createModelWithFlavour(File pdfFile, PDFAFlavour flavour, String password) throws ModelParsingException, EncryptedPdfException {
        return GFModelParser.createModelWithFlavour(pdfFile, flavour, PDFAFlavour.NO_FLAVOUR, password);
    }

    public static GFModelParser createModelWithFlavour(File pdfFile, PDFAFlavour flavour, PDFAFlavour defaultFlavour, String password) throws ModelParsingException, EncryptedPdfException {
        try {
            return new GFModelParser(pdfFile, flavour, defaultFlavour, password);
        }
        catch (InvalidPasswordException excep) {
            throw new EncryptedPdfException("The PDF stream appears to be encrypted.", excep);
        }
        catch (IOException e) {
            throw new ModelParsingException("Couldn't parse stream", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static PDFAFlavour obtainFlavour(PDDocument document, PDFAFlavour defaultFlavour) {
        if (document == null) return defaultFlavour;
        if (document.getCatalog() == null) {
            return defaultFlavour;
        }
        PDMetadata metadata = document.getCatalog().getMetadata();
        if (metadata == null) {
            return defaultFlavour;
        }
        try (InputStream is = metadata.getStream();){
            PDFAFlavour pdfaFlavour;
            VeraPDFMeta veraPDFMeta = VeraPDFMeta.parse(is);
            Integer identificationPart = veraPDFMeta.getPDFAIdentificationPart();
            String identificationConformance = veraPDFMeta.getPDFAIdentificationConformance();
            String prefix = "";
            if (identificationPart == null && identificationConformance == null && (identificationPart = veraPDFMeta.getPDFUAIdentificationPart()) != null) {
                prefix = PDFUA_PREFIX;
            }
            if (identificationConformance == null) {
                identificationConformance = "";
            }
            if ((pdfaFlavour = PDFAFlavour.byFlavourId(prefix + identificationPart + identificationConformance)) == PDFAFlavour.NO_FLAVOUR || pdfaFlavour == PDFAFlavour.PDFUA_2) {
                PDFAFlavour pDFAFlavour2 = defaultFlavour;
                return pDFAFlavour2;
            }
            PDFAFlavour pDFAFlavour = pdfaFlavour;
            return pDFAFlavour;
        }
        catch (XMPException e) {
            logger.log(Level.FINE, e.getMessage(), e);
            return defaultFlavour;
        }
        catch (IOException e) {
            logger.log(Level.FINE, e.getMessage(), e);
            return defaultFlavour;
        }
    }

    private static void initializeStaticContainers(PDDocument document, PDFAFlavour flavour) {
        StaticResources.setDocument(document);
        StaticContainers.setFlavour(flavour);
        StaticResources.setFlavour(flavour != null ? PDFFlavour.valueOf(flavour.name()) : null);
    }

    private static void initializeStaticResources(String password) {
        StaticResources.setPassword(password);
    }

    private static void clearStaticContainers() {
        StaticContainers.clearAllContainers();
        StaticResources.clear();
    }

    public PDDocument getPDDocument() {
        return this.document;
    }

    @Override
    public org.verapdf.model.baselayer.Object getRoot() {
        return new GFCosDocument(this.document.getDocument());
    }

    @Override
    public ComponentDetails getDetails() {
        return details;
    }

    @Override
    public PDFAFlavour getFlavour() {
        return this.flavour;
    }

    @Override
    public PDFDocument getPDFDocument() {
        return new PDFDocumentImpl(this.document);
    }

    @Override
    public FeatureExtractionResult getFeatures(FeatureExtractorConfig config) {
        return GFFeatureParser.getFeaturesCollection(this.document, config);
    }

    @Override
    public FeatureExtractionResult getFeatures(FeatureExtractorConfig config, List<AbstractFeaturesExtractor> extractors) {
        return GFFeatureParser.getFeaturesCollection(this.document, extractors, config);
    }

    @Override
    public void close() {
        if (this.document != null) {
            this.document.close();
        }
    }
}

