/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.parser;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.verapdf.as.CharTable;
import org.verapdf.cos.filters.COSFilterASCIIHexDecode;
import org.verapdf.parser.BaseParserInputStream;
import org.verapdf.parser.Token;

public abstract class BaseParser {
    private static final Logger LOGGER = Logger.getLogger(BaseParser.class.getCanonicalName());
    private static final int MAX_STRING_LENGTH = 65535;
    private static final byte ASCII_ZERO = 48;
    private static final byte ASCII_NINE = 57;
    protected boolean isPSParser = false;
    protected Token token;
    protected BaseParserInputStream source;

    public Token getToken() {
        return this.token;
    }

    public void initializeToken() {
        if (this.token == null) {
            this.token = new Token();
        }
    }

    protected void appendToToken(int ch) {
        this.token.append(ch);
    }

    protected void clearToken() {
        this.token.clearValue();
    }

    protected String readUntilDelimiter() throws IOException {
        this.initializeToken();
        this.token.clearValue();
        byte ch = this.source.readByte();
        while (!CharTable.isSpace(ch) && !CharTable.isTokenDelimiter(ch)) {
            this.appendToToken(ch);
            if (this.source.isEOF()) break;
            ch = this.source.readByte();
        }
        if (CharTable.isSpace(ch) || CharTable.isTokenDelimiter(ch)) {
            this.source.unread();
        }
        return this.token.getValue();
    }

    protected boolean findKeyword(Token.Keyword keyword) throws IOException {
        this.nextToken();
        while (this.token.type != Token.Type.TT_EOF && (this.token.type != Token.Type.TT_KEYWORD || this.token.keyword != keyword)) {
            this.nextToken();
        }
        return this.token.type == Token.Type.TT_KEYWORD && this.token.keyword == keyword;
    }

    protected abstract boolean findKeyword(Token.Keyword var1, int var2) throws IOException;

    protected void skipSpaces() throws IOException {
        this.skipSpaces(false);
    }

    public void skipSpaces(boolean skipComment) throws IOException {
        while (this.skipSingleSpace(skipComment)) {
        }
    }

    protected boolean skipSingleSpace(boolean skipComment) throws IOException {
        if (this.source.isEOF()) {
            return false;
        }
        byte ch = this.source.readByte();
        if (CharTable.isSpace(ch)) {
            return true;
        }
        if (ch == 37 && skipComment) {
            this.skipComment();
            return true;
        }
        this.source.unread();
        return false;
    }

    protected abstract void skipComment() throws IOException;

    protected boolean isDigit() throws IOException {
        return BaseParser.isDigit((byte)this.source.peek());
    }

    protected static boolean isDigit(byte c) {
        return c >= 48 && c <= 57;
    }

    protected static boolean isLF(int c) {
        return 10 == c;
    }

    public static boolean isCR(int c) {
        return 13 == c;
    }

    public static boolean isFF(int c) {
        return 12 == c;
    }

    protected abstract void readASCII85() throws IOException;

    private void readToken() throws IOException {
        this.token.clearValue();
        while (!this.source.isEOF()) {
            byte ch = this.source.readByte();
            if (CharTable.isTokenDelimiter(ch)) {
                this.source.unread();
                break;
            }
            this.appendToToken(ch);
        }
    }

    public void nextToken() throws IOException {
        this.skipSpaces(true);
        if (this.source.isEOF()) {
            this.token.type = Token.Type.TT_EOF;
            return;
        }
        this.token.type = Token.Type.TT_NONE;
        byte ch = this.source.readByte();
        switch (ch) {
            case 40: {
                this.token.type = Token.Type.TT_LITSTRING;
                this.readLitString();
                break;
            }
            case 41: {
                break;
            }
            case 60: {
                ch = this.source.readByte();
                if (ch == 60) {
                    this.token.type = Token.Type.TT_OPENDICT;
                    break;
                }
                if (ch == 126) {
                    this.token.type = Token.Type.TT_HEXSTRING;
                    this.readASCII85();
                    break;
                }
                this.source.unread();
                this.token.type = Token.Type.TT_HEXSTRING;
                this.readHexString();
                break;
            }
            case 62: {
                ch = this.source.readByte();
                if (ch == 62) {
                    this.token.type = Token.Type.TT_CLOSEDICT;
                    break;
                }
                throw new IOException(this.getErrorMessage("Unknown symbol " + ch + " after '>'"));
            }
            case 91: {
                this.token.type = Token.Type.TT_OPENARRAY;
                break;
            }
            case 93: {
                this.token.type = Token.Type.TT_CLOSEARRAY;
                break;
            }
            case 123: {
                if (!this.isPSParser) break;
                this.token.type = Token.Type.TT_STARTPROC;
                break;
            }
            case 125: {
                if (!this.isPSParser) break;
                this.token.type = Token.Type.TT_ENDPROC;
                break;
            }
            case 47: {
                this.token.type = Token.Type.TT_NAME;
                this.readName();
                break;
            }
            case 46: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                this.source.unread();
                this.readNumber();
                break;
            }
            case 43: {
                this.readNumber();
                break;
            }
            case 45: {
                this.readNumber();
                this.token.integer = -this.token.integer;
                this.token.real = -this.token.real;
                break;
            }
            default: {
                this.source.unread();
                this.readToken();
                this.token.toKeyword();
                if (this.token.keyword != Token.Keyword.KW_NONE) break;
                this.token.type = Token.Type.TT_NONE;
            }
        }
    }

    protected String getLine() throws IOException {
        this.initializeToken();
        this.token.clearValue();
        byte ch = this.source.readByte();
        while (!this.source.isEOF() && ch != 10 && ch != 13) {
            this.appendToToken(ch);
            ch = this.source.readByte();
        }
        return this.token.getValue();
    }

    protected byte[] getLineBytes() throws IOException {
        this.getLine();
        return this.token.getByteValue();
    }

    private void readHexString() throws IOException {
        this.token.clearValue();
        int uc = 0;
        boolean containsOnlyHex = true;
        long hexCount = 0L;
        boolean odd = false;
        while (!this.source.isEOF()) {
            byte ch = this.source.readByte();
            if (ch == 62) {
                if (odd) {
                    this.appendToToken(uc <<= 4);
                }
                this.token.setContainsOnlyHex(containsOnlyHex);
                this.token.setHexCount(hexCount);
                return;
            }
            if (CharTable.isSpace(ch)) continue;
            byte hex = COSFilterASCIIHexDecode.decodeLoHex(ch);
            ++hexCount;
            if (hex < 16 && hex > -1) {
                if (odd) {
                    uc = (uc << 4) + hex;
                    this.appendToToken(uc);
                    uc = 0;
                } else {
                    uc = hex;
                }
                odd = !odd;
                continue;
            }
            containsOnlyHex = false;
        }
        this.token.setContainsOnlyHex(containsOnlyHex);
        this.token.setHexCount(hexCount);
    }

    protected void readNumber() throws IOException {
        try {
            int radix = 10;
            this.initializeToken();
            this.token.clearValue();
            this.token.type = Token.Type.TT_INTEGER;
            while (!this.source.isEOF()) {
                byte ch = this.source.readByte();
                if (CharTable.isTokenDelimiter(ch)) {
                    this.source.unread();
                    break;
                }
                if (ch >= 48 && ch <= 57) {
                    this.appendToToken(ch);
                    continue;
                }
                if (ch == 46) {
                    this.token.type = Token.Type.TT_REAL;
                    this.appendToToken(ch);
                    continue;
                }
                if (ch == 35 && this.isPSParser) {
                    if (this.token.type == Token.Type.TT_INTEGER) {
                        radix = Integer.valueOf(this.token.getValue());
                    }
                    this.token.clearValue();
                    continue;
                }
                this.source.unread();
                break;
            }
            if (this.token.type == Token.Type.TT_INTEGER) {
                long value;
                this.token.integer = value = Long.valueOf(this.token.getValue(), radix).longValue();
                this.token.real = value;
            } else {
                double value = Double.valueOf(this.token.getValue());
                this.token.integer = Math.round(value);
                this.token.real = value;
            }
        }
        catch (NumberFormatException e) {
            LOGGER.log(Level.FINE, this.getErrorMessage(""), e);
            this.token.integer = Math.round(Double.MAX_VALUE);
            this.token.real = Double.MAX_VALUE;
        }
    }

    private void readLitString() throws IOException {
        this.token.clearValue();
        int parenthesesDepth = 0;
        byte ch = this.source.readByte();
        while (!this.source.isEOF()) {
            block0 : switch (ch) {
                default: {
                    this.appendToToken(ch);
                    break;
                }
                case 40: {
                    ++parenthesesDepth;
                    this.appendToToken(ch);
                    break;
                }
                case 41: {
                    if (parenthesesDepth == 0) {
                        return;
                    }
                    --parenthesesDepth;
                    this.appendToToken(ch);
                    break;
                }
                case 92: {
                    ch = this.source.readByte();
                    switch (ch) {
                        case 40: {
                            this.appendToToken(40);
                            break block0;
                        }
                        case 41: {
                            this.appendToToken(41);
                            break block0;
                        }
                        case 110: {
                            this.appendToToken(10);
                            break block0;
                        }
                        case 114: {
                            this.appendToToken(13);
                            break block0;
                        }
                        case 116: {
                            this.appendToToken(9);
                            break block0;
                        }
                        case 98: {
                            this.appendToToken(8);
                            break block0;
                        }
                        case 102: {
                            this.appendToToken(12);
                            break block0;
                        }
                        case 48: 
                        case 49: 
                        case 50: 
                        case 51: 
                        case 52: 
                        case 53: 
                        case 54: 
                        case 55: {
                            if (this.isPSParser) break block0;
                            char ch1 = (char)(ch - 48);
                            for (int i = 1; i < 3; ++i) {
                                ch = this.source.readByte();
                                if (ch < 48 || ch > 55) {
                                    this.source.unread();
                                    break;
                                }
                                ch1 = (char)((ch1 << 3) + (ch - 48));
                            }
                            this.appendToToken(ch1);
                            break block0;
                        }
                        case 10: {
                            break block0;
                        }
                        case 13: {
                            ch = this.source.readByte();
                            if (ch == 10) break block0;
                            this.source.unread();
                            break block0;
                        }
                        default: {
                            this.appendToToken(ch);
                        }
                    }
                }
            }
            ch = this.source.readByte();
            if (this.token.getSize() <= 65535) continue;
            LOGGER.log(Level.WARNING, this.getErrorMessage("Content stream string token exceeds 65535 bytes"));
            break;
        }
        while (!this.source.isEOF()) {
            block17 : switch (ch) {
                default: {
                    break;
                }
                case 40: {
                    ++parenthesesDepth;
                    break;
                }
                case 41: {
                    if (parenthesesDepth == 0) {
                        return;
                    }
                    --parenthesesDepth;
                    break;
                }
                case 92: {
                    ch = this.source.readByte();
                    switch (ch) {
                        case 48: 
                        case 49: 
                        case 50: 
                        case 51: 
                        case 52: 
                        case 53: 
                        case 54: 
                        case 55: {
                            if (this.isPSParser) break block17;
                            for (int i = 1; i < 3; ++i) {
                                ch = this.source.readByte();
                                if (ch >= 48 && ch <= 55) continue;
                                this.source.unread();
                                break block17;
                            }
                            break block17;
                        }
                        case 13: {
                            ch = this.source.readByte();
                            if (ch == 10) break block17;
                            this.source.unread();
                            break block17;
                        }
                    }
                }
            }
            ch = this.source.readByte();
        }
    }

    protected void readName() throws IOException {
        this.token.clearValue();
        while (!this.source.isEOF()) {
            byte ch = this.source.readByte();
            if (CharTable.isTokenDelimiter(ch)) {
                this.source.unread();
                break;
            }
            if (ch == 35 && !this.isPSParser) {
                byte ch1 = this.source.readByte();
                if (!this.source.isEOF() && COSFilterASCIIHexDecode.decodeLoHex(ch1) != 127) {
                    byte dc = COSFilterASCIIHexDecode.decodeLoHex(ch1);
                    byte ch2 = this.source.readByte();
                    if (!this.source.isEOF() && COSFilterASCIIHexDecode.decodeLoHex(ch2) != 127) {
                        dc = (byte)((dc << 4) + COSFilterASCIIHexDecode.decodeLoHex(ch2));
                        this.appendToToken(dc);
                        continue;
                    }
                    this.appendToToken(ch);
                    this.appendToToken(ch1);
                    this.source.unread();
                    continue;
                }
                this.appendToToken(ch);
                this.source.unread();
                continue;
            }
            this.appendToToken(ch);
        }
    }

    protected String getErrorMessage(String message) {
        return message;
    }

    protected BaseParserInputStream getSource() {
        return this.source;
    }

    protected boolean isPSParser() {
        return this.isPSParser;
    }
}

