/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.cos.filters;

import java.io.IOException;
import java.util.Arrays;
import org.verapdf.as.filters.io.ASBufferedInFilter;
import org.verapdf.as.filters.io.COSFilterASCIIReader;
import org.verapdf.as.io.ASInputStream;

public class COSFilterASCII85Decode
extends ASBufferedInFilter {
    private final COSFilterASCIIReader reader;
    private byte[] fourBytes = new byte[4];
    private int fourBytesPointer = 0;

    public COSFilterASCII85Decode(ASInputStream stream) throws IOException {
        super(stream);
        this.reader = new COSFilterASCIIReader(stream, false);
    }

    @Override
    public int read(byte[] buffer, int size) throws IOException {
        int pointer;
        int bytesToCopy;
        if (size == 0) {
            return 0;
        }
        for (pointer = 0; pointer < size; pointer += bytesToCopy) {
            byte[] fiveBytes;
            if (this.fourBytesPointer > 0) {
                pointer += this.readSurplus(buffer, size, pointer);
            }
            if (pointer >= size || (fiveBytes = this.reader.getNextBytes()) == null) break;
            int decoded = this.decodeFiveBytes(fiveBytes);
            int availableBytes = size - pointer;
            bytesToCopy = Math.min(availableBytes, decoded);
            System.arraycopy(this.fourBytes, 0, buffer, pointer, bytesToCopy);
            if (bytesToCopy >= decoded) continue;
            this.fourBytesPointer = bytesToCopy;
        }
        return pointer == 0 ? -1 : pointer;
    }

    private int readSurplus(byte[] buffer, int size, int pointer) {
        int bytesToRead = Math.min(this.fourBytes.length - this.fourBytesPointer, size - pointer);
        System.arraycopy(this.fourBytes, this.fourBytesPointer, buffer, pointer, bytesToRead);
        this.fourBytesPointer += bytesToRead;
        if (this.fourBytesPointer == this.fourBytes.length) {
            this.fourBytesPointer = 0;
            this.fourBytes = new byte[4];
        }
        return bytesToRead;
    }

    private int decodeFiveBytes(byte[] fiveBytes) {
        int i;
        long value = 0L;
        for (byte b : fiveBytes) {
            value += (long)(b - 33);
            value *= 85L;
        }
        for (i = 0; i < 5 - fiveBytes.length; ++i) {
            value += 84L;
            value *= 85L;
        }
        value /= 85L;
        for (i = 3; i >= 0; --i) {
            this.fourBytes[i] = (byte)(value % 256L);
            value >>= 8;
        }
        int decoded = fiveBytes.length - 1;
        if (decoded != 4) {
            this.fourBytes = Arrays.copyOf(this.fourBytes, decoded);
        }
        return decoded;
    }
}

