/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.processor;

import java.io.Writer;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import org.verapdf.core.VeraPDFException;
import org.verapdf.pdfa.results.MetadataFixerResult;
import org.verapdf.pdfa.results.ValidationResult;
import org.verapdf.processor.AbstractXmlHandler;
import org.verapdf.processor.BatchProcessingHandler;
import org.verapdf.processor.ProcessorConfig;
import org.verapdf.processor.ProcessorResult;
import org.verapdf.processor.TaskResult;
import org.verapdf.processor.reports.BatchSummary;
import org.verapdf.report.FeaturesReport;

final class RawResultHandler
extends AbstractXmlHandler {
    private static final Logger logger = Logger.getLogger(RawResultHandler.class.getCanonicalName());
    private static final String rawEleName = "rawResults";
    private static final String configEleName = "config";
    private static final String itemEleName = "item";
    private static final String summaryName = "summary";
    private final boolean format;
    private final boolean fragment;

    private RawResultHandler(Writer dest) throws VeraPDFException {
        this(dest, true, true);
    }

    private RawResultHandler(Writer dest, boolean format, boolean fragment) throws VeraPDFException {
        super(dest);
        this.format = format;
        this.fragment = fragment;
    }

    @Override
    public void handleBatchStart(ProcessorConfig procConfig) throws VeraPDFException {
        try {
            RawResultHandler.startDoc(this.writer);
            this.writer.writeStartElement(rawEleName);
            this.serializeElement(procConfig, configEleName, this.format, this.fragment);
        }
        catch (XMLStreamException excep) {
            logger.log(Level.WARNING, String.format("XmlStreamException caught when %s output writer.", "writing"), excep);
            throw RawResultHandler.wrapStreamException(excep, rawEleName);
        }
    }

    @Override
    void resultStart(ProcessorResult result) throws VeraPDFException {
        this.serializeElement(result.getProcessedItem(), itemEleName, this.format, this.fragment);
    }

    @Override
    void parsingSuccess(TaskResult taskResult) {
    }

    @Override
    void parsingFailure(TaskResult taskResult) throws VeraPDFException {
        this.serializeElement(taskResult, "taskException", this.format, this.fragment);
    }

    @Override
    void pdfEncrypted(TaskResult taskResult) throws VeraPDFException {
        this.serializeElement(taskResult, "taskException", this.format, this.fragment);
    }

    @Override
    void validationSuccess(TaskResult taskResult, List<ValidationResult> validationResults) throws VeraPDFException {
        for (ValidationResult result : validationResults) {
            this.serializeElement(result, "validationResult", this.format, this.fragment);
        }
    }

    @Override
    void validationFailure(TaskResult taskResult) throws VeraPDFException {
        this.serializeElement(taskResult, "taskException", this.format, this.fragment);
    }

    @Override
    void featureSuccess(TaskResult taskResult, FeaturesReport featuresReport) throws VeraPDFException {
        this.serializeElement(featuresReport, "featuresReport", this.format, this.fragment);
    }

    @Override
    void featureFailure(TaskResult taskResult) throws VeraPDFException {
        this.serializeElement(taskResult, "taskException", this.format, this.fragment);
    }

    @Override
    void fixerSuccess(TaskResult taskResult, MetadataFixerResult fixerResult) throws VeraPDFException {
        this.serializeElement(fixerResult, "fixerResult", this.format, this.fragment);
    }

    @Override
    void fixerFailure(TaskResult taskResult) throws VeraPDFException {
        this.serializeElement(taskResult, "taskException", this.format, this.fragment);
    }

    @Override
    void resultEnd(ProcessorResult result, Boolean isLogsEnabled) {
    }

    @Override
    public void handleBatchEnd(BatchSummary summary) throws VeraPDFException {
        this.serializeElement(summary, summaryName, this.format, this.fragment);
        try {
            this.writer.writeEndElement();
            this.writer.flush();
            RawResultHandler.endDoc(this.writer);
        }
        catch (XMLStreamException excep) {
            logger.log(Level.WARNING, String.format("XmlStreamException caught when %s output writer.", "writing"), excep);
            throw RawResultHandler.wrapStreamException(excep, rawEleName);
        }
        this.close();
    }

    static final BatchProcessingHandler newInstance(Writer dest) throws VeraPDFException {
        return new RawResultHandler(dest);
    }

    static final BatchProcessingHandler newInstance(Writer dest, boolean format, boolean fragment) throws VeraPDFException {
        return new RawResultHandler(dest, format, fragment);
    }
}

