/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.ma.arrays;

import net.sf.saxon.ma.Parcel;
import net.sf.saxon.om.FunctionItem;
import net.sf.saxon.om.Genre;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.tree.iter.SequenceIteratorOverJavaIterator;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.z.IntSet;

public abstract class ArrayItem
implements FunctionItem {
    @Override
    public final boolean isArray() {
        return true;
    }

    @Override
    public final boolean isMap() {
        return false;
    }

    public abstract GroundedValue get(int var1);

    public abstract ArrayItem put(int var1, GroundedValue var2);

    public abstract int arrayLength();

    public boolean isEmpty() {
        return this.arrayLength() == 0;
    }

    public abstract Iterable<GroundedValue> members();

    public SequenceIterator parcels() {
        return new SequenceIteratorOverJavaIterator<GroundedValue>(this.members().iterator(), member -> new Parcel((GroundedValue)member));
    }

    public abstract ArrayItem append(GroundedValue var1);

    public abstract ArrayItem concat(ArrayItem var1);

    public abstract ArrayItem remove(int var1);

    public abstract ArrayItem removeSeveral(IntSet var1);

    public abstract ArrayItem subArray(int var1, int var2);

    public abstract ArrayItem insert(int var1, GroundedValue var2);

    public abstract SequenceType getMemberType(TypeHierarchy var1);

    @Override
    public String toShortString() {
        StringBuilder sb = new StringBuilder();
        sb.append("array{");
        int count = 0;
        for (GroundedValue member : this.members()) {
            if (count++ > 2) {
                sb.append(" ...");
                break;
            }
            sb.append(member.toShortString());
            sb.append(", ");
        }
        sb.append("}");
        return sb.toString();
    }

    @Override
    public final Genre getGenre() {
        return Genre.ARRAY;
    }
}

