/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.pd.optionalcontent;

import java.util.ArrayList;
import java.util.List;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSArray;
import org.verapdf.cos.COSDictionary;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.pd.PDObject;

public class PDOptionalContentProperties
extends PDObject {
    public PDOptionalContentProperties(COSObject obj) {
        super(obj);
    }

    public List<String> getGroupNames() {
        COSObject ocgs = this.getObject().getKey(ASAtom.OCGS);
        ArrayList<String> groups = new ArrayList<String>();
        if (!ocgs.empty() && ocgs.getType() == COSObjType.COS_ARRAY) {
            for (COSObject obj : (COSArray)ocgs.getDirectBase()) {
                if (obj.empty() || obj.getType() != COSObjType.COS_DICT) continue;
                String ocgName = obj.getStringKey(ASAtom.NAME);
                groups.add(ocgName == null ? "" : ocgName);
            }
        }
        return groups;
    }

    public boolean isContainsName(String name) {
        if (name == null) {
            return false;
        }
        COSObject ocgs = this.getObject().getKey(ASAtom.OCGS);
        if (!ocgs.empty() && ocgs.getType() == COSObjType.COS_ARRAY) {
            for (COSObject obj : (COSArray)ocgs.getDirectBase()) {
                if (obj.empty() || obj.getType() != COSObjType.COS_DICT || !name.equals(obj.getStringKey(ASAtom.NAME))) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isVisibleLayer(String name) {
        if (name == null) {
            return true;
        }
        COSObject d = this.getObject().getKey(ASAtom.D);
        if (d != null && d.getType() == COSObjType.COS_DICT) {
            COSDictionary dict = (COSDictionary)d.getDirectBase();
            if (PDOptionalContentProperties.isDContainsOCGWithName(dict, ASAtom.ON, name)) {
                return true;
            }
            if (PDOptionalContentProperties.isDContainsOCGWithName(dict, ASAtom.OFF, name)) {
                return false;
            }
            ASAtom baseState = dict.getNameKey(ASAtom.BASE_STATE);
            if (baseState != null) {
                return baseState.equals(ASAtom.ON);
            }
        }
        return true;
    }

    private static boolean isDContainsOCGWithName(COSDictionary dict, ASAtom state, String name) {
        COSObject cosObject = dict.getKey(state);
        if (cosObject != null && cosObject.getType() == COSObjType.COS_ARRAY) {
            for (COSObject obj : (COSArray)cosObject.getDirectBase()) {
                String ocgName;
                if (obj.empty() || obj.getType() != COSObjType.COS_DICT || !name.equals(ocgName = obj.getStringKey(ASAtom.NAME))) continue;
                return true;
            }
        }
        return false;
    }
}

