/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.core.utils;

import java.io.File;
import java.nio.file.Path;
import org.verapdf.core.VeraPDFException;
import org.verapdf.core.utils.AbstractFileOutputMapper;

final class RelativeRootMapper
extends AbstractFileOutputMapper {
    private final Path srcRoot;
    private final Path destRoot;

    private RelativeRootMapper(Path src, Path dest) {
        this(src, dest, "veraPDF_");
    }

    private RelativeRootMapper(Path src, Path dest, String prefix) {
        this(src, dest, prefix, "");
    }

    private RelativeRootMapper(Path src, Path dest, String prefix, String suffix) {
        super(prefix, suffix);
        this.srcRoot = src.normalize();
        this.destRoot = dest.normalize();
    }

    @Override
    protected File doMapFile(File orig) throws VeraPDFException {
        String newName = RelativeRootMapper.addPrefixAndSuffix(orig, this);
        return RelativeRootMapper.makeNewFile(orig, this.srcRoot, this.destRoot, newName);
    }

    private static File makeNewFile(File orig, Path src, Path dest, String newName) throws VeraPDFException {
        Path relSrc = orig.getParentFile().toPath().relativize(src);
        Path absDest = dest.resolve(relSrc);
        File parent = absDest.toFile();
        if (!parent.exists() && !parent.mkdirs()) {
            throw new VeraPDFException("Cannot create directory: " + parent);
        }
        return new File(parent, newName);
    }

    static RelativeRootMapper fromValues(Path src, Path dest, String prefix, String suffix) {
        return new RelativeRootMapper(src, dest, prefix, suffix);
    }
}

