/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.model.tools.xmp.validators;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.verapdf.model.tools.xmp.validators.TypeValidator;
import org.verapdf.xmp.XMPDateTimeFactory;
import org.verapdf.xmp.XMPException;
import org.verapdf.xmp.impl.VeraPDFXMPNode;

public class DateTypeValidator
implements TypeValidator {
    private static final Logger LOGGER = Logger.getLogger(DateTypeValidator.class.getName());

    @Override
    public boolean isCorresponding(VeraPDFXMPNode node) {
        if (node == null) {
            throw new IllegalArgumentException("Argument node can not be null.");
        }
        try {
            if (!node.getOptions().isSimple()) {
                return false;
            }
            XMPDateTimeFactory.createFromISO8601(node.getValue());
            return true;
        }
        catch (XMPException e) {
            LOGGER.log(Level.FINE, "Node:" + node.getName() + " with value:" + node.getValue() + " is not a valid ISO8601 date value");
            return false;
        }
    }
}

