/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.model.impl.axl;

import java.util.HashSet;
import java.util.Set;
import org.verapdf.containers.StaticCoreContainers;
import org.verapdf.model.impl.axl.AXLExtensionSchemaObject;
import org.verapdf.model.tools.xmp.ValidatorsContainer;
import org.verapdf.model.tools.xmp.validators.SimpleTypeValidator;
import org.verapdf.model.xmplayer.ExtensionSchemaField;
import org.verapdf.pdfa.flavours.PDFAFlavour;
import org.verapdf.pdfa.flavours.PDFFlavours;
import org.verapdf.xmp.impl.VeraPDFXMPNode;

public class AXLExtensionSchemaField
extends AXLExtensionSchemaObject
implements ExtensionSchemaField {
    public static final String EXTENSION_SCHEMA_FIELD = "ExtensionSchemaField";
    private static final String DESCRIPTION = "description";
    private static final String NAME = "name";
    private static final String VALUE_TYPE = "valueType";
    private static final Set<String> validChildNames = new HashSet<String>();

    public AXLExtensionSchemaField(VeraPDFXMPNode xmpNode, ValidatorsContainer containerForPDFA_1, ValidatorsContainer containerForPDFA_2_3) {
        super(EXTENSION_SCHEMA_FIELD, xmpNode, containerForPDFA_1, containerForPDFA_2_3);
    }

    @Override
    public Boolean getisDescriptionValidText() {
        for (VeraPDFXMPNode child : this.xmpNode.getChildren()) {
            if (!"http://www.aiim.org/pdfa/ns/field#".equals(child.getNamespaceURI()) || !DESCRIPTION.equals(child.getName())) continue;
            return SimpleTypeValidator.fromValue(SimpleTypeValidator.SimpleTypeEnum.TEXT).isCorresponding(child);
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean getisNameValidText() {
        for (VeraPDFXMPNode child : this.xmpNode.getChildren()) {
            if (!"http://www.aiim.org/pdfa/ns/field#".equals(child.getNamespaceURI()) || !NAME.equals(child.getName())) continue;
            return SimpleTypeValidator.fromValue(SimpleTypeValidator.SimpleTypeEnum.TEXT).isCorresponding(child);
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean getisValueTypeValidText() {
        for (VeraPDFXMPNode child : this.xmpNode.getChildren()) {
            if (!"http://www.aiim.org/pdfa/ns/field#".equals(child.getNamespaceURI()) || !VALUE_TYPE.equals(child.getName())) continue;
            return SimpleTypeValidator.fromValue(SimpleTypeValidator.SimpleTypeEnum.TEXT).isCorresponding(child);
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean getisValueTypeDefined() {
        if (PDFFlavours.isFlavourPart(StaticCoreContainers.getFlavour(), PDFAFlavour.Specification.ISO_19005_1)) {
            return this.isValueTypeValidForPDFA_1();
        }
        return this.isValueTypeValidForPDFA_2_3();
    }

    private Boolean isValueTypeValidForPDFA_1() {
        for (VeraPDFXMPNode child : this.xmpNode.getChildren()) {
            if (!"http://www.aiim.org/pdfa/ns/field#".equals(child.getNamespaceURI()) || !VALUE_TYPE.equals(child.getName())) continue;
            return this.containerForPDFA_1.isKnownType(child.getValue());
        }
        return Boolean.TRUE;
    }

    private Boolean isValueTypeValidForPDFA_2_3() {
        for (VeraPDFXMPNode child : this.xmpNode.getChildren()) {
            if (!"http://www.aiim.org/pdfa/ns/field#".equals(child.getNamespaceURI()) || !VALUE_TYPE.equals(child.getName())) continue;
            return this.containerForPDFA_2_3.isKnownType(child.getValue());
        }
        return Boolean.TRUE;
    }

    @Override
    public String getdescriptionPrefix() {
        for (VeraPDFXMPNode child : this.xmpNode.getChildren()) {
            if (!"http://www.aiim.org/pdfa/ns/field#".equals(child.getNamespaceURI()) || !DESCRIPTION.equals(child.getName())) continue;
            return child.getPrefix();
        }
        return null;
    }

    @Override
    public String getnamePrefix() {
        for (VeraPDFXMPNode child : this.xmpNode.getChildren()) {
            if (!"http://www.aiim.org/pdfa/ns/field#".equals(child.getNamespaceURI()) || !NAME.equals(child.getName())) continue;
            return child.getPrefix();
        }
        return null;
    }

    @Override
    public String getvalueTypePrefix() {
        for (VeraPDFXMPNode child : this.xmpNode.getChildren()) {
            if (!"http://www.aiim.org/pdfa/ns/field#".equals(child.getNamespaceURI()) || !VALUE_TYPE.equals(child.getName())) continue;
            return child.getPrefix();
        }
        return null;
    }

    @Override
    protected String getValidNamespaceURI() {
        return "http://www.aiim.org/pdfa/ns/field#";
    }

    @Override
    protected Set<String> getValidChildNames() {
        return validChildNames;
    }

    static {
        validChildNames.add(DESCRIPTION);
        validChildNames.add(NAME);
        validChildNames.add(VALUE_TYPE);
    }
}

