/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.features.objects;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import org.verapdf.core.FeatureParsingException;
import org.verapdf.features.FeatureObjectType;
import org.verapdf.features.FeaturesData;
import org.verapdf.features.objects.Feature;
import org.verapdf.features.objects.FeaturesObject;
import org.verapdf.features.objects.InfoDictFeaturesObjectAdapter;
import org.verapdf.features.tools.CreateNodeHelper;
import org.verapdf.features.tools.FeatureTreeNode;

public class InfoDictFeaturesObject
extends FeaturesObject {
    private static final String INFORMATION_DICT = "informationDict";
    private static final String TITLE = "Title";
    private static final String AUTHOR = "Author";
    private static final String SUBJECT = "Subject";
    private static final String KEYWORDS = "Keywords";
    private static final String CREATOR = "Creator";
    private static final String PRODUCER = "Producer";
    private static final String CREATION_DATE = "CreationDate";
    private static final String MOD_DATE = "ModDate";
    private static final String TRAPPED = "Trapped";
    private static final String ENTRY = "entry";
    private static final String KEY = "key";

    public InfoDictFeaturesObject(InfoDictFeaturesObjectAdapter adapter) {
        super(adapter);
    }

    @Override
    public FeatureObjectType getType() {
        return FeatureObjectType.INFORMATION_DICTIONARY;
    }

    @Override
    public FeatureTreeNode collectFeatures() throws FeatureParsingException {
        FeatureTreeNode modDate;
        Calendar mdDate;
        FeatureTreeNode creationDate;
        InfoDictFeaturesObjectAdapter infoDictAdapter = (InfoDictFeaturesObjectAdapter)this.adapter;
        FeatureTreeNode root = FeatureTreeNode.createRootNode(INFORMATION_DICT);
        InfoDictFeaturesObject.addEntry(TITLE, infoDictAdapter.getTitle(), root);
        InfoDictFeaturesObject.addEntry(AUTHOR, infoDictAdapter.getAuthor(), root);
        InfoDictFeaturesObject.addEntry(SUBJECT, infoDictAdapter.getSubject(), root);
        InfoDictFeaturesObject.addEntry(KEYWORDS, infoDictAdapter.getKeywords(), root);
        InfoDictFeaturesObject.addEntry(CREATOR, infoDictAdapter.getCreator(), root);
        InfoDictFeaturesObject.addEntry(PRODUCER, infoDictAdapter.getProducer(), root);
        Calendar crDate = infoDictAdapter.getCreationDate();
        if (crDate != null && (creationDate = CreateNodeHelper.createDateNode(ENTRY, root, crDate, this)) != null) {
            creationDate.setAttribute(KEY, CREATION_DATE);
        }
        if ((mdDate = infoDictAdapter.getModDate()) != null && (modDate = CreateNodeHelper.createDateNode(ENTRY, root, mdDate, this)) != null) {
            modDate.setAttribute(KEY, MOD_DATE);
        }
        InfoDictFeaturesObject.addEntry(TRAPPED, infoDictAdapter.getTrapped(), root);
        Map<String, String> elements = infoDictAdapter.getCustomValues();
        for (Map.Entry<String, String> elem : elements.entrySet()) {
            InfoDictFeaturesObject.addEntry(elem.getKey(), elem.getValue(), root);
        }
        return root;
    }

    private static void addEntry(String name, String value, FeatureTreeNode root) throws FeatureParsingException {
        if (name != null && value != null) {
            FeatureTreeNode entry = root.addChild(ENTRY);
            entry.setValue(value);
            entry.setAttribute(KEY, name);
        }
    }

    private static String getXPath(String key) {
        return "informationDict/entry[@key='" + key + "']";
    }

    @Override
    public FeaturesData getData() {
        return null;
    }

    static List<Feature> getFeaturesList() {
        ArrayList<Feature> featuresList = new ArrayList<Feature>();
        featuresList.add(new Feature(TITLE, InfoDictFeaturesObject.getXPath(TITLE), Feature.FeatureType.STRING));
        featuresList.add(new Feature(AUTHOR, InfoDictFeaturesObject.getXPath(AUTHOR), Feature.FeatureType.STRING));
        featuresList.add(new Feature(SUBJECT, InfoDictFeaturesObject.getXPath(SUBJECT), Feature.FeatureType.STRING));
        featuresList.add(new Feature(KEYWORDS, InfoDictFeaturesObject.getXPath(KEYWORDS), Feature.FeatureType.STRING));
        featuresList.add(new Feature(CREATOR, InfoDictFeaturesObject.getXPath(CREATOR), Feature.FeatureType.STRING));
        featuresList.add(new Feature(PRODUCER, InfoDictFeaturesObject.getXPath(PRODUCER), Feature.FeatureType.STRING));
        featuresList.add(new Feature("Creation Date", InfoDictFeaturesObject.getXPath(CREATION_DATE), Feature.FeatureType.STRING));
        featuresList.add(new Feature("Modification Date", InfoDictFeaturesObject.getXPath(MOD_DATE), Feature.FeatureType.STRING));
        featuresList.add(new Feature(TRAPPED, InfoDictFeaturesObject.getXPath(TRAPPED), Feature.FeatureType.STRING));
        featuresList.add(new Feature("Error IDs", InfoDictFeaturesObject.generateAttributeXPath(INFORMATION_DICT, "errorId"), Feature.FeatureType.STRING));
        return featuresList;
    }
}

