/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import java.util.Arrays;
import java.util.StringTokenizer;
import net.sf.saxon.trans.XPathException;

public class NestedIntegerValue
implements Comparable<NestedIntegerValue> {
    public static NestedIntegerValue ONE = new NestedIntegerValue(new int[]{1});
    public static NestedIntegerValue TWO = new NestedIntegerValue(new int[]{2});
    int[] value;

    public NestedIntegerValue(String v) throws XPathException {
        NestedIntegerValue.parse(v);
    }

    public NestedIntegerValue(int[] val) {
        this.value = val;
    }

    public static NestedIntegerValue parse(String v) throws XPathException {
        StringTokenizer st = new StringTokenizer(v, ".");
        int[] valuei = new int[st.countTokens()];
        try {
            int i = 0;
            while (st.hasMoreTokens()) {
                valuei[i] = Integer.parseInt(st.nextToken());
                ++i;
            }
        }
        catch (NumberFormatException exc) {
            throw new XPathException("Nested integer value has incorrect format: " + v);
        }
        return new NestedIntegerValue(valuei);
    }

    public NestedIntegerValue append(int leaf) {
        int[] v = new int[this.value.length + 1];
        System.arraycopy(this.value, 0, v, 0, this.value.length);
        v[this.value.length] = leaf;
        return new NestedIntegerValue(v);
    }

    public NestedIntegerValue getStem() {
        if (this.value.length == 0) {
            return null;
        }
        int[] v = new int[this.value.length - 1];
        System.arraycopy(this.value, 0, v, 0, v.length);
        return new NestedIntegerValue(v);
    }

    public int getDepth() {
        return this.value.length;
    }

    public int getLeaf() {
        if (this.value.length == 0) {
            return -1;
        }
        return this.value[this.value.length - 1];
    }

    public boolean equals(Object o) {
        return o instanceof NestedIntegerValue && Arrays.equals(this.value, ((NestedIntegerValue)o).value);
    }

    public int hashCode() {
        return Arrays.hashCode(this.value);
    }

    @Override
    public int compareTo(NestedIntegerValue other) {
        NestedIntegerValue v2 = other;
        for (int i = 0; i < this.value.length && i < v2.value.length; ++i) {
            if (this.value[i] == v2.value[i]) continue;
            if (this.value[i] < v2.value[i]) {
                return -1;
            }
            return 1;
        }
        return Integer.signum(this.value.length - v2.value.length);
    }
}

