/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.pd;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.pd.PDNameTreeNode;
import org.verapdf.pd.PDNamesDictionary;
import org.verapdf.pd.PDObject;
import org.verapdf.tools.StaticResources;

public class PDDestination
extends PDObject {
    public static final Logger LOGGER = Logger.getLogger(PDDestination.class.getCanonicalName());

    public PDDestination(COSObject obj) {
        super(obj);
    }

    public Boolean getIsStructDestination() {
        COSObject dests;
        COSObject destination = this.getObject();
        if (destination.getType() == COSObjType.COS_STRING) {
            PDNamesDictionary namesDictionary = StaticResources.getDocument().getCatalog().getNamesDictionary();
            if (namesDictionary == null) {
                return false;
            }
            PDNameTreeNode dests2 = namesDictionary.getDests();
            if (dests2 != null) {
                COSObject dest = dests2.getObject(destination.getString());
                if (dest == null) {
                    LOGGER.log(Level.WARNING, "Named destination " + destination.getString() + " not found in the Dests name tree in the Names dictionary");
                    return false;
                }
                destination = dest;
            }
        } else if (destination.getType() == COSObjType.COS_NAME && (dests = StaticResources.getDocument().getCatalog().getDests()) != null) {
            COSObject dest = dests.getKey(destination.getName());
            if (dest == null) {
                LOGGER.log(Level.WARNING, "Named destination " + destination.getName() + " not found in the Dests dictionary in the catalog");
                return false;
            }
            destination = dest;
        }
        if (destination.getType() == COSObjType.COS_DICT) {
            return destination.knownKey(ASAtom.SD);
        }
        if (destination.getType() == COSObjType.COS_ARRAY && destination.size() > 0) {
            return destination.at(0).knownKey(ASAtom.S);
        }
        return false;
    }
}

