/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.elab;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.elab.BooleanEvaluator;
import net.sf.saxon.expr.elab.EagerPullEvaluator;
import net.sf.saxon.expr.elab.Elaborator;
import net.sf.saxon.expr.elab.ItemEvaluator;
import net.sf.saxon.expr.elab.LazyPullEvaluator;
import net.sf.saxon.expr.elab.MemoClosureEvaluator;
import net.sf.saxon.expr.elab.PullEvaluator;
import net.sf.saxon.expr.elab.PushEvaluator;
import net.sf.saxon.expr.elab.SequenceEvaluator;
import net.sf.saxon.expr.elab.UnicodeStringEvaluator;
import net.sf.saxon.om.Item;

public class FallbackElaborator
extends Elaborator {
    @Override
    public SequenceEvaluator eagerly() {
        return new EagerPullEvaluator(this.elaborateForPull());
    }

    @Override
    public SequenceEvaluator lazily(boolean repeatable, boolean lazyEvaluationRequired) {
        Expression expr = this.getExpression();
        if (repeatable) {
            return new MemoClosureEvaluator(expr, this.elaborateForPull());
        }
        return new LazyPullEvaluator(this.elaborateForPull());
    }

    @Override
    public PullEvaluator elaborateForPull() {
        return context -> this.getExpression().iterate(context);
    }

    @Override
    public PushEvaluator elaborateForPush() {
        return (output, context) -> {
            this.getExpression().process(output, context);
            return null;
        };
    }

    @Override
    public ItemEvaluator elaborateForItem() {
        return context -> this.getExpression().evaluateItem(context);
    }

    @Override
    public BooleanEvaluator elaborateForBoolean() {
        return context -> this.getExpression().effectiveBooleanValue(context);
    }

    @Override
    public UnicodeStringEvaluator elaborateForUnicodeString(boolean zeroLengthWhenAbsent) {
        if (zeroLengthWhenAbsent) {
            return context -> this.getExpression().evaluateAsString(context);
        }
        return context -> {
            Item item = this.getExpression().evaluateItem(context);
            return item == null ? null : item.getUnicodeStringValue();
        };
    }
}

