/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.verapdf.gui.LogoPanel;
import org.verapdf.gui.PartnersPanel;
import org.verapdf.gui.utils.GUIConstants;

class AboutPanel
extends JPanel {
    private static final long serialVersionUID = -4011118192914036216L;
    static final Logger logger = Logger.getLogger(AboutPanel.class.getCanonicalName());
    private final JButton okButton;
    JDialog dialog;

    AboutPanel() throws IOException {
        this.setLayout(new BorderLayout());
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        this.add((Component)mainPanel, "Center");
        LogoPanel logo = new LogoPanel("org/verapdf/gui/images/veraPDF-logo.jpg", GUIConstants.LOGO_BACKGROUND, 10);
        mainPanel.add(logo);
        PartnersPanel partners = new PartnersPanel("org/verapdf/gui/images/partners.png", GUIConstants.PARTNERS_BACKGROUND);
        mainPanel.add(partners);
        this.okButton = new JButton("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                AboutPanel.this.dialog.setVisible(false);
            }
        });
        JButton urlLabel = new JButton("Visit veraPDF.org");
        urlLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                try {
                    Desktop.getDesktop().browse(new URI("http://www.verapdf.org"));
                }
                catch (IOException | URISyntaxException excep) {
                    JOptionPane.showMessageDialog(AboutPanel.this, "Error", "Error", 0);
                    logger.log(Level.SEVERE, "Exception in opening link http://www.verapdf.org", excep);
                }
            }
        });
        JPanel bottomPanel = new JPanel();
        bottomPanel.setLayout(new GridLayout(1, 2));
        JPanel labelPanel = new JPanel();
        labelPanel.setLayout(new FlowLayout(0));
        labelPanel.add(urlLabel);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout(2));
        buttonPanel.add(this.okButton);
        bottomPanel.add(labelPanel);
        bottomPanel.add(buttonPanel);
        this.add((Component)bottomPanel, "South");
    }

    void showDialog(Component parent, String title) {
        Frame owner = parent instanceof Frame ? (Frame)parent : (Frame)SwingUtilities.getAncestorOfClass(Frame.class, parent);
        if (this.dialog == null || this.dialog.getOwner() != owner) {
            this.dialog = new JDialog(owner, true);
            this.dialog.setResizable(false);
            this.dialog.add(this);
            this.dialog.getRootPane().setDefaultButton(this.okButton);
            this.dialog.pack();
            this.dialog.setTitle(title);
        }
        this.dialog.setLocation(150, 150);
        this.dialog.setVisible(true);
    }
}

