/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.parser;

import java.io.Closeable;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.verapdf.as.CharTable;
import org.verapdf.as.filters.io.ASBufferedInFilter;
import org.verapdf.as.io.ASInputStream;
import org.verapdf.cos.filters.COSFilterASCIIHexDecode;
import org.verapdf.parser.Token;

public class NotSeekableBaseParser
implements Closeable {
    private static final Logger LOGGER = Logger.getLogger(NotSeekableBaseParser.class.getCanonicalName());
    private static final byte ASCII_ZERO = 48;
    private static final byte ASCII_NINE = 57;
    protected ASBufferedInFilter source;
    private Token token;

    public NotSeekableBaseParser(ASInputStream stream) throws IOException {
        if (stream == null) {
            throw new IOException("Stream in NotSeekableBaseParser can't be null.");
        }
        this.source = new ASBufferedInFilter(stream);
        this.source.initialize();
    }

    @Override
    public void close() throws IOException {
        this.source.close();
    }

    protected void initializeToken() {
        if (this.token == null) {
            this.token = new Token();
        }
    }

    private void appendToToken(byte ch) {
        this.token.append((char)(ch & 0xFF));
    }

    private void appendToToken(int ch) {
        this.token.append((char)ch);
    }

    protected Token getToken() {
        return this.token;
    }

    protected String getLine() throws IOException {
        this.initializeToken();
        this.token.clearValue();
        byte ch = this.source.readByte();
        while (!this.source.isEOF() && ch != 10 && ch != 13) {
            this.appendToToken(ch);
            ch = this.source.readByte();
        }
        return this.token.getValue();
    }

    protected byte[] getLineBytes() throws IOException {
        this.getLine();
        return this.token.getByteValue();
    }

    protected String readUntilDelimiter() throws IOException {
        this.initializeToken();
        this.token.clearValue();
        byte ch = this.source.readByte();
        while (!CharTable.isSpace(ch) && !CharTable.isTokenDelimiter(ch)) {
            this.appendToToken(ch);
            if (this.source.isEOF()) break;
            ch = this.source.readByte();
        }
        if (CharTable.isSpace(ch) || CharTable.isTokenDelimiter(ch)) {
            this.source.unread();
        }
        return this.token.getValue();
    }

    protected boolean findKeyword(Token.Keyword keyword) throws IOException {
        this.nextToken();
        while (this.token.type != Token.Type.TT_EOF && (this.token.type != Token.Type.TT_KEYWORD || this.token.keyword != keyword)) {
            this.nextToken();
        }
        return this.token.type == Token.Type.TT_KEYWORD && this.token.keyword == keyword;
    }

    protected boolean findKeyword(Token.Keyword keyword, int lookUpSize) throws IOException {
        this.source.resetReadCounter();
        this.nextToken();
        while (this.token.type != Token.Type.TT_EOF && (this.token.type != Token.Type.TT_KEYWORD || this.token.keyword != keyword) && this.source.getReadCounter() < lookUpSize) {
            this.nextToken();
        }
        return this.token.type == Token.Type.TT_KEYWORD && this.token.keyword == keyword;
    }

    protected void nextToken() throws IOException {
        this.skipSpaces(true);
        if (this.source.isEOF()) {
            this.token.type = Token.Type.TT_EOF;
            return;
        }
        this.token.type = Token.Type.TT_NONE;
        byte ch = this.source.readByte();
        switch (ch) {
            case 40: {
                this.token.type = Token.Type.TT_LITSTRING;
                this.readLitString();
                break;
            }
            case 41: {
                break;
            }
            case 60: {
                ch = this.source.readByte();
                if (ch == 60) {
                    this.token.type = Token.Type.TT_OPENDICT;
                    break;
                }
                this.source.unread();
                this.token.type = Token.Type.TT_HEXSTRING;
                this.readHexString();
                break;
            }
            case 62: {
                ch = this.source.readByte();
                if (ch != 62) break;
                this.token.type = Token.Type.TT_CLOSEDICT;
                break;
            }
            case 91: {
                this.token.type = Token.Type.TT_OPENARRAY;
                break;
            }
            case 93: {
                this.token.type = Token.Type.TT_CLOSEARRAY;
                break;
            }
            case 123: {
                break;
            }
            case 125: {
                break;
            }
            case 47: {
                this.token.type = Token.Type.TT_NAME;
                this.readName();
                break;
            }
            case 46: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                this.source.unread();
                this.readNumber();
                break;
            }
            case 45: {
                this.readNumber();
                this.token.integer = -this.token.integer;
                this.token.real = -this.token.real;
                break;
            }
            default: {
                this.source.unread();
                this.readToken();
                this.token.toKeyword();
                if (this.token.keyword != Token.Keyword.KW_NONE) break;
                this.token.type = Token.Type.TT_NONE;
            }
        }
    }

    protected void skipSpaces() throws IOException {
        this.skipSpaces(false);
    }

    protected void skipSpaces(boolean skipComment) throws IOException {
        while (!this.source.isEOF()) {
            byte ch = this.source.readByte();
            if (CharTable.isSpace(ch)) continue;
            if (ch == 37 && skipComment) {
                this.skipComment();
                continue;
            }
            this.source.unread();
            break;
        }
    }

    protected void skipStreamSpaces() throws IOException {
        byte space = this.source.readByte();
        while (space == 32) {
            space = this.source.readByte();
        }
        if (space == 13) {
            space = this.source.readByte();
            if (space != 10) {
                this.source.unread();
            }
        } else if (space != 10) {
            this.source.unread();
        }
    }

    protected boolean isDigit() throws IOException {
        return NotSeekableBaseParser.isDigit(this.source.peek());
    }

    protected static boolean isDigit(byte c) {
        return c >= 48 && c <= 57;
    }

    private void skipComment() throws IOException {
        while (!this.source.isEOF()) {
            byte ch = this.source.readByte();
            if (NotSeekableBaseParser.isLF(ch)) {
                return;
            }
            if (!NotSeekableBaseParser.isCR(ch)) continue;
            ch = this.source.readByte();
            if (NotSeekableBaseParser.isLF(ch)) {
                this.source.unread();
            }
            return;
        }
    }

    protected static boolean isLF(int c) {
        return 10 == c;
    }

    protected static boolean isCR(int c) {
        return 13 == c;
    }

    private void readLitString() throws IOException {
        this.token.clearValue();
        int parenthesesDepth = 0;
        byte ch = this.source.readByte();
        while (!this.source.isEOF()) {
            block0 : switch (ch) {
                default: {
                    this.appendToToken(ch);
                    break;
                }
                case 40: {
                    ++parenthesesDepth;
                    this.appendToToken(ch);
                    break;
                }
                case 41: {
                    if (parenthesesDepth == 0) {
                        return;
                    }
                    --parenthesesDepth;
                    this.appendToToken(ch);
                    break;
                }
                case 92: {
                    ch = this.source.readByte();
                    switch (ch) {
                        case 40: {
                            this.appendToToken((byte)40);
                            break block0;
                        }
                        case 41: {
                            this.appendToToken((byte)41);
                            break block0;
                        }
                        case 110: {
                            this.appendToToken((byte)10);
                            break block0;
                        }
                        case 114: {
                            this.appendToToken((byte)13);
                            break block0;
                        }
                        case 116: {
                            this.appendToToken((byte)9);
                            break block0;
                        }
                        case 98: {
                            this.appendToToken((byte)8);
                            break block0;
                        }
                        case 102: {
                            this.appendToToken((byte)12);
                            break block0;
                        }
                        case 48: 
                        case 49: 
                        case 50: 
                        case 51: 
                        case 52: 
                        case 53: 
                        case 54: 
                        case 55: {
                            char ch1 = (char)(ch - 48);
                            for (int i = 1; i < 3; ++i) {
                                ch = this.source.readByte();
                                if (ch < 48 || ch > 55) {
                                    this.source.unread();
                                    break;
                                }
                                ch1 = (char)((ch1 << 3) + (ch - 48));
                            }
                            this.appendToToken(ch1);
                            break block0;
                        }
                        case 10: {
                            break block0;
                        }
                        case 13: {
                            ch = this.source.readByte();
                            if (ch == 10) break block0;
                            this.source.unread();
                            break block0;
                        }
                        default: {
                            this.appendToToken(ch);
                        }
                    }
                }
            }
            ch = this.source.readByte();
        }
    }

    private void readHexString() throws IOException {
        this.token.clearValue();
        int uc = 0;
        boolean containsOnlyHex = true;
        long hexCount = 0L;
        boolean odd = false;
        while (!this.source.isEOF()) {
            byte ch = this.source.readByte();
            if (CharTable.isSpace(ch)) continue;
            if (ch == 62) {
                if (odd) {
                    this.appendToToken(uc <<= 4);
                }
                this.token.setContainsOnlyHex(containsOnlyHex);
                this.token.setHexCount(hexCount);
                return;
            }
            byte hex = COSFilterASCIIHexDecode.decodeLoHex(ch);
            ++hexCount;
            if (hex < 16 && hex > -1) {
                if (odd) {
                    uc = (uc << 4) + hex;
                    this.appendToToken(uc);
                    uc = 0;
                } else {
                    uc = hex;
                }
                odd = !odd;
                continue;
            }
            containsOnlyHex = false;
        }
        this.token.setContainsOnlyHex(containsOnlyHex);
        this.token.setHexCount(hexCount);
    }

    private void readName() throws IOException {
        this.token.clearValue();
        while (!this.source.isEOF()) {
            byte ch = this.source.readByte();
            if (CharTable.isTokenDelimiter(ch)) {
                this.source.unread();
                break;
            }
            if (ch == 35) {
                byte ch1 = this.source.readByte();
                if (!this.source.isEOF() && COSFilterASCIIHexDecode.decodeLoHex(ch1) != 127) {
                    byte dc = COSFilterASCIIHexDecode.decodeLoHex(ch1);
                    byte ch2 = this.source.readByte();
                    if (!this.source.isEOF() && COSFilterASCIIHexDecode.decodeLoHex(ch2) != 127) {
                        dc = (byte)((dc << 4) + COSFilterASCIIHexDecode.decodeLoHex(ch2));
                        this.appendToToken(dc);
                        continue;
                    }
                    this.appendToToken(ch);
                    this.appendToToken(ch1);
                    this.source.unread();
                    continue;
                }
                this.appendToToken(ch);
                this.source.unread();
                continue;
            }
            this.appendToToken(ch);
        }
    }

    private void readToken() throws IOException {
        this.token.clearValue();
        while (!this.source.isEOF()) {
            byte ch = this.source.readByte();
            if (CharTable.isTokenDelimiter(ch)) {
                this.source.unread();
                break;
            }
            this.appendToToken(ch);
        }
    }

    protected void readNumber() throws IOException {
        try {
            this.initializeToken();
            this.token.clearValue();
            this.token.type = Token.Type.TT_INTEGER;
            while (!this.source.isEOF()) {
                byte ch = this.source.readByte();
                if (CharTable.isTokenDelimiter(ch)) {
                    this.source.unread();
                    break;
                }
                if (ch >= 48 && ch <= 57) {
                    this.appendToToken(ch);
                    continue;
                }
                if (ch == 46) {
                    this.token.type = Token.Type.TT_REAL;
                    this.appendToToken(ch);
                    continue;
                }
                this.source.unread();
                break;
            }
            if (this.token.type == Token.Type.TT_INTEGER) {
                long value;
                this.token.integer = value = Long.valueOf(this.token.getValue()).longValue();
                this.token.real = value;
            } else {
                double value = Double.valueOf(this.token.getValue());
                this.token.integer = Math.round(value);
                this.token.real = value;
            }
        }
        catch (NumberFormatException e) {
            LOGGER.log(Level.FINE, "", e);
        }
    }
}

