/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.apps;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import javax.xml.bind.JAXBException;
import org.verapdf.ReleaseDetails;
import org.verapdf.apps.ConfigManager;
import org.verapdf.apps.ConfigManagerImpl;
import org.verapdf.apps.ProcessType;
import org.verapdf.apps.SoftwareUpdater;
import org.verapdf.apps.SoftwareUpdaterImpl;
import org.verapdf.apps.VeraAppConfig;
import org.verapdf.apps.VeraAppConfigImpl;
import org.verapdf.processor.FormatOption;

public final class Applications {
    public static final String APP_HOME_PROPERTY = "app.home";
    public static final String DEFAULT_CONFIG_ROOT_NAME = "config";
    private static final String write_io_message = "IOException trying to write %s directory.";
    private static final String not_writable_message = "Arg root:%s must be a writable directory.";
    public static final String UPDATE_SERVICE_NOT_AVAILABLE = "Update Service not available";
    public static final String UPDATE_LATEST_VERSION = "You are currently running the latest version of veraPDF%s v%s";
    public static final String UPDATE_OLD_VERSION = "You are NOT running the latest version of veraPDF.\nYou are running version %s, the latest version is %s.\n";
    public static final String UPDATE_URI = "http://downloads.verapdf.org/rel/verapdf-installer.zip";
    private static final String VERAPDF = "verapdf";
    private static final String VERAPDF_WITH_BAT = "verapdf.bat";
    private static final String APPDATA_NAME = "APPDATA";
    private static final String USER_HOME_PROPERTY = "user.home";
    private static final String DOT = ".";

    private Applications() {
        assert (false);
    }

    public static File getVeraScriptFile() {
        File startFile = null;
        String appHome = System.getProperty(APP_HOME_PROPERTY);
        if (appHome != null) {
            File veraPdfDirectory = new File(appHome);
            startFile = Applications.getStartFile(veraPdfDirectory);
        }
        return startFile;
    }

    private static File getStartFile(File veraPdfDirectory) {
        File unixStartFile = new File(veraPdfDirectory, VERAPDF);
        if (unixStartFile.isFile()) {
            return unixStartFile;
        }
        File windowsStartFile = new File(veraPdfDirectory, VERAPDF_WITH_BAT);
        if (windowsStartFile.isFile()) {
            return windowsStartFile;
        }
        return null;
    }

    public static ReleaseDetails getAppDetails() {
        return ReleaseDetails.byId((String)"gui");
    }

    public static ConfigManager createConfigManager(File root) {
        if (root == null) {
            throw new NullPointerException("Arg root cannot be null");
        }
        if (!root.isDirectory() && !root.mkdir() || !Files.isWritable(root.toPath())) {
            throw new IllegalArgumentException(String.format(not_writable_message, root.getAbsolutePath()));
        }
        return ConfigManagerImpl.create(root);
    }

    public static ConfigManager createAppConfigManager() {
        File configRoot = new File("");
        try {
            configRoot = Applications.configRoot();
            return Applications.createConfigManager(configRoot);
        }
        catch (IOException excep) {
            throw new IllegalStateException(String.format(write_io_message, configRoot.getAbsolutePath()), excep);
        }
    }

    public static ConfigManager createTmpConfigManager() {
        try {
            return Applications.createConfigManager(Applications.tempRoot());
        }
        catch (IOException excep) {
            throw new IllegalStateException(String.format(write_io_message, "temp"), excep);
        }
    }

    public static VeraAppConfig defaultConfig() {
        return VeraAppConfigImpl.defaultInstance();
    }

    public static Builder defaultConfigBuilder() {
        return Builder.defaultBuilder();
    }

    public static Builder createConfigBuilder(VeraAppConfig base) {
        return Builder.fromConfig(base);
    }

    public static String toXml(VeraAppConfig toConvert, Boolean prettyXml) throws JAXBException, IOException {
        return VeraAppConfigImpl.toXml(toConvert, prettyXml);
    }

    public static void toXml(VeraAppConfig toConvert, OutputStream stream, Boolean prettyXml) throws JAXBException {
        VeraAppConfigImpl.toXml(toConvert, stream, prettyXml);
    }

    public static VeraAppConfigImpl fromXml(InputStream toConvert) throws JAXBException {
        return VeraAppConfigImpl.fromXml(toConvert);
    }

    public static void toXml(VeraAppConfig toConvert, Writer writer, Boolean prettyXml) throws JAXBException {
        VeraAppConfigImpl.toXml(toConvert, writer, prettyXml);
    }

    public static VeraAppConfigImpl fromXml(Reader toConvert) throws JAXBException {
        return VeraAppConfigImpl.fromXml(toConvert);
    }

    public static VeraAppConfigImpl fromXml(String toConvert) throws JAXBException {
        return VeraAppConfigImpl.fromXml(toConvert);
    }

    public static SoftwareUpdater softwareUpdater() {
        return new SoftwareUpdaterImpl();
    }

    public static void checkArgNotNull(Object arg, String argName) {
        if (arg == null) {
            throw new IllegalArgumentException(String.format("Parameter %s can not be null", argName));
        }
    }

    private static File configRoot() throws IOException {
        String path = System.getenv(APPDATA_NAME);
        path = path == null ? System.getProperty(USER_HOME_PROPERTY) + File.separator + DOT : path + File.separator;
        File localRoot = new File(path = path + VERAPDF + File.separator + DEFAULT_CONFIG_ROOT_NAME);
        if (localRoot.exists() && Applications.areDirectoryFilesWritable(localRoot)) {
            return localRoot;
        }
        File appHomeRoot = Applications.appHomeRoot();
        if (appHomeRoot != null && Files.isWritable(appHomeRoot.toPath()) && Applications.areDirectoryFilesWritable(appHomeRoot)) {
            return appHomeRoot;
        }
        if (localRoot.mkdirs() && Files.isWritable(localRoot.toPath())) {
            return localRoot;
        }
        return Applications.tempRoot();
    }

    private static File appHomeRoot() {
        File user;
        File f;
        String appHome = System.getProperty(APP_HOME_PROPERTY);
        if (appHome != null && ((f = new File(user = new File(appHome), DEFAULT_CONFIG_ROOT_NAME)).exists() || f.mkdir())) {
            return f;
        }
        return null;
    }

    private static File tempRoot() throws IOException {
        File temp = Files.createTempDirectory("", new FileAttribute[0]).toFile();
        temp.deleteOnExit();
        return temp;
    }

    private static boolean areDirectoryFilesWritable(File directory) {
        String[] files = directory.list();
        if (files == null) {
            return Files.isWritable(directory.toPath());
        }
        if (files.length == 0) {
            return true;
        }
        for (String fileName : files) {
            if (Files.isWritable(new File(directory + File.separator + fileName).toPath())) continue;
            return false;
        }
        return true;
    }

    public static class Builder {
        private ProcessType _type = ProcessType.VALIDATE;
        private String _fixerFolder = FileSystems.getDefault().getPath("", new String[0]).toString();
        private FormatOption _format = FormatOption.XML;
        private String _wikiPath = "https://github.com/veraPDF/veraPDF-validation-profiles/wiki/";
        private String _policyFile = FileSystems.getDefault().getPath("", new String[0]).toString();
        private boolean _isVerbose = false;

        private Builder() {
        }

        private Builder(VeraAppConfig config) {
            this._type = config.getProcessType();
            this._fixerFolder = config.getFixesFolder();
            this._format = config.getFormat();
            this._isVerbose = config.isVerbose();
            this._wikiPath = config.getWikiPath();
            this._policyFile = config.getPolicyFile();
        }

        public Builder type(ProcessType type) {
            this._type = type;
            return this;
        }

        public Builder fixerFolder(String fixerFold) {
            this._fixerFolder = fixerFold;
            return this;
        }

        public Builder format(FormatOption format) {
            this._format = format;
            return this;
        }

        public Builder isVerbose(boolean isVerbose) {
            this._isVerbose = isVerbose;
            return this;
        }

        public Builder wikiPath(String path) {
            this._wikiPath = path;
            return this;
        }

        public Builder policyFile(String policy) {
            this._policyFile = policy;
            return this;
        }

        public static Builder fromConfig(VeraAppConfig config) {
            return new Builder(config);
        }

        public static Builder defaultBuilder() {
            return new Builder();
        }

        public VeraAppConfig build() {
            return new VeraAppConfigImpl(this._type, this._fixerFolder, this._format, this._isVerbose, this._wikiPath, this._policyFile);
        }
    }
}

