/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gui;

import java.awt.Desktop;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BoxLayout;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.border.EmptyBorder;
import javax.xml.bind.JAXBException;
import javax.xml.stream.XMLStreamException;
import org.verapdf.ReleaseDetails;
import org.verapdf.apps.Applications;
import org.verapdf.apps.ConfigManager;
import org.verapdf.apps.SoftwareUpdater;
import org.verapdf.apps.VeraAppConfig;
import org.verapdf.core.utils.LogsFileHandler;
import org.verapdf.gui.AboutPanel;
import org.verapdf.gui.CheckerPanel;
import org.verapdf.gui.FeaturesConfigPanel;
import org.verapdf.gui.MiniLogoPanel;
import org.verapdf.gui.PolicyPanel;
import org.verapdf.gui.SettingsPanel;
import org.verapdf.metadata.fixer.FixerFactory;
import org.verapdf.metadata.fixer.MetadataFixerConfig;
import org.verapdf.pdfa.flavours.PDFAFlavour;
import org.verapdf.pdfa.validation.validators.ValidatorConfig;
import org.verapdf.pdfa.validation.validators.ValidatorFactory;
import org.verapdf.processor.FeaturesPluginsLoader;

public class PDFValidationApplication
extends JFrame {
    private static final ConfigManager configManager = Applications.createAppConfigManager();
    private static final long serialVersionUID = -5569669411392145783L;
    private static final Logger logger = Logger.getLogger(PDFValidationApplication.class.getCanonicalName());
    private AboutPanel aboutPanel;
    private SettingsPanel settingsPanel;
    private FeaturesConfigPanel featuresPanel;
    private CheckerPanel checkerPanel;
    private VeraAppConfig config;
    private PolicyPanel policyConfig;

    private PDFValidationApplication(double frameScale) {
        this.setDefaultCloseOperation(3);
        this.setBounds(100, 100, (int)(710.0 * frameScale), (int)(370.0 * frameScale));
        this.setResizable(false);
        this.setTitle("veraPDF Conformance Checker");
        this.config = configManager.getApplicationConfig();
        JMenuBar menuBar = new JMenuBar();
        menuBar.setLayout(new FlowLayout(0, 0, 0));
        this.setJMenuBar(menuBar);
        this.aboutPanel = null;
        try {
            this.aboutPanel = new AboutPanel();
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this, "Error in reading logo image.", "Error", 0);
            logger.log(Level.WARNING, "Exception in reading logo image", e);
        }
        JMenu file = new JMenu("File");
        menuBar.add(file);
        try {
            this.settingsPanel = new SettingsPanel(configManager);
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this, "Error initialising settings panel.", "Error", 0);
            logger.log(Level.SEVERE, "Exception in initialising settings panel", e);
        }
        JMenuItem sett = new JMenuItem("Settings");
        sett.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (PDFValidationApplication.this.settingsPanel != null && PDFValidationApplication.this.settingsPanel.showDialog(PDFValidationApplication.this, "Settings", configManager)) {
                    Applications.Builder confBuilder = Applications.Builder.fromConfig(configManager.getApplicationConfig());
                    confBuilder.wikiPath(PDFValidationApplication.this.settingsPanel.getProfilesWikiPath());
                    confBuilder.fixerFolder(PDFValidationApplication.this.settingsPanel.getFixMetadataDirectory().toString());
                    try {
                        configManager.updateAppConfig(confBuilder.build());
                    }
                    catch (IOException | JAXBException excep) {
                        excep.printStackTrace();
                    }
                    ValidatorConfig validConf = ValidatorFactory.createConfig((PDFAFlavour)configManager.getValidatorConfig().getFlavour(), (PDFAFlavour)PDFValidationApplication.this.settingsPanel.getCurrentDefaultFlavour(), (boolean)PDFValidationApplication.this.settingsPanel.isDispPassedRules(), (int)PDFValidationApplication.this.settingsPanel.getFailedChecksNumber(), (boolean)configManager.getValidatorConfig().isDebug(), (boolean)PDFValidationApplication.this.settingsPanel.isLogsEnabled(), (Level)PDFValidationApplication.this.settingsPanel.getLoggingLevel(), (int)PDFValidationApplication.this.settingsPanel.getFailedChecksDisplayNumber(), (boolean)PDFValidationApplication.this.settingsPanel.showErrorMessages(), null, (boolean)false, (boolean)false);
                    try {
                        configManager.updateValidatorConfig(validConf);
                    }
                    catch (IOException | JAXBException excep) {
                        excep.printStackTrace();
                    }
                    MetadataFixerConfig fixConf = FixerFactory.configFromValues((String)PDFValidationApplication.this.settingsPanel.getFixMetadataPrefix(), (boolean)true);
                    try {
                        configManager.updateFixerConfig(fixConf);
                    }
                    catch (IOException | JAXBException excep) {
                        excep.printStackTrace();
                    }
                }
            }
        });
        file.add(sett);
        file.addSeparator();
        JMenuItem quit = new JMenuItem("Quit");
        quit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PDFValidationApplication.this.processWindowEvent(new WindowEvent(PDFValidationApplication.this, 201));
            }
        });
        quit.setAccelerator(KeyStroke.getKeyStroke(81, 2));
        file.add(quit);
        JMenu policy = new JMenu("Configs");
        this.featuresPanel = new FeaturesConfigPanel();
        JMenuItem features = new JMenuItem("Features Config");
        features.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (PDFValidationApplication.this.featuresPanel != null && PDFValidationApplication.this.featuresPanel.showDialog(PDFValidationApplication.this, "Features Config", configManager.getFeaturesConfig())) {
                    try {
                        configManager.updateFeaturesConfig(PDFValidationApplication.this.featuresPanel.getFeaturesConfig());
                    }
                    catch (IOException | JAXBException exp) {
                        logger.log(Level.SEVERE, "Exception in updating features config", exp);
                    }
                }
            }
        });
        menuBar.add(policy);
        policy.add(features);
        this.policyConfig = new PolicyPanel();
        JMenuItem policyPanel = new JMenuItem("Policy Config");
        policyPanel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (PDFValidationApplication.this.policyConfig != null && PDFValidationApplication.this.policyConfig.showDialog(PDFValidationApplication.this)) {
                    try {
                        JFileChooser jfc;
                        int dialogRes;
                        File jfcStartingPath = PDFValidationApplication.this.policyConfig.getPolicyFile();
                        if (jfcStartingPath == null) {
                            jfcStartingPath = new File(".");
                        }
                        if ((dialogRes = (jfc = new JFileChooser(jfcStartingPath.getCanonicalPath())).showDialog(PDFValidationApplication.this, "Save policy config file")) == 0) {
                            PDFValidationApplication.this.policyConfig.setPolicyFile(jfc.getSelectedFile());
                            PDFValidationApplication.this.policyConfig.writeSchematronFile();
                            PDFValidationApplication.this.checkerPanel.setPolicyFile(PDFValidationApplication.this.policyConfig.getPolicyFile());
                        }
                    }
                    catch (IOException | XMLStreamException ex) {
                        JOptionPane.showMessageDialog(PDFValidationApplication.this, "Error in saving policy config file.", "Error", 0);
                        logger.log(Level.SEVERE, "Error in saving policy config file.", ex);
                    }
                }
            }
        });
        policy.add(policyPanel);
        JMenuItem about = new JMenuItem("About");
        about.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (PDFValidationApplication.this.aboutPanel != null) {
                    PDFValidationApplication.this.aboutPanel.showDialog(PDFValidationApplication.this, "About veraPDF");
                }
            }
        });
        JMenuItem checkForUpdates = new JMenuItem("Check for Updates...");
        checkForUpdates.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SoftwareUpdater updater = Applications.softwareUpdater();
                if (!updater.isOnline()) {
                    JOptionPane.showMessageDialog(PDFValidationApplication.this, "Update Service not available", "Check for Updates...", 2);
                    return;
                }
                ReleaseDetails details = ReleaseDetails.byId((String)"gui");
                if (updater.isUpdateAvailable(details)) {
                    int res = JOptionPane.showConfirmDialog(PDFValidationApplication.this, String.format("You are NOT running the latest version of veraPDF.\nYou are running version %s, the latest version is %s.\n", details.getVersion(), updater.getLatestVersion(details)) + String.format("Do you want to download the latest version from:\n%s?", "http://downloads.verapdf.org/rel/verapdf-installer.zip"), "Check for Updates...", 0, 2);
                    if (res == 0) {
                        PDFValidationApplication.this.attemptURIOpen("http://downloads.verapdf.org/rel/verapdf-installer.zip");
                    }
                } else {
                    JOptionPane.showMessageDialog(PDFValidationApplication.this, String.format("You are currently running the latest version of veraPDF%s v%s", "\n", details.getVersion()), "Check for Updates...", 1);
                }
            }
        });
        JMenuItem guiHelp = new JMenuItem("GUI");
        guiHelp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PDFValidationApplication.this.attemptURIOpen("http://docs.verapdf.org/gui");
            }
        });
        JMenuItem validationHelp = new JMenuItem("Validation");
        validationHelp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PDFValidationApplication.this.attemptURIOpen("http://docs.verapdf.org/validation");
            }
        });
        JMenuItem policyHelp = new JMenuItem("Policy");
        policyHelp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PDFValidationApplication.this.attemptURIOpen("http://docs.verapdf.org/policy");
            }
        });
        JMenu help = new JMenu("Help");
        help.add(guiHelp);
        help.add(validationHelp);
        help.add(policyHelp);
        help.addSeparator();
        help.add(checkForUpdates);
        help.add(about);
        menuBar.add(help);
        JPanel contentPane = new JPanel();
        contentPane.setBorder(new EmptyBorder(5, 5, 5, 5));
        contentPane.setLayout(new BoxLayout(contentPane, 1));
        this.setContentPane(contentPane);
        MiniLogoPanel logoPanel = null;
        try {
            logoPanel = new MiniLogoPanel("org/verapdf/gui/images/veraPDF-logo.jpg");
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this, "Error in creating mini logo.", "Error", 0);
            logger.log(Level.WARNING, "Exception in creating mini logo", e);
        }
        contentPane.add(logoPanel);
        this.checkerPanel = null;
        try {
            this.checkerPanel = new CheckerPanel(configManager);
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this, "Error in loading xml or html image.", "Error", 0);
            logger.log(Level.WARNING, "Exception in loading xml or html image", e);
        }
        contentPane.add(this.checkerPanel);
    }

    private void attemptURIOpen(String uri) {
        try {
            Desktop.getDesktop().browse(new URI(uri));
        }
        catch (IOException | UnsupportedOperationException | URISyntaxException excep) {
            String message = String.format("Couldn't open online help. Please, try opening this link manually %s", uri);
            JOptionPane.showMessageDialog(this, message, "Error", 0);
            logger.log(Level.SEVERE, "Exception in opening link " + uri, excep);
        }
    }

    public static void main(String[] args) {
        LogsFileHandler.configLogs();
        FeaturesPluginsLoader.setBaseFolderPath((String)System.getProperty("app.home"));
        double frameScale = 1.0;
        if (args.length > 1 && "--frameScale".equals(args[0]) && args[1] != null) {
            try {
                frameScale = Double.valueOf(args[1]);
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
        }
        ReleaseDetails.addDetailsFromResource((String)"org/verapdf/release/app.properties");
        final double finalFrameScale = frameScale;
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException e) {
                    logger.log(Level.SEVERE, "Exception in configuring UI manager", e);
                }
                try {
                    PDFValidationApplication frame = new PDFValidationApplication(finalFrameScale);
                    URL url = ClassLoader.getSystemResource("org/verapdf/gui/images/icon.png");
                    Toolkit kit = Toolkit.getDefaultToolkit();
                    frame.setIconImage(kit.createImage(url));
                    frame.setVisible(true);
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, "Exception", e);
                }
            }
        });
    }

    class ExitWindowAdapter
    extends WindowAdapter {
        ExitWindowAdapter() {
        }

        @Override
        public void windowClosing(WindowEvent e) {
            try {
                configManager.updateAppConfig(PDFValidationApplication.this.config);
            }
            catch (IOException | JAXBException excep) {
                excep.printStackTrace();
            }
        }
    }
}

