/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.apps;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import org.verapdf.ReleaseDetails;
import org.verapdf.apps.SoftwareUpdater;
import org.verapdf.apps.SoftwareUpdaterImpl;
import org.verapdf.processor.app.AppConfigBuilder;
import org.verapdf.processor.app.ConfigManager;
import org.verapdf.processor.app.ConfigManagerImpl;
import org.verapdf.processor.app.VeraAppConfig;
import org.verapdf.processor.app.VeraAppConfigImpl;

public final class Applications {
    public static final String APP_HOME_PROPERTY = "app.home";
    public static final String DEFAULT_CONFIG_ROOT_NAME = "config";
    private static final String write_io_message = "IOException trying to write %s directory.";
    private static final String not_writable_message = "Arg root:%s must be a writable directory.";
    public static final String UPDATE_SERVICE_NOT_AVAILABLE = "Update Service not available";
    public static final String UPDATE_LATEST_VERSION = "You are currently running the latest version of veraPDF%s v%s";
    public static final String UPDATE_OLD_VERSION = "You are NOT running the latest version of veraPDF.\nYou are running version %s, the latest version is %s.\n";
    public static final String UPDATE_URI = "http://downloads.verapdf.org/rel/verapdf-installer.zip";
    private static final String VERAPDF = "verapdf";
    private static final String VERAPDF_WITH_BAT = "verapdf.bat";
    private static final String APPDATA_NAME = "APPDATA";
    private static final String USER_HOME_PROPERTY = "user.home";
    private static final String DOT = ".";

    private Applications() {
        assert (false);
    }

    public static File getVeraScriptFile() {
        File startFile = null;
        String appHome = System.getProperty(APP_HOME_PROPERTY);
        if (appHome != null) {
            File veraPdfDirectory = new File(appHome);
            startFile = Applications.getStartFile(veraPdfDirectory);
        }
        return startFile;
    }

    private static File getStartFile(File veraPdfDirectory) {
        File unixStartFile = new File(veraPdfDirectory, VERAPDF);
        if (unixStartFile.isFile()) {
            return unixStartFile;
        }
        File windowsStartFile = new File(veraPdfDirectory, VERAPDF_WITH_BAT);
        if (windowsStartFile.isFile()) {
            return windowsStartFile;
        }
        return null;
    }

    public static ReleaseDetails getAppDetails() {
        return ReleaseDetails.byId((String)"gui");
    }

    public static ConfigManager createConfigManager(File root) {
        if (root == null) {
            throw new NullPointerException("Arg root cannot be null");
        }
        if (!root.isDirectory() && !root.mkdir() || !Files.isWritable(root.toPath())) {
            throw new IllegalArgumentException(String.format(not_writable_message, root.getAbsolutePath()));
        }
        return ConfigManagerImpl.create((File)root);
    }

    public static ConfigManager createAppConfigManager() {
        File configRoot = new File("");
        try {
            configRoot = Applications.configRoot();
            return Applications.createConfigManager(configRoot);
        }
        catch (IOException excep) {
            throw new IllegalStateException(String.format(write_io_message, configRoot.getAbsolutePath()), excep);
        }
    }

    public static ConfigManager createTmpConfigManager() {
        try {
            return Applications.createConfigManager(Applications.tempRoot());
        }
        catch (IOException excep) {
            throw new IllegalStateException(String.format(write_io_message, "temp"), excep);
        }
    }

    public static VeraAppConfig defaultConfig() {
        return VeraAppConfigImpl.defaultInstance();
    }

    public static AppConfigBuilder defaultConfigBuilder() {
        return AppConfigBuilder.defaultBuilder();
    }

    public static AppConfigBuilder createConfigBuilder(VeraAppConfig base) {
        return AppConfigBuilder.fromConfig((VeraAppConfig)base);
    }

    public static SoftwareUpdater softwareUpdater() {
        return new SoftwareUpdaterImpl();
    }

    public static void checkArgNotNull(Object arg, String argName) {
        if (arg == null) {
            throw new IllegalArgumentException(String.format("Parameter %s can not be null", argName));
        }
    }

    private static File configRoot() throws IOException {
        String path = System.getenv(APPDATA_NAME);
        path = path == null ? System.getProperty(USER_HOME_PROPERTY) + File.separator + DOT : path + File.separator;
        File localRoot = new File(path = path + VERAPDF + File.separator + DEFAULT_CONFIG_ROOT_NAME);
        if (localRoot.exists() && Applications.areDirectoryFilesWritable(localRoot)) {
            return localRoot;
        }
        File appHomeRoot = Applications.appHomeRoot();
        if (appHomeRoot != null && Files.isWritable(appHomeRoot.toPath()) && Applications.areDirectoryFilesWritable(appHomeRoot)) {
            return appHomeRoot;
        }
        if (localRoot.mkdirs() && Files.isWritable(localRoot.toPath())) {
            return localRoot;
        }
        return Applications.tempRoot();
    }

    private static File appHomeRoot() {
        File user;
        File f;
        String appHome = System.getProperty(APP_HOME_PROPERTY);
        if (appHome != null && ((f = new File(user = new File(appHome), DEFAULT_CONFIG_ROOT_NAME)).exists() || f.mkdir())) {
            return f;
        }
        return null;
    }

    private static File tempRoot() throws IOException {
        File temp = Files.createTempDirectory("", new FileAttribute[0]).toFile();
        temp.deleteOnExit();
        return temp;
    }

    private static boolean areDirectoryFilesWritable(File directory) {
        String[] files = directory.list();
        if (files == null) {
            return Files.isWritable(directory.toPath());
        }
        if (files.length == 0) {
            return true;
        }
        for (String fileName : files) {
            if (Files.isWritable(new File(directory + File.separator + fileName).toPath())) continue;
            return false;
        }
        return true;
    }
}

