/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.io;

import java.io.IOException;
import java.io.InputStream;
import org.apache.pdfbox.io.RandomAccessRead;

public class RandomAccessReadInputStream
extends InputStream {
    private final RandomAccessRead input;
    private long currentPosition;
    private final long endPosition;

    public RandomAccessReadInputStream(RandomAccessRead randomAccessRead, long startPosition, long length) {
        this.input = randomAccessRead;
        this.currentPosition = startPosition;
        this.endPosition = this.currentPosition + length;
    }

    @Override
    public int available() {
        return (int)(this.endPosition - this.currentPosition);
    }

    @Override
    public void close() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read() throws IOException {
        RandomAccessRead randomAccessRead = this.input;
        synchronized (randomAccessRead) {
            int retval = -1;
            if (this.currentPosition < this.endPosition) {
                this.input.seek(this.currentPosition);
                ++this.currentPosition;
                retval = this.input.read();
            }
            return retval;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(byte[] b, int offset, int length) throws IOException {
        if (length > this.available()) {
            length = this.available();
        }
        int amountRead = -1;
        if (this.available() > 0) {
            RandomAccessRead randomAccessRead = this.input;
            synchronized (randomAccessRead) {
                this.input.seek(this.currentPosition);
                amountRead = this.input.read(b, offset, length);
            }
        }
        if (amountRead > 0) {
            this.currentPosition += (long)amountRead;
        }
        return amountRead;
    }

    @Override
    public long skip(long amountToSkip) {
        long amountSkipped = Math.min(amountToSkip, (long)this.available());
        this.currentPosition += amountSkipped;
        return amountSkipped;
    }
}

