/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.interactive.form;

import java.io.IOException;
import java.util.List;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.common.COSObjectable;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotationWidget;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAppearanceEntry;
import org.apache.pdfbox.pdmodel.interactive.form.PDAcroForm;
import org.apache.pdfbox.pdmodel.interactive.form.PDButton;
import org.apache.pdfbox.pdmodel.interactive.form.PDNonTerminalField;

public final class PDRadioButton
extends PDButton {
    private static final int FLAG_NO_TOGGLE_TO_OFF = 16384;

    public PDRadioButton(PDAcroForm acroForm) {
        super(acroForm);
        this.setRadioButton(true);
    }

    PDRadioButton(PDAcroForm acroForm, COSDictionary field, PDNonTerminalField parent) {
        super(acroForm, field, parent);
    }

    public void setRadiosInUnison(boolean radiosInUnison) {
        this.dictionary.setFlag(COSName.FF, 0x2000000, radiosInUnison);
    }

    public boolean isRadiosInUnison() {
        return this.dictionary.getFlag(COSName.FF, 0x2000000);
    }

    public String getExportValue() throws IOException {
        List<String> options = this.getOptions();
        if (options.isEmpty()) {
            return this.getValue();
        }
        String fieldValue = this.getValue();
        List<PDAnnotationWidget> kids = this.getWidgets();
        int idx = 0;
        for (COSObjectable cOSObjectable : kids) {
        }
        if (idx <= options.size()) {
            return options.get(idx);
        }
        return "";
    }

    public String getValue() {
        COSBase value = this.getInheritableAttribute(COSName.V);
        if (value instanceof COSName) {
            return ((COSName)value).getName();
        }
        return "";
    }

    public String getDefaultValue() {
        COSBase value = this.getInheritableAttribute(COSName.DV);
        if (value instanceof COSName) {
            return ((COSName)value).getName();
        }
        return "";
    }

    @Override
    public String getValueAsString() {
        return this.getValue();
    }

    public void setValue(String value) throws IOException {
        this.dictionary.setName(COSName.V, value);
        for (PDAnnotationWidget widget : this.getWidgets()) {
            PDAppearanceEntry appearanceEntry = widget.getAppearance().getNormalAppearance();
            if (((COSDictionary)appearanceEntry.getCOSObject()).containsKey(value)) {
                widget.getCOSObject().setName(COSName.AS, value);
                continue;
            }
            widget.getCOSObject().setItem(COSName.AS, (COSBase)COSName.OFF);
        }
        this.applyChange();
    }

    public void setDefaultValue(String value) throws IOException {
        this.dictionary.setName(COSName.DV, value);
    }
}

