/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.model.tools.resources;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.PDResources;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.graphics.PDXObject;
import org.apache.pdfbox.pdmodel.graphics.color.PDColorSpace;
import org.apache.pdfbox.pdmodel.graphics.color.PDDeviceCMYK;
import org.apache.pdfbox.pdmodel.graphics.color.PDDeviceGray;
import org.apache.pdfbox.pdmodel.graphics.color.PDDeviceRGB;
import org.apache.pdfbox.pdmodel.graphics.pattern.PDAbstractPattern;
import org.apache.pdfbox.pdmodel.graphics.shading.PDShading;
import org.apache.pdfbox.pdmodel.graphics.state.PDExtendedGraphicsState;
import org.verapdf.model.tools.resources.PDEmptyInheritableResources;

public class PDInheritableResources {
    private static final Logger LOGGER = Logger.getLogger(PDInheritableResources.class.getCanonicalName());
    public static final PDResources EMPTY_RESOURCES = new PDResources();
    public static final PDInheritableResources EMPTY_EXTENDED_RESOURCES = new PDEmptyInheritableResources();
    private final PDResources currentResources;
    private final PDResources inheritedResources;
    private Set<COSName> undefinedResourceNames = new HashSet<COSName>();
    private Set<COSName> inheritedResourceNames = new HashSet<COSName>();
    private final HashMap<COSName, PDFont> fontCache = new HashMap();

    protected PDInheritableResources(PDResources inheritedResources, PDResources currentResources) {
        this.inheritedResources = inheritedResources;
        this.currentResources = currentResources;
    }

    public PDResources getInheritedResources() {
        return this.inheritedResources;
    }

    public PDResources getCurrentResources() {
        return this.currentResources;
    }

    public PDInheritableResources getExtendedResources(PDResources resources) {
        return PDInheritableResources.getInstance(this.currentResources, resources);
    }

    public PDFont getFont(COSName name) throws IOException {
        PDFont ret = this.fontCache.get(name);
        if (ret == null) {
            PDFont font = this.currentResources.getFont(name);
            if (font == null && (font = this.inheritedResources.getFont(name)) != null) {
                font.setInherited(true);
                this.inheritedResourceNames.add(name);
            }
            this.fontCache.put(name, font);
            ret = font;
        }
        if (ret == null) {
            this.undefinedResourceNames.add(name);
        }
        return ret;
    }

    public PDColorSpace getColorSpace(COSName name) throws IOException {
        PDColorSpace colorSpace;
        try {
            if (this.isDefaultColorSpaceUsed(name)) {
                PDColorSpace colorSpace2 = this.inheritedResources.getColorSpace(name);
                if (colorSpace2 == null) {
                    this.undefinedResourceNames.add(name);
                }
                return colorSpace2;
            }
            colorSpace = this.currentResources.getColorSpace(name);
            if (colorSpace != null) {
                return colorSpace;
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.INFO, "Problems during color space obtain from current resource dictionary. Trying to find it in inherited dictionary " + e.getMessage());
        }
        colorSpace = this.inheritedResources.getColorSpace(name);
        colorSpace = this.setInheritedColorSpace(colorSpace, name);
        if (colorSpace == null) {
            this.undefinedResourceNames.add(name);
        }
        return colorSpace;
    }

    public PDExtendedGraphicsState getExtGState(COSName name) {
        PDExtendedGraphicsState state = this.currentResources.getExtGState(name);
        if (state != null) {
            return state;
        }
        state = this.inheritedResources.getExtGState(name);
        if (state != null) {
            state.setInherited(true);
            this.inheritedResourceNames.add(name);
            return state;
        }
        this.undefinedResourceNames.add(name);
        return null;
    }

    public PDShading getShading(COSName name) throws IOException {
        PDShading shading = this.currentResources.getShading(name);
        if (shading != null) {
            return shading;
        }
        shading = this.inheritedResources.getShading(name);
        if (shading != null) {
            this.inheritedResourceNames.add(name);
            shading.setInherited(true);
            return shading;
        }
        this.undefinedResourceNames.add(name);
        return null;
    }

    public PDAbstractPattern getPattern(COSName name) throws IOException {
        PDAbstractPattern pattern = this.currentResources.getPattern(name);
        if (pattern != null) {
            return pattern;
        }
        pattern = this.inheritedResources.getPattern(name);
        if (pattern != null) {
            this.inheritedResourceNames.add(name);
            pattern.setInherited(true);
            return pattern;
        }
        this.undefinedResourceNames.add(name);
        return null;
    }

    public PDXObject getXObject(COSName name) throws IOException {
        PDXObject object = this.currentResources.getXObject(name);
        if (object != null) {
            return object;
        }
        object = this.inheritedResources.getXObject(name);
        if (object != null) {
            this.inheritedResourceNames.add(name);
            object.setInherited(true);
            return object;
        }
        this.undefinedResourceNames.add(name);
        return null;
    }

    private boolean isDefaultColorSpaceUsed(COSName name) {
        if (PDInheritableResources.isDeviceDepended(name)) {
            COSName value = PDColorSpace.getDefaultValue(this.currentResources, name);
            if (value != null) {
                return false;
            }
            value = PDColorSpace.getDefaultValue(this.inheritedResources, name);
            if (value != null) {
                return true;
            }
        }
        return false;
    }

    private static boolean isDeviceDepended(COSName name) {
        return COSName.DEVICERGB.equals(name) || COSName.DEVICEGRAY.equals(name) || COSName.DEVICECMYK.equals(name);
    }

    private PDColorSpace setInheritedColorSpace(PDColorSpace colorSpace, COSName name) {
        if (colorSpace == PDDeviceCMYK.INSTANCE) {
            return PDDeviceCMYK.INHERITED_INSTANCE;
        }
        if (colorSpace == PDDeviceRGB.INSTANCE) {
            return PDDeviceRGB.INHERITED_INSTANCE;
        }
        if (colorSpace == PDDeviceGray.INSTANCE) {
            return PDDeviceGray.INHERITED_INSTANCE;
        }
        colorSpace.setInherited(true);
        this.inheritedResourceNames.add(name);
        return colorSpace;
    }

    public static PDInheritableResources getInstance(PDResources pageResources) {
        return PDInheritableResources.getInstance(null, pageResources);
    }

    public static PDInheritableResources getInstance(PDResources inheritedResources, PDResources currentResources) {
        inheritedResources = inheritedResources != null && currentResources == null ? inheritedResources : EMPTY_RESOURCES;
        currentResources = currentResources != null ? currentResources : EMPTY_RESOURCES;
        return new PDInheritableResources(inheritedResources, currentResources);
    }

    public Set<COSName> getUndefinedResourceNames() {
        return this.undefinedResourceNames;
    }

    public Set<COSName> getInheritedResourceNames() {
        return this.inheritedResourceNames;
    }
}

