/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.pdfa.flavours;

import org.verapdf.pdfa.flavours.PDFAFlavour;

public class PDFFlavours {
    public static boolean isPDFUARelatedFlavour(PDFAFlavour flavour) {
        return PDFFlavours.isFlavourFamily(flavour, PDFAFlavour.SpecificationFamily.PDF_UA) || PDFFlavours.isWTPDFFlavour(flavour) || PDFFlavours.isWCAGFlavour(flavour);
    }

    public static boolean isPDFUA1RelatedFlavour(PDFAFlavour flavour) {
        return PDFFlavours.isFlavour(flavour, PDFAFlavour.PDFUA_1) || PDFFlavours.isWCAGFlavour(flavour);
    }

    public static boolean isPDFUA2RelatedFlavour(PDFAFlavour flavour) {
        return PDFFlavours.isFlavour(flavour, PDFAFlavour.PDFUA_2) || PDFFlavours.isFlavourPart(flavour, PDFAFlavour.Specification.WTPDF_1_0);
    }

    public static boolean isWCAGFlavour(PDFAFlavour flavour) {
        return PDFFlavours.isFlavourFamily(flavour, PDFAFlavour.SpecificationFamily.WCAG);
    }

    public static boolean isWTPDFFlavour(PDFAFlavour flavour) {
        return PDFFlavours.isFlavourFamily(flavour, PDFAFlavour.SpecificationFamily.WTPDF);
    }

    public static boolean isFlavour(PDFAFlavour currentFlavour, PDFAFlavour checkedFlavour) {
        return currentFlavour == checkedFlavour;
    }

    public static boolean isFlavourFamily(PDFAFlavour flavour, PDFAFlavour.SpecificationFamily family) {
        return flavour != null && flavour.getPart().getFamily() == family;
    }

    public static boolean isFlavourPart(PDFAFlavour flavour, PDFAFlavour.Specification part) {
        return flavour != null && flavour.getPart() == part;
    }

    public static boolean isPDFSpecification(PDFAFlavour flavour, PDFAFlavour.PDFSpecification pdfSpecification) {
        return flavour != null && flavour.getPart().getPdfSpecification() == pdfSpecification;
    }

    public static boolean isFlavourISOSeries(PDFAFlavour flavour, PDFAFlavour.IsoStandardSeries isoStandardSeries) {
        return flavour != null && flavour.getPart().getSeries() == isoStandardSeries;
    }
}

