/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.model.tools.xmp.validators;

import java.util.regex.Pattern;
import org.verapdf.model.tools.xmp.validators.TypeValidator;
import org.verapdf.xmp.impl.VeraPDFXMPNode;

public class SimpleTypeValidator
implements TypeValidator {
    private Pattern pattern;

    private SimpleTypeValidator(Pattern pattern) {
        this.pattern = pattern;
    }

    public static SimpleTypeValidator fromValue(SimpleTypeEnum type) {
        if (type == null) {
            throw new IllegalArgumentException("Argument type can not be null");
        }
        String regexp = type.getRegexp();
        return new SimpleTypeValidator(Pattern.compile(regexp));
    }

    public static SimpleTypeValidator fromValue(Pattern pattern) {
        if (pattern == null) {
            throw new IllegalArgumentException("Argument type can not be null");
        }
        return new SimpleTypeValidator(pattern);
    }

    @Override
    public boolean isCorresponding(VeraPDFXMPNode node) {
        if (node == null) {
            throw new IllegalArgumentException("Argument node can not be null");
        }
        return node.getOptions().isSimple() && (this.pattern == null || this.pattern.matcher(node.getValue()).matches());
    }

    public static enum SimpleTypeEnum {
        BOOLEAN("boolean", "^True$|^False$"),
        INTEGER("integer", "^[+-]?\\d+$"),
        REAL("real", "^[+-]?\\d+\\.?\\d*|[+-]?\\d*\\.?\\d+$"),
        MIME_TYPE("mimetype", "^[-\\w+\\.]+/[-\\w+\\.]+$"),
        PROPER_NAME("propername", "(?s)(^.*$)"),
        TEXT("text", "(?s)(^.*$)"),
        AGENT_NAME("agentname", "(?s)(^.*$)"),
        RATIONAL("rational", "(?s)(^.*$)"),
        RENDITION_CLASS("renditionclass", "(?s)(^.*$)");

        private String type;
        private String regexp;

        private SimpleTypeEnum(String type, String regexp) {
            this.type = type;
            this.regexp = regexp;
        }

        public String getType() {
            return this.type;
        }

        public String getRegexp() {
            return this.regexp;
        }

        public static SimpleTypeEnum fromString(String type) {
            if (type != null) {
                for (SimpleTypeEnum typeEnum : SimpleTypeEnum.values()) {
                    if (!type.equalsIgnoreCase(typeEnum.type)) continue;
                    return typeEnum;
                }
            }
            return null;
        }
    }
}

