/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.model.impl.pb.pd.pboxse;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import org.apache.pdfbox.cos.COSDictionary;
import org.verapdf.model.impl.pb.pd.PBoxPDStructElem;
import org.verapdf.model.impl.pb.pd.pboxse.PBoxSEGeneral;
import org.verapdf.model.impl.pb.pd.pboxse.PBoxSETD;
import org.verapdf.model.impl.pb.pd.pboxse.PBoxSETH;
import org.verapdf.model.pdlayer.PDStructElem;
import org.verapdf.model.selayer.SETable;
import org.verapdf.model.tools.TaggedPDFRoleMapHelper;

public class PBoxSETable
extends PBoxSEGeneral
implements SETable {
    public static final String TABLE_STRUCTURE_ELEMENT_TYPE = "SETable";

    public PBoxSETable(COSDictionary structElemDictionary, TaggedPDFRoleMapHelper roleMapHelper) {
        super(structElemDictionary, roleMapHelper, "Table", TABLE_STRUCTURE_ELEMENT_TYPE);
    }

    @Override
    public Boolean getuseHeadersAndIdOrScope() {
        Stack<PDStructElem> stack = new Stack<PDStructElem>();
        boolean hasScope = true;
        boolean hasID = true;
        boolean hasHeaders = true;
        HashSet<String> idSet = new HashSet<String>();
        HashSet<Object> headersSet = new HashSet<Object>();
        stack.push(this);
        while (!stack.empty()) {
            List<Object> list;
            PDStructElem elem = (PDStructElem)stack.pop();
            String string = elem.getstandardType();
            if ("TD".equals(string)) {
                list = ((PBoxSETD)elem).getHeaders();
                if (list != null && !list.isEmpty()) {
                    headersSet.addAll(list);
                } else {
                    hasHeaders = false;
                }
            } else if ("TH".equals(string)) {
                String id = ((PBoxSETH)elem).getTHID();
                if (id == null || id.isEmpty()) {
                    hasID = false;
                } else {
                    idSet.add(id);
                }
                if (((PBoxSETH)elem).getScope() == null) {
                    hasScope = false;
                }
            }
            list = ((PBoxPDStructElem)elem).getChildren();
            for (PDStructElem pDStructElem : list) {
                stack.push(pDStructElem);
            }
        }
        if (hasScope) {
            return true;
        }
        if (!hasID || !hasHeaders) {
            return false;
        }
        for (String string : headersSet) {
            if (idSet.contains(string)) continue;
            return false;
        }
        return true;
    }

    public Boolean getisRegular() {
        int j;
        int i;
        List<PDStructElem> listTR = this.getTR();
        int rowNum = listTR.size();
        int columnNum = this.getColumnNum((PBoxPDStructElem)listTR.get(0));
        boolean[][] cells = new boolean[rowNum][columnNum];
        for (i = 0; i < rowNum; ++i) {
            j = 0;
            for (PDStructElem elem : ((PBoxPDStructElem)listTR.get(i)).getChildren()) {
                long rowSpan;
                long colSpan;
                String type = elem.getstandardType();
                if ("TH".equals(type)) {
                    colSpan = ((PBoxSETH)elem).getColSpan();
                    rowSpan = ((PBoxSETH)elem).getRowSpan();
                } else {
                    if (!"TD".equals(type)) continue;
                    colSpan = ((PBoxSETD)elem).getColSpan();
                    rowSpan = ((PBoxSETD)elem).getRowSpan();
                }
                while (j < columnNum && cells[i][j]) {
                    ++j;
                }
                if (j >= columnNum) {
                    return false;
                }
                if ((long)i + rowSpan > (long)rowNum || (long)j + colSpan > (long)columnNum) {
                    return false;
                }
                if (!this.checkRegular(cells, rowSpan, colSpan, i, j).booleanValue()) {
                    return false;
                }
                j = (int)((long)j + colSpan);
            }
        }
        for (i = 0; i < rowNum; ++i) {
            for (j = 0; j < columnNum; ++j) {
                if (cells[i][j]) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public Long getcolumnSpan() {
        return null;
    }

    @Override
    public Long getrowSpan() {
        return null;
    }

    @Override
    public Long getnumberOfRowWithWrongColumnSpan() {
        return null;
    }

    @Override
    public Long getnumberOfColumnWithWrongRowSpan() {
        return null;
    }

    @Override
    public Long getwrongColumnSpan() {
        return null;
    }

    private List<PDStructElem> getTR() {
        LinkedList<PDStructElem> listTR = new LinkedList<PDStructElem>();
        for (PDStructElem elem : this.getChildren()) {
            String type = elem.getstandardType();
            if ((this.addTRtoList(listTR, elem) || !"THead".equals(type)) && !"TBody".equals(type) && !"TFoot".equals(type)) continue;
            for (PDStructElem child : ((PBoxPDStructElem)elem).getChildren()) {
                this.addTRtoList(listTR, child);
            }
        }
        return listTR;
    }

    private boolean addTRtoList(List<PDStructElem> listTR, PDStructElem elem) {
        if ("TR".equals(elem.getstandardType())) {
            listTR.add(elem);
            return true;
        }
        return false;
    }

    private int getColumnNum(PBoxPDStructElem firstTR) {
        int columnNum = 0;
        for (PDStructElem elem : firstTR.getChildren()) {
            String type = elem.getstandardType();
            if ("TH".equals(type)) {
                columnNum = (int)((long)columnNum + ((PBoxSETH)elem).getColSpan());
            }
            if (!"TD".equals(type)) continue;
            columnNum = (int)((long)columnNum + ((PBoxSETD)elem).getColSpan());
        }
        return columnNum;
    }

    private Boolean checkRegular(boolean[][] cells, long rowSpan, long colSpan, int i, int j) {
        int k = 0;
        while ((long)k < rowSpan) {
            int l = 0;
            while ((long)l < colSpan) {
                if (cells[i + k][j + l]) {
                    return false;
                }
                cells[i + k][j + l] = true;
                ++l;
            }
            ++k;
        }
        return true;
    }
}

