/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.model.tools;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSObject;
import org.verapdf.model.impl.pb.pd.PBoxPDStructElem;
import org.verapdf.model.impl.pb.pd.pboxse.PBoxSEGeneral;
import org.verapdf.model.pdlayer.PDStructElem;
import org.verapdf.model.tools.TaggedPDFRoleMapHelper;

public class TaggedPDFHelper {
    private static final int MAX_NUMBER_OF_ELEMENTS = 1;

    private TaggedPDFHelper() {
    }

    public static List<PDStructElem> getStructTreeRootChildren(COSDictionary parent, TaggedPDFRoleMapHelper roleMapHelper) {
        return TaggedPDFHelper.getChildren(parent, roleMapHelper, false);
    }

    public static List<PDStructElem> getStructElemChildren(COSDictionary parent, TaggedPDFRoleMapHelper roleMapHelper) {
        return TaggedPDFHelper.getChildren(parent, roleMapHelper, true);
    }

    public static List<String> getStructElemChildrenStandardTypes(COSDictionary parent, TaggedPDFRoleMapHelper roleMapHelper) {
        return TaggedPDFHelper.getChildrenStandardTypes(parent, roleMapHelper, true);
    }

    private static List<PDStructElem> getChildren(COSDictionary parent, TaggedPDFRoleMapHelper roleMapHelper, boolean checkType) {
        COSBase children = parent.getDictionaryObject(COSName.K);
        if (children != null) {
            if (children instanceof COSDictionary && TaggedPDFHelper.isStructElem((COSDictionary)children, checkType)) {
                ArrayList<PBoxSEGeneral> list = new ArrayList<PBoxSEGeneral>(1);
                list.add(PBoxSEGeneral.createTypedStructElem((COSDictionary)children, roleMapHelper));
                return Collections.unmodifiableList(list);
            }
            if (children instanceof COSArray) {
                return TaggedPDFHelper.getChildrenFromArray((COSArray)children, roleMapHelper, checkType);
            }
        }
        return Collections.emptyList();
    }

    private static List<String> getChildrenStandardTypes(COSDictionary parent, TaggedPDFRoleMapHelper roleMapHelper, boolean checkType) {
        COSBase children = parent.getDictionaryObject(COSName.K);
        if (children != null) {
            if (children instanceof COSDictionary && TaggedPDFHelper.isStructElem((COSDictionary)children, checkType)) {
                ArrayList<String> list = new ArrayList<String>(1);
                list.add(PBoxPDStructElem.getStructureElementStandardType((COSDictionary)children, roleMapHelper));
                return Collections.unmodifiableList(list);
            }
            if (children instanceof COSArray) {
                return TaggedPDFHelper.getChildrenStandardTypesFromArray((COSArray)children, roleMapHelper, checkType);
            }
        }
        return Collections.emptyList();
    }

    private static List<PDStructElem> getChildrenFromArray(COSArray children, TaggedPDFRoleMapHelper roleMapHelper, boolean checkType) {
        if (children.size() > 0) {
            ArrayList<PBoxSEGeneral> list = new ArrayList<PBoxSEGeneral>();
            for (COSBase element : children) {
                COSBase directElem = element;
                if (directElem instanceof COSObject) {
                    directElem = ((COSObject)directElem).getObject();
                }
                if (!(directElem instanceof COSDictionary) || !TaggedPDFHelper.isStructElem((COSDictionary)directElem, checkType)) continue;
                list.add(PBoxSEGeneral.createTypedStructElem((COSDictionary)directElem, roleMapHelper));
            }
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private static List<String> getChildrenStandardTypesFromArray(COSArray children, TaggedPDFRoleMapHelper roleMapHelper, boolean checkType) {
        if (children.size() > 0) {
            ArrayList<String> list = new ArrayList<String>();
            for (COSBase element : children) {
                COSBase directElem = element;
                if (directElem instanceof COSObject) {
                    directElem = ((COSObject)directElem).getObject();
                }
                if (!(directElem instanceof COSDictionary) || !TaggedPDFHelper.isStructElem((COSDictionary)directElem, checkType)) continue;
                list.add(PBoxPDStructElem.getStructureElementStandardType((COSDictionary)directElem, roleMapHelper));
            }
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private static boolean isStructElem(COSDictionary dictionary, boolean checkType) {
        if (dictionary == null) {
            return false;
        }
        COSName type = dictionary.getCOSName(COSName.TYPE);
        return !checkType || type == null || type.equals(COSName.getPDFName("StructElem"));
    }
}

