/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fontbox.ttf;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.fontbox.ttf.MemoryTTFDataStream;
import org.apache.fontbox.ttf.OTFParser;
import org.apache.fontbox.ttf.OpenTypeFont;
import org.apache.fontbox.ttf.RAFDataStream;
import org.apache.fontbox.ttf.TTCDataStream;
import org.apache.fontbox.ttf.TTFDataStream;
import org.apache.fontbox.ttf.TTFParser;
import org.apache.fontbox.ttf.TrueTypeFont;

public class TrueTypeCollection
implements Closeable {
    private final TTFDataStream stream;
    private final List<TrueTypeFont> fonts;

    public TrueTypeCollection(File file) throws IOException {
        this(new RAFDataStream(file, "r"));
    }

    public TrueTypeCollection(InputStream stream) throws IOException {
        this(new MemoryTTFDataStream(stream));
    }

    TrueTypeCollection(TTFDataStream stream) throws IOException {
        this.stream = stream;
        String tag = stream.readTag();
        if (!tag.equals("ttcf")) {
            throw new IOException("Missing TTC header");
        }
        float version = stream.read32Fixed();
        int numFonts = (int)stream.readUnsignedInt();
        long[] fontOffsets = new long[numFonts];
        for (int i = 0; i < numFonts; ++i) {
            fontOffsets[i] = stream.readUnsignedInt();
        }
        if (version >= 2.0f) {
            int ulDsigTag = stream.readUnsignedShort();
            int ulDsigLength = stream.readUnsignedShort();
            int n = stream.readUnsignedShort();
        }
        ArrayList<TrueTypeFont> fonts = new ArrayList<TrueTypeFont>();
        for (int i = 0; i < numFonts; ++i) {
            TTFParser parser;
            stream.seek(fontOffsets[i]);
            if (stream.readTag().equals("OTTO")) {
                stream.seek(fontOffsets[i]);
                parser = new OTFParser(false, true);
                OpenTypeFont otf = ((OTFParser)parser).parse(new TTCDataStream(stream));
                fonts.add(otf);
                continue;
            }
            stream.seek(fontOffsets[i]);
            parser = new TTFParser(false, true);
            TrueTypeFont ttf = parser.parse(new TTCDataStream(stream));
            fonts.add(ttf);
        }
        this.fonts = Collections.unmodifiableList(fonts);
    }

    public List<TrueTypeFont> getFonts() {
        return this.fonts;
    }

    @Override
    public void close() throws IOException {
        this.stream.close();
    }
}

