/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.io;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.pdfbox.io.RandomAccessRead;

public class SequenceRandomAccessRead
implements RandomAccessRead {
    private boolean isClosed;
    private final List<? extends RandomAccessRead> source;
    private final List<Long> sourceLength;
    private final long bufferLength;
    private RandomAccessRead currentBuffer;
    private long currentPosition;
    private long currentBufferPosition;
    private long currentBufferLength;
    private int currentIndex;
    private int maxIndex;

    public SequenceRandomAccessRead(List<? extends RandomAccessRead> list) throws IOException {
        this.source = list;
        this.maxIndex = list.size() - 1;
        this.sourceLength = new ArrayList<Long>(this.maxIndex);
        long sumLength = 0L;
        for (RandomAccessRead randomAccessRead : list) {
            long inputLength = randomAccessRead.length();
            randomAccessRead.seek(0L);
            this.sourceLength.add(inputLength);
            sumLength += inputLength;
        }
        this.bufferLength = sumLength;
        this.currentBuffer = this.source.get(0);
        this.currentBufferLength = this.sourceLength.get(0);
        this.currentBufferPosition = 0L;
        this.currentPosition = 0L;
        this.currentIndex = 0;
    }

    private void checkClosed() throws IOException {
        if (this.isClosed) {
            throw new IOException("RandomAccessFile already closed");
        }
    }

    private boolean nextBuffer() throws IOException {
        if (this.currentIndex < this.maxIndex) {
            this.switchBuffer(this.currentIndex + 1);
            if (this.currentBufferLength == 0L) {
                return this.nextBuffer();
            }
            return true;
        }
        return false;
    }

    private void switchBuffer(int index) throws IOException {
        this.currentIndex = index;
        this.currentBuffer = this.source.get(index);
        this.currentBufferPosition = 0L;
        this.currentBufferLength = this.sourceLength.get(index);
        this.currentBuffer.seek(this.currentBufferPosition);
    }

    @Override
    public long getPosition() throws IOException {
        this.checkClosed();
        return this.currentPosition;
    }

    @Override
    public void seek(long newPosition) throws IOException {
        this.checkClosed();
        if (newPosition >= this.bufferLength) {
            this.switchBuffer(this.maxIndex);
            this.currentBufferPosition = this.sourceLength.get(this.currentIndex);
            this.currentPosition = newPosition;
            this.currentBuffer.seek(this.currentBufferPosition);
        } else {
            int index = 0;
            for (long position = this.sourceLength.get(index).longValue(); newPosition >= position; position += this.sourceLength.get(++index).longValue()) {
            }
            if (this.currentIndex != index) {
                this.switchBuffer(index);
                long startPostion = 0L;
                for (int i = 0; i < index; ++i) {
                    startPostion += this.sourceLength.get(i).longValue();
                }
                this.currentBufferPosition = newPosition - startPostion;
            } else {
                this.currentBufferPosition += newPosition - this.currentPosition;
            }
            this.currentBuffer.seek(this.currentBufferPosition);
            this.currentPosition = newPosition;
        }
    }

    @Override
    public int read() throws IOException {
        this.checkClosed();
        int returnValue = -1;
        if (this.currentPosition < this.bufferLength) {
            if (this.currentBufferPosition < this.currentBufferLength) {
                returnValue = this.currentBuffer.read();
                ++this.currentPosition;
                ++this.currentBufferPosition;
            } else if (this.nextBuffer()) {
                returnValue = this.currentBuffer.read();
                ++this.currentPosition;
                ++this.currentBufferPosition;
            }
        }
        return returnValue;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int bytesReadTotal;
        this.checkClosed();
        int bytesRead = bytesReadTotal = this.readBytes(b, off, len);
        while (bytesReadTotal < len && bytesRead > 0) {
            bytesRead = this.read(b, off + bytesRead, len - bytesRead);
            bytesReadTotal += bytesRead;
        }
        return bytesReadTotal;
    }

    private int readBytes(byte[] b, int off, int len) throws IOException {
        if (this.currentBufferPosition == this.currentBufferLength) {
            this.nextBuffer();
        }
        int bytesRead = this.currentBuffer.read(b, off, len);
        this.currentBufferPosition += (long)bytesRead;
        this.currentPosition += (long)bytesRead;
        return bytesRead;
    }

    @Override
    public int available() throws IOException {
        return (int)Math.min(this.bufferLength - this.getPosition(), Integer.MAX_VALUE);
    }

    @Override
    public long length() throws IOException {
        return this.bufferLength;
    }

    @Override
    public void close() throws IOException {
        this.isClosed = true;
        this.currentBuffer = null;
        this.source.clear();
    }

    @Override
    public boolean isClosed() {
        return this.isClosed || this.source == null;
    }

    @Override
    public int peek() throws IOException {
        int result = this.read();
        if (result != -1) {
            this.rewind(1);
        }
        return result;
    }

    @Override
    public void rewind(int bytes) throws IOException {
        this.seek(this.getPosition() - (long)bytes);
    }

    @Override
    public byte[] readFully(int length) throws IOException {
        byte[] b = new byte[length];
        for (int bytesRead = this.read(b); bytesRead < length; bytesRead += this.read(b, bytesRead, length - bytesRead)) {
        }
        return b;
    }

    @Override
    public boolean isEOF() throws IOException {
        return this.peek() == -1;
    }
}

