/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.model.impl.pb.cos;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.verapdf.model.baselayer.Object;
import org.verapdf.model.coslayer.CosInfo;
import org.verapdf.model.coslayer.CosTrailer;
import org.verapdf.model.impl.pb.cos.PBCosDict;
import org.verapdf.model.impl.pb.cos.PBCosInfo;
import org.verapdf.model.impl.pb.pd.PBoxPDEncryption;
import org.verapdf.model.pdlayer.PDEncryption;
import org.verapdf.pdfa.flavours.PDFAFlavour;

public class PBCosTrailer
extends PBCosDict
implements CosTrailer {
    public static final String COS_TRAILER_TYPE = "CosTrailer";
    public static final String CATALOG = "Catalog";
    public static final String ENCRYPT = "Encrypt";
    public static final String INFO = "Info";
    private final boolean isEncrypted;

    public PBCosTrailer(COSDictionary dictionary, PDDocument document, PDFAFlavour flavour) {
        super(dictionary, COS_TRAILER_TYPE, document, flavour);
        this.isEncrypted = dictionary.getItem(COSName.ENCRYPT) != null;
    }

    @Override
    public Boolean getisEncrypted() {
        return this.isEncrypted;
    }

    @Override
    public List<? extends Object> getLinkedObjects(String link) {
        switch (link) {
            case "Encrypt": {
                return this.getEncrypt();
            }
            case "Info": {
                return this.getInfo();
            }
        }
        return super.getLinkedObjects(link);
    }

    private List<PDEncryption> getEncrypt() {
        COSBase base = ((COSDictionary)this.baseObject).getDictionaryObject(COSName.ENCRYPT);
        if (base != null && base instanceof COSDictionary) {
            ArrayList<PBoxPDEncryption> list = new ArrayList<PBoxPDEncryption>(1);
            list.add(new PBoxPDEncryption((COSDictionary)base));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<CosInfo> getInfo() {
        COSBase base = ((COSDictionary)this.baseObject).getDictionaryObject(COSName.INFO);
        if (base != null && base instanceof COSDictionary) {
            ArrayList<PBCosInfo> list = new ArrayList<PBCosInfo>(1);
            list.add(new PBCosInfo((COSDictionary)base, this.document, this.flavour));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }
}

