/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.model.impl.pb.pd.font;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.fontbox.cmap.CMap;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.font.PDCIDFont;
import org.apache.pdfbox.pdmodel.font.PDCIDSystemInfo;
import org.apache.pdfbox.pdmodel.font.PDFontLike;
import org.apache.pdfbox.pdmodel.graphics.state.RenderingMode;
import org.verapdf.model.impl.pb.pd.font.PBoxPDCIDFont;
import org.verapdf.model.impl.pb.pd.font.PBoxPDCMap;
import org.verapdf.model.impl.pb.pd.font.PBoxPDFont;
import org.verapdf.model.pdlayer.PDCMap;
import org.verapdf.model.pdlayer.PDType0Font;
import org.verapdf.pdfa.flavours.PDFAFlavour;

public class PBoxPDType0Font
extends PBoxPDFont
implements PDType0Font {
    public static final String TYPE_0_FONT_TYPE = "PDType0Font";
    public static final String DESCENDANT_FONTS = "DescendantFonts";
    public static final String ENCODING = "Encoding";
    private final PDDocument document;
    private final PDFAFlavour flavour;

    public PBoxPDType0Font(PDFontLike font, RenderingMode renderingMode, PDDocument document, PDFAFlavour flavour) {
        super(font, renderingMode, TYPE_0_FONT_TYPE);
        this.document = document;
        this.flavour = flavour;
    }

    @Override
    public String getCIDFontOrdering() {
        PDCIDFont descendantFont = ((org.apache.pdfbox.pdmodel.font.PDType0Font)this.pdFontLike).getDescendantFont();
        if (descendantFont != null) {
            PDCIDSystemInfo cidSystemInfo = descendantFont.getCIDSystemInfo();
            return cidSystemInfo != null ? cidSystemInfo.getOrdering() : null;
        }
        return null;
    }

    @Override
    public String getCMapOrdering() {
        CMap cMap = ((org.apache.pdfbox.pdmodel.font.PDType0Font)this.pdFontLike).getCMap();
        return cMap != null ? cMap.getOrdering() : null;
    }

    @Override
    public String getCIDFontRegistry() {
        PDCIDFont descendantFont = ((org.apache.pdfbox.pdmodel.font.PDType0Font)this.pdFontLike).getDescendantFont();
        if (descendantFont != null) {
            PDCIDSystemInfo cidSystemInfo = descendantFont.getCIDSystemInfo();
            return cidSystemInfo != null ? cidSystemInfo.getRegistry() : null;
        }
        return null;
    }

    @Override
    public String getCMapRegistry() {
        CMap cMap = ((org.apache.pdfbox.pdmodel.font.PDType0Font)this.pdFontLike).getCMap();
        return cMap != null ? cMap.getRegistry() : null;
    }

    @Override
    public Long getCIDFontSupplement() {
        PDCIDFont descendantFont = ((org.apache.pdfbox.pdmodel.font.PDType0Font)this.pdFontLike).getDescendantFont();
        if (descendantFont != null) {
            PDCIDSystemInfo cidSystemInfo = descendantFont.getCIDSystemInfo();
            return cidSystemInfo != null ? Long.valueOf(cidSystemInfo.getSupplement()) : null;
        }
        return null;
    }

    @Override
    public Long getCMapSupplement() {
        CMap cMap = ((org.apache.pdfbox.pdmodel.font.PDType0Font)this.pdFontLike).getCMap();
        return cMap != null ? Long.valueOf(cMap.getSupplement()) : null;
    }

    @Override
    public String getcmapName() {
        CMap cMap = ((org.apache.pdfbox.pdmodel.font.PDType0Font)this.pdFontLike).getCMap();
        return cMap != null ? cMap.getName() : null;
    }

    @Override
    public List<? extends org.verapdf.model.baselayer.Object> getLinkedObjects(String link) {
        switch (link) {
            case "DescendantFonts": {
                return this.getDescendantFonts();
            }
            case "Encoding": {
                return this.getEncoding();
            }
        }
        return super.getLinkedObjects(link);
    }

    private List<org.verapdf.model.pdlayer.PDCIDFont> getDescendantFonts() {
        PDCIDFont pdcidFont = ((org.apache.pdfbox.pdmodel.font.PDType0Font)this.pdFontLike).getDescendantFont();
        if (pdcidFont != null) {
            ArrayList<PBoxPDCIDFont> list = new ArrayList<PBoxPDCIDFont>(1);
            list.add(new PBoxPDCIDFont(pdcidFont, this.renderingMode, this.document, this.flavour));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<PDCMap> getEncoding() {
        CMap charMap = ((org.apache.pdfbox.pdmodel.font.PDType0Font)this.pdFontLike).getCMap();
        if (charMap != null) {
            COSDictionary cosDictionary = ((org.apache.pdfbox.pdmodel.font.PDType0Font)this.pdFontLike).getCOSObject();
            COSBase cmap = cosDictionary.getDictionaryObject(COSName.ENCODING);
            ArrayList<PBoxPDCMap> list = new ArrayList<PBoxPDCMap>(1);
            boolean isCMapCorrect = cmap != null && cmap instanceof COSStream;
            list.add(isCMapCorrect ? new PBoxPDCMap(charMap, (COSStream)cmap) : new PBoxPDCMap(charMap, null));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }
}

