/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.processor.reports;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import org.verapdf.pdfa.flavours.PDFAFlavour;
import org.verapdf.pdfa.results.TestAssertion;
import org.verapdf.pdfa.validation.profiles.Profiles;
import org.verapdf.pdfa.validation.profiles.RuleId;
import org.verapdf.processor.reports.Check;
import org.verapdf.processor.reports.CheckImpl;
import org.verapdf.processor.reports.RuleSummary;

final class RuleSummaryImpl
implements RuleSummary {
    private final TestAssertion.Status ruleStatus;
    @XmlAttribute
    private final String specification;
    @XmlAttribute
    private final String clause;
    @XmlAttribute
    private final int testNumber;
    @XmlAttribute
    private final String status;
    @XmlAttribute
    private final int passedChecks;
    @XmlAttribute
    private final int failedChecks;
    @XmlAttribute
    private final String tags;
    @XmlElement
    private final String description;
    @XmlElement
    private final String object;
    @XmlElement
    private final String test;
    @XmlElement(name="check")
    private final List<Check> checks;

    private RuleSummaryImpl(RuleId ruleId, TestAssertion.Status status, int passedChecks, int failedChecks, String tags, String description, String object, String test, List<Check> checks) {
        PDFAFlavour.Specification specification = ruleId.getSpecification();
        this.specification = specification == null ? null : specification.getId();
        this.clause = ruleId.getClause();
        this.testNumber = ruleId.getTestNumber();
        this.ruleStatus = status;
        this.status = status.toString();
        this.passedChecks = passedChecks;
        this.failedChecks = failedChecks;
        this.tags = tags;
        this.description = description;
        this.object = object;
        this.test = test;
        this.checks = checks != null && !checks.isEmpty() ? new ArrayList<Check>(checks) : null;
    }

    private RuleSummaryImpl(RuleId ruleId, TestAssertion.Status status, String description, String object, String test, String tags) {
        this(ruleId, status, 0, 0, tags, description, object, test, Collections.emptyList());
    }

    private RuleSummaryImpl() {
        this(Profiles.defaultRuleId(), TestAssertion.Status.UNKNOWN, "", "", "", null);
    }

    @Override
    public String getStatus() {
        return this.status;
    }

    @Override
    public TestAssertion.Status getRuleStatus() {
        return this.ruleStatus;
    }

    @Override
    public String getSpecification() {
        return this.specification;
    }

    @Override
    public String getClause() {
        return this.clause;
    }

    @Override
    public int getTestNumber() {
        return this.testNumber;
    }

    @Override
    public int getPassedChecks() {
        return this.passedChecks;
    }

    @Override
    public int getFailedChecks() {
        return this.failedChecks;
    }

    @Override
    public String getTags() {
        return this.tags;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getObject() {
        return this.object;
    }

    @Override
    public String getTest() {
        return this.test;
    }

    @Override
    public List<Check> getChecks() {
        return this.checks;
    }

    static final RuleSummary fromValues(RuleId id, String description, String object, String test, List<TestAssertion> assertions, boolean logPassedChecks, Integer failedChecks, String tags) {
        if (id == null) {
            throw new NullPointerException("Argument id can not be null");
        }
        if (description == null) {
            throw new NullPointerException("Argument description can not be null");
        }
        if (assertions == null) {
            throw new NullPointerException("Argument assertions can not be null");
        }
        ArrayList<Check> checks = new ArrayList<Check>();
        TestAssertion.Status status = TestAssertion.Status.PASSED;
        int passedChecks = 0;
        for (TestAssertion assertion : assertions) {
            if (assertion.getStatus() == TestAssertion.Status.PASSED) {
                ++passedChecks;
                if (!logPassedChecks) continue;
                checks.add(CheckImpl.fromValue(assertion));
                continue;
            }
            status = assertion.getStatus();
            checks.add(CheckImpl.fromValue(assertion));
        }
        return new RuleSummaryImpl(id, status, passedChecks, failedChecks != null ? failedChecks : 0, tags, description, object, test, checks);
    }

    static final RuleSummary uncheckedInstance(RuleId id, String description, String object, String test, String tags) {
        if (id == null) {
            throw new NullPointerException("Argument id can not be null");
        }
        if (description == null) {
            throw new NullPointerException("Argument description can not be null");
        }
        return new RuleSummaryImpl(id, TestAssertion.Status.PASSED, description, object, test, tags);
    }

    static class Adapter
    extends XmlAdapter<RuleSummaryImpl, RuleSummary> {
        Adapter() {
        }

        public RuleSummary unmarshal(RuleSummaryImpl summary) {
            return summary;
        }

        public RuleSummaryImpl marshal(RuleSummary summary) {
            return (RuleSummaryImpl)summary;
        }
    }
}

