/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.report;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.DatatypeConverter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.verapdf.features.tools.FeatureTreeNode;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XmpHandler {
    private static final Logger LOGGER = Logger.getLogger(XmpHandler.class.getCanonicalName());
    private static final byte[] UTF8_METADATA_PREFIX_SQ = new byte[]{60, 63, 120, 112, 97, 99, 107, 101, 116, 32, 98, 101, 103, 105, 110, 61, 39, -17, -69, -65, 39};
    private static final byte[] UTF8_METADATA_PREFIX_DQ = new byte[]{60, 63, 120, 112, 97, 99, 107, 101, 116, 32, 98, 101, 103, 105, 110, 61, 34, -17, -69, -65, 34};
    private static final byte[] UTF8_METADATA_PREFIX_SQ_EMPTY = new byte[]{60, 63, 120, 112, 97, 99, 107, 101, 116, 32, 98, 101, 103, 105, 110, 61, 39, 39};
    private static final byte[] UTF8_METADATA_PREFIX_DQ_EMPTY = new byte[]{60, 63, 120, 112, 97, 99, 107, 101, 116, 32, 98, 101, 103, 105, 110, 61, 34, 34};
    private static final byte[] UTF16BE_METADATA_PREFIX_SQ = new byte[]{0, 60, 0, 63, 0, 120, 0, 112, 0, 97, 0, 99, 0, 107, 0, 101, 0, 116, 0, 32, 0, 98, 0, 101, 0, 103, 0, 105, 0, 110, 0, 61, 0, 39, -2, -1, 0, 39};
    private static final byte[] UTF16BE_METADATA_PREFIX_DQ = new byte[]{0, 60, 0, 63, 0, 120, 0, 112, 0, 97, 0, 99, 0, 107, 0, 101, 0, 116, 0, 32, 0, 98, 0, 101, 0, 103, 0, 105, 0, 110, 0, 61, 0, 34, -2, -1, 0, 34};
    private static final byte[] UTF16LE_METADATA_PREFIX_SQ = new byte[]{60, 0, 63, 0, 120, 0, 112, 0, 97, 0, 99, 0, 107, 0, 101, 0, 116, 0, 32, 0, 98, 0, 101, 0, 103, 0, 105, 0, 110, 0, 61, 0, 39, 0, -1, -2, 39, 0};
    private static final byte[] UTF16LE_METADATA_PREFIX_DQ = new byte[]{60, 0, 63, 0, 120, 0, 112, 0, 97, 0, 99, 0, 107, 0, 101, 0, 116, 0, 32, 0, 98, 0, 101, 0, 103, 0, 105, 0, 110, 0, 61, 0, 34, 0, -1, -2, 34, 0};
    private static final byte[] UTF32BE_METADATA_PREFIX_SQ = new byte[]{0, 0, 0, 60, 0, 0, 0, 63, 0, 0, 0, 120, 0, 0, 0, 112, 0, 0, 0, 97, 0, 0, 0, 99, 0, 0, 0, 107, 0, 0, 0, 101, 0, 0, 0, 116, 0, 0, 0, 32, 0, 0, 0, 98, 0, 0, 0, 101, 0, 0, 0, 103, 0, 0, 0, 105, 0, 0, 0, 110, 0, 0, 0, 61, 0, 0, 0, 39, 0, 0, -2, -1, 0, 0, 0, 39};
    private static final byte[] UTF32BE_METADATA_PREFIX_DQ = new byte[]{0, 0, 0, 60, 0, 0, 0, 63, 0, 0, 0, 120, 0, 0, 0, 112, 0, 0, 0, 97, 0, 0, 0, 99, 0, 0, 0, 107, 0, 0, 0, 101, 0, 0, 0, 116, 0, 0, 0, 32, 0, 0, 0, 98, 0, 0, 0, 101, 0, 0, 0, 103, 0, 0, 0, 105, 0, 0, 0, 110, 0, 0, 0, 61, 0, 0, 0, 34, 0, 0, -2, -1, 0, 0, 0, 34};
    private static final byte[] UTF32LE_METADATA_PREFIX_SQ = new byte[]{60, 0, 0, 0, 63, 0, 0, 0, 120, 0, 0, 0, 112, 0, 0, 0, 97, 0, 0, 0, 99, 0, 0, 0, 107, 0, 0, 0, 101, 0, 0, 0, 116, 0, 0, 0, 32, 0, 0, 0, 98, 0, 0, 0, 101, 0, 0, 0, 103, 0, 0, 0, 105, 0, 0, 0, 110, 0, 0, 0, 61, 0, 0, 0, 39, 0, 0, 0, -1, -2, 0, 0, 39, 0, 0, 0};
    private static final byte[] UTF32LE_METADATA_PREFIX_DQ = new byte[]{60, 0, 0, 0, 63, 0, 0, 0, 120, 0, 0, 0, 112, 0, 0, 0, 97, 0, 0, 0, 99, 0, 0, 0, 107, 0, 0, 0, 101, 0, 0, 0, 116, 0, 0, 0, 32, 0, 0, 0, 98, 0, 0, 0, 101, 0, 0, 0, 103, 0, 0, 0, 105, 0, 0, 0, 110, 0, 0, 0, 61, 0, 0, 0, 34, 0, 0, 0, -1, -2, 0, 0, 34, 0, 0, 0};

    private XmpHandler() {
    }

    public static Node parseMetadataRootElement(FeatureTreeNode metadataNode) throws SAXException, IOException, ParserConfigurationException {
        InputSource is = XmpHandler.getInputSourceWithEncoding(DatatypeConverter.parseHexBinary((String)metadataNode.getValue()));
        if (is == null) {
            return null;
        }
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Unable to secure metadata processing");
        }
        factory.setNamespaceAware(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document metadataDocument = builder.parse(is);
        return metadataDocument.getDocumentElement();
    }

    private static InputSource getInputSourceWithEncoding(byte[] array) {
        if (array != null) {
            for (int i = 0; i < array.length; ++i) {
                String encoding = XmpHandler.getEncodingWithBegin(array, i);
                if (encoding == null) continue;
                ByteArrayInputStream is = new ByteArrayInputStream(Arrays.copyOfRange(array, i, array.length));
                InputSource source = new InputSource(is);
                source.setEncoding(encoding);
                return source;
            }
        }
        return null;
    }

    private static String getEncodingWithBegin(byte[] bStream, int beginOffset) {
        if (beginOffset >= 0) {
            if (XmpHandler.matchesFrom(bStream, beginOffset, UTF32BE_METADATA_PREFIX_DQ) || XmpHandler.matchesFrom(bStream, beginOffset, UTF32BE_METADATA_PREFIX_SQ)) {
                return "UTF-32BE";
            }
            if (XmpHandler.matchesFrom(bStream, beginOffset, UTF32LE_METADATA_PREFIX_DQ) || XmpHandler.matchesFrom(bStream, beginOffset, UTF32LE_METADATA_PREFIX_SQ)) {
                return "UTF-32LE";
            }
            if (XmpHandler.matchesFrom(bStream, beginOffset, UTF16BE_METADATA_PREFIX_DQ) || XmpHandler.matchesFrom(bStream, beginOffset, UTF16BE_METADATA_PREFIX_SQ)) {
                return "UTF-16BE";
            }
            if (XmpHandler.matchesFrom(bStream, beginOffset, UTF16LE_METADATA_PREFIX_DQ) || XmpHandler.matchesFrom(bStream, beginOffset, UTF16LE_METADATA_PREFIX_SQ)) {
                return "UTF-16LE";
            }
            if (XmpHandler.matchesFrom(bStream, beginOffset, UTF8_METADATA_PREFIX_DQ) || XmpHandler.matchesFrom(bStream, beginOffset, UTF8_METADATA_PREFIX_DQ_EMPTY) || XmpHandler.matchesFrom(bStream, beginOffset, UTF8_METADATA_PREFIX_SQ) || XmpHandler.matchesFrom(bStream, beginOffset, UTF8_METADATA_PREFIX_SQ_EMPTY)) {
                return "UTF-8";
            }
        }
        return null;
    }

    private static boolean matchesFrom(byte[] source, int from, byte[] match) {
        if (match.length > source.length - from) {
            return false;
        }
        for (int i = 0; i < match.length; ++i) {
            if (source[i + from] == match[i]) continue;
            return false;
        }
        return true;
    }
}

