/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.pdfa.results;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import org.verapdf.pdfa.results.MetadataFixerResult;

@XmlRootElement(name="fixerResult")
public final class MetadataFixerResultImpl
implements MetadataFixerResult {
    @XmlAttribute
    private final MetadataFixerResult.RepairStatus status;
    @XmlElementWrapper
    @XmlElement(name="fix")
    private final List<String> appliedFixes;

    private MetadataFixerResultImpl() {
        this(MetadataFixerResult.RepairStatus.NO_ACTION, new ArrayList<String>());
    }

    private MetadataFixerResultImpl(MetadataFixerResult.RepairStatus status, List<String> fixes) {
        this.status = status;
        this.appliedFixes = new ArrayList<String>(fixes);
    }

    @Override
    public MetadataFixerResult.RepairStatus getRepairStatus() {
        return this.status;
    }

    @Override
    public List<String> getAppliedFixes() {
        return Collections.unmodifiableList(this.appliedFixes);
    }

    @Override
    public Iterator<String> iterator() {
        return this.appliedFixes.iterator();
    }

    public static MetadataFixerResult fromValues(MetadataFixerResult.RepairStatus status, List<String> fixes) {
        return new MetadataFixerResultImpl(status, fixes);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MetadataFixerResultImpl)) {
            return false;
        }
        MetadataFixerResultImpl strings = (MetadataFixerResultImpl)o;
        if (this.status != strings.status) {
            return false;
        }
        return Objects.equals(this.appliedFixes, strings.appliedFixes);
    }

    public int hashCode() {
        int result = this.status != null ? this.status.hashCode() : 0;
        result = 31 * result + (this.appliedFixes != null ? this.appliedFixes.hashCode() : 0);
        return result;
    }

    static class Adapter
    extends XmlAdapter<MetadataFixerResultImpl, MetadataFixerResult> {
        Adapter() {
        }

        public MetadataFixerResult unmarshal(MetadataFixerResultImpl mdfResult) {
            return mdfResult;
        }

        public MetadataFixerResultImpl marshal(MetadataFixerResult procResult) {
            return (MetadataFixerResultImpl)procResult;
        }
    }

    public static class Builder {
        private MetadataFixerResult.RepairStatus status = MetadataFixerResult.RepairStatus.NO_ACTION;
        private final List<String> fixes = new ArrayList<String>();

        public Builder status(MetadataFixerResult.RepairStatus status) {
            this.status = status;
            return this;
        }

        public MetadataFixerResult.RepairStatus getStatus() {
            return this.status;
        }

        public Builder addFix(String fix) {
            this.fixes.add(fix);
            return this;
        }

        public MetadataFixerResult build() {
            return MetadataFixerResultImpl.fromValues(this.status, this.fixes);
        }
    }
}

