/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.processor;

import jakarta.xml.bind.JAXBException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.EnumSet;
import org.verapdf.component.Components;
import org.verapdf.core.VeraPDFException;
import org.verapdf.core.XmlSerialiser;
import org.verapdf.features.FeatureExtractorConfig;
import org.verapdf.metadata.fixer.MetadataFixerConfig;
import org.verapdf.pdfa.validation.profiles.ValidationProfile;
import org.verapdf.pdfa.validation.validators.ValidatorConfig;
import org.verapdf.processor.BatchFileProcessor;
import org.verapdf.processor.BatchProcessingHandler;
import org.verapdf.processor.BatchProcessor;
import org.verapdf.processor.FormatOption;
import org.verapdf.processor.HTMLHandler;
import org.verapdf.processor.ItemProcessor;
import org.verapdf.processor.JsonHandler;
import org.verapdf.processor.MrrHandler;
import org.verapdf.processor.ProcessorConfig;
import org.verapdf.processor.ProcessorConfigImpl;
import org.verapdf.processor.ProcessorImpl;
import org.verapdf.processor.ProcessorResult;
import org.verapdf.processor.ProcessorResultImpl;
import org.verapdf.processor.RawResultHandler;
import org.verapdf.processor.SingleLineResultHandler;
import org.verapdf.processor.TaskResult;
import org.verapdf.processor.TaskResultImpl;
import org.verapdf.processor.TaskType;
import org.verapdf.processor.plugins.PluginsCollectionConfig;
import org.verapdf.processor.reports.BatchSummary;
import org.verapdf.processor.reports.Reports;
import org.verapdf.processor.reports.Summarisers;

public final class ProcessorFactory {
    private ProcessorFactory() {
    }

    public static ProcessorConfig defaultConfig() {
        return ProcessorConfigImpl.defaultInstance();
    }

    public static ProcessorConfig fromValues(ValidatorConfig config, FeatureExtractorConfig featureConfig, PluginsCollectionConfig pluginsCollectionConfig, MetadataFixerConfig fixerConfig, EnumSet<TaskType> tasks) {
        return ProcessorConfigImpl.fromValues(config, featureConfig, pluginsCollectionConfig, fixerConfig, tasks);
    }

    public static ProcessorConfig fromValues(ValidatorConfig config, FeatureExtractorConfig featureConfig, PluginsCollectionConfig pluginsCollectionConfig, MetadataFixerConfig fixerConfig, EnumSet<TaskType> tasks, String mdFolder) {
        return ProcessorConfigImpl.fromValues(config, featureConfig, pluginsCollectionConfig, fixerConfig, tasks, mdFolder);
    }

    public static ProcessorConfig fromValues(ValidatorConfig config, FeatureExtractorConfig featureConfig, PluginsCollectionConfig pluginsCollectionConfig, MetadataFixerConfig fixerConfig, EnumSet<TaskType> tasks, ValidationProfile customProfile) {
        return ProcessorConfigImpl.fromValues(config, featureConfig, pluginsCollectionConfig, fixerConfig, tasks, customProfile);
    }

    public static ProcessorConfig fromValues(ValidatorConfig config, FeatureExtractorConfig featureConfig, PluginsCollectionConfig pluginsCollectionConfig, MetadataFixerConfig fixerConfig, EnumSet<TaskType> tasks, ValidationProfile customProfile, String mdFolder) {
        return ProcessorConfigImpl.fromValues(config, featureConfig, pluginsCollectionConfig, fixerConfig, tasks, customProfile, mdFolder);
    }

    public static void configToXml(ProcessorConfig toConvert, OutputStream stream, boolean format) throws JAXBException {
        XmlSerialiser.toXml(toConvert, stream, format, false);
    }

    public static ProcessorConfig configFromXml(InputStream source) throws JAXBException {
        return (ProcessorConfig)XmlSerialiser.typeFromXml(ProcessorConfigImpl.class, source);
    }

    public static final ItemProcessor createProcessor(ProcessorConfig config) {
        return ProcessorImpl.newProcessor(config);
    }

    public static final BatchProcessor fileBatchProcessor(ProcessorConfig config) {
        return new BatchFileProcessor(ProcessorFactory.createProcessor(config));
    }

    public static final BatchProcessingHandler rawResultHandler() throws VeraPDFException {
        return ProcessorFactory.rawResultHandler(new PrintWriter(System.out));
    }

    public static final BatchProcessingHandler rawResultHandler(Writer dest) throws VeraPDFException {
        return RawResultHandler.newInstance(dest);
    }

    public static final BatchProcessingHandler getHandler(FormatOption option, boolean isVerbose, boolean logPassed) throws VeraPDFException {
        return ProcessorFactory.getHandler(option, isVerbose, System.out, logPassed);
    }

    public static final BatchProcessingHandler getHandler(FormatOption option, boolean isVerbose, OutputStream reportStream, boolean logPassed) throws VeraPDFException {
        return ProcessorFactory.getHandler(option, isVerbose, reportStream, logPassed, "");
    }

    public static final BatchProcessingHandler getHandler(FormatOption option, boolean isVerbose, OutputStream reportStream, boolean logPassed, String wikiPath) throws VeraPDFException {
        if (option == null) {
            throw new IllegalArgumentException("Arg option can not be null");
        }
        if (reportStream == null) {
            throw new IllegalArgumentException("Arg reportStream can not be null");
        }
        PrintWriter printWriter = new PrintWriter(new OutputStreamWriter(reportStream, StandardCharsets.UTF_8));
        switch (option) {
            case TEXT: {
                return SingleLineResultHandler.newInstance(printWriter, isVerbose, logPassed);
            }
            case RAW: {
                return ProcessorFactory.rawResultHandler(printWriter);
            }
            case MRR: 
            case XML: {
                return MrrHandler.newInstance(printWriter, logPassed);
            }
            case HTML: {
                return HTMLHandler.newInstance(printWriter, wikiPath);
            }
            case JSON: {
                return new JsonHandler(printWriter, logPassed);
            }
        }
        throw new VeraPDFException("Unknown report format option: " + (Object)((Object)option));
    }

    public static void resultToXml(ProcessorResult toConvert, OutputStream stream, boolean prettyXml) throws JAXBException {
        XmlSerialiser.toXml(toConvert, stream, prettyXml, false);
    }

    public static void writeSingleResultReport(ProcessorResult toConvert, BatchProcessingHandler tmpHandler, ProcessorConfig config) throws VeraPDFException {
        tmpHandler.handleBatchStart(config);
        tmpHandler.handleResult(toConvert, config.getValidatorConfig().isLogsEnabled());
        BatchSummariser tmpSummariser = new BatchSummariser(config);
        tmpSummariser.addProcessingResult(toConvert);
        tmpHandler.handleBatchEnd(tmpSummariser.summarise());
    }

    public static ProcessorResult resultFromXml(InputStream source) throws JAXBException {
        return (ProcessorResult)XmlSerialiser.typeFromXml(ProcessorResultImpl.class, source);
    }

    public static void taskResultToXml(TaskResult toConvert, OutputStream dest, boolean prettyXml) throws JAXBException {
        XmlSerialiser.toXml(toConvert, dest, prettyXml, true);
    }

    public static TaskResult taskResultfromXml(InputStream source) throws JAXBException {
        return (TaskResult)XmlSerialiser.typeFromXml(TaskResultImpl.class, source);
    }

    public static final class BatchSummariser {
        private final ProcessorConfig config;
        private int totalJobs = 0;
        private int failedToParse = 0;
        private int encrypted = 0;
        private int outOfMemory = 0;
        private int veraExceptions = 0;
        private Components.Timer timer = Components.Timer.start();
        private Summarisers.ValidationSummaryBuilder validationBuilder = new Summarisers.ValidationSummaryBuilder();
        private Summarisers.FeatureSummaryBuilder featureBuilder = new Summarisers.FeatureSummaryBuilder();
        private Summarisers.RepairSummaryBuilder repairBuilder = new Summarisers.RepairSummaryBuilder();

        public BatchSummariser(ProcessorConfig config) {
            if (config == null) {
                throw new IllegalArgumentException("Argument config can not be null");
            }
            this.config = config;
        }

        public void addProcessingResult(ProcessorResult result) {
            ++this.totalJobs;
            if (!result.isPdf()) {
                ++this.failedToParse;
            }
            if (result.isEncryptedPdf()) {
                ++this.encrypted;
            }
            if (result.isOutOfMemory()) {
                ++this.outOfMemory;
            }
            if (result.hasException()) {
                ++this.veraExceptions;
            }
            if (this.config.hasTask(TaskType.VALIDATE)) {
                this.validationBuilder.addResult(result);
            }
            if (this.config.hasTask(TaskType.EXTRACT_FEATURES)) {
                this.featureBuilder.addResult(result);
            }
            if (this.config.hasTask(TaskType.FIX_METADATA)) {
                this.repairBuilder.addResult(result);
            }
        }

        public BatchSummary summarise() {
            return Reports.createBatchSummary(this.timer, this.validationBuilder.build(), this.featureBuilder.build(), this.repairBuilder.build(), this.totalJobs, this.failedToParse, this.encrypted, this.outOfMemory, this.veraExceptions);
        }
    }
}

