/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.policy;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

final class SchematronPipeline {
    private static final Logger LOGGER = Logger.getLogger(SchematronPipeline.class.getName());
    static final ClassLoader cl = SchematronPipeline.class.getClassLoader();
    private static final TransformerFactory factory = SchematronPipeline.getTransformerFactory();
    private static final String xslExt = ".xsl";
    private static final String resourcePath = "org/verapdf/policy/schematron/pipeline/";
    private static final String isoDsdlXsl = "org/verapdf/policy/schematron/pipeline/iso_dsdl_include.xsl";
    private static final String isoExpXsl = "org/verapdf/policy/schematron/pipeline/iso_abstract_expand.xsl";
    private static final String isoSvrlXsl = "org/verapdf/policy/schematron/pipeline/iso_svrl_for_xslt1.xsl";
    private static final Templates cachedIsoDsdXsl = SchematronPipeline.createCachedTransform("org/verapdf/policy/schematron/pipeline/iso_dsdl_include.xsl");
    private static final Templates cachedExpXsl = SchematronPipeline.createCachedTransform("org/verapdf/policy/schematron/pipeline/iso_abstract_expand.xsl");
    private static final Templates cachedIsoSvrlXsl = SchematronPipeline.createCachedTransform("org/verapdf/policy/schematron/pipeline/iso_svrl_for_xslt1.xsl");

    private SchematronPipeline() {
    }

    public static void processSchematron(InputStream schematronSource, OutputStream xslDest) throws TransformerException, IOException {
        File isoDsdResult = SchematronPipeline.createTempFileResult(cachedIsoDsdXsl.newTransformer(), new StreamSource(schematronSource), "IsoDsd");
        File isoExpResult = SchematronPipeline.createTempFileResult(cachedExpXsl.newTransformer(), new StreamSource(isoDsdResult), "ExpXsl");
        Transformer transformer = cachedIsoSvrlXsl.newTransformer();
        transformer.setOutputProperty("indent", "no");
        transformer.transform(new StreamSource(isoExpResult), new StreamResult(xslDest));
        if (!isoDsdResult.delete()) {
            isoDsdResult.deleteOnExit();
        }
        if (!isoExpResult.delete()) {
            isoExpResult.deleteOnExit();
        }
    }

    static Templates createCachedTransform(String transName) {
        try {
            return factory.newTemplates(new StreamSource(cl.getResourceAsStream(transName)));
        }
        catch (TransformerConfigurationException excep) {
            throw new IllegalStateException("Policy Schematron transformer XSL " + transName + " not found.", excep);
        }
    }

    private static File createTempFileResult(Transformer transformer, StreamSource toTransform, String suffix) throws TransformerException, IOException {
        File result = File.createTempFile("veraPDF_", suffix);
        try (FileOutputStream fos = new FileOutputStream(result);){
            transformer.transform(toTransform, new StreamResult(fos));
        }
        return result;
    }

    private static TransformerFactory getTransformerFactory() {
        TransformerFactory fact = TransformerFactory.newInstance();
        try {
            fact.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            fact.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "file");
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            // empty catch block
        }
        fact.setURIResolver(new ClasspathResourceURIResolver());
        return fact;
    }

    static {
        try {
            factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "file");
        }
        catch (TransformerConfigurationException ignored) {
            LOGGER.log(Level.WARNING, "Unable to secure xsl transformer");
        }
    }

    private static class ClasspathResourceURIResolver
    implements URIResolver {
        ClasspathResourceURIResolver() {
        }

        @Override
        public Source resolve(String href, String base) throws TransformerException {
            InputStream inputStream;
            File file = new File(href);
            if (file.exists()) {
                try {
                    inputStream = new FileInputStream(file);
                }
                catch (FileNotFoundException e) {
                    LOGGER.log(Level.SEVERE, "File not found but exists", e);
                    inputStream = new ByteArrayInputStream(new byte[0]);
                }
            } else {
                inputStream = cl.getResourceAsStream(SchematronPipeline.resourcePath + href);
            }
            return new StreamSource(inputStream);
        }
    }
}

