/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.processor;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.verapdf.core.VeraPDFException;
import org.verapdf.core.utils.FileUtils;
import org.verapdf.core.utils.LogsFileHandler;
import org.verapdf.processor.AbstractBatchProcessor;
import org.verapdf.processor.ItemProcessor;
import org.verapdf.processor.ProcessorResult;
import org.verapdf.processor.reports.ItemDetails;

public final class BatchFileProcessor
extends AbstractBatchProcessor {
    private static final Logger logger = Logger.getLogger(BatchFileProcessor.class.getCanonicalName());

    public BatchFileProcessor(ItemProcessor processor) {
        super(processor);
    }

    @Override
    protected void processContainer(File container, boolean recurse) throws VeraPDFException {
        if (container == null || !container.isDirectory() || !container.canRead()) {
            logger.log(Level.SEVERE, BatchFileProcessor.badItemMessage(container, true));
        } else {
            this.processDir(container, recurse);
        }
    }

    @Override
    protected void processList(List<? extends File> toProcess) throws VeraPDFException {
        this.configLogs();
        for (File file : toProcess) {
            if (file == null || !file.isFile() || !file.canRead()) {
                logger.log(Level.SEVERE, BatchFileProcessor.badItemMessage(file, false));
                continue;
            }
            if (FileUtils.hasExtNoCase(file.getName(), "zip")) {
                this.processArchive(file);
                continue;
            }
            this.processItem(file);
        }
    }

    private void processArchive(File toProcess) throws VeraPDFException {
        try (ZipFile zipFile = new ZipFile(toProcess);){
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                if (entry.isDirectory() || !this.processor.getConfig().getValidatorConfig().getNonPDFExtension() && !BatchFileProcessor.isPdf(entry.getName())) continue;
                ItemDetails itemDetails = ItemDetails.fromValues(toProcess.getAbsolutePath() + File.separator + entry.getName().replace("/", File.separator).replace("\\", File.separator), entry.getSize());
                this.processItem(itemDetails, zipFile.getInputStream(entry));
            }
        }
        catch (IOException exp) {
            throw new VeraPDFException(exp.getMessage(), exp);
        }
    }

    private void processDir(File toProcess, boolean recurse) throws VeraPDFException {
        for (File item : toProcess.listFiles()) {
            if (item.isHidden() || !item.canRead()) continue;
            if (item.isDirectory()) {
                this.processDir(item, recurse);
                continue;
            }
            if (!item.isFile() || !BatchFileProcessor.isPdf(item.getName())) continue;
            this.processItem(item);
        }
    }

    private static boolean isPdf(String name) {
        return FileUtils.hasExtNoCase(name, "pdf");
    }

    private void configLogs() {
        if (this.processor.getConfig().getValidatorConfig().isLogsEnabled()) {
            LogsFileHandler.configLogs();
            LogsFileHandler.setLoggingLevel(this.processor.getConfig().getValidatorConfig().getLoggingLevel());
        }
    }

    private void debugAndLog(String fileName) {
        if (this.processor.getConfig().getValidatorConfig().isDebug()) {
            logger.log(Level.WARNING, fileName);
        }
        if (this.processor.getConfig().getValidatorConfig().isLogsEnabled()) {
            try {
                LogsFileHandler.createNewLogFile();
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "Error while creating log file");
            }
        }
    }

    private void processItem(ItemDetails fileDetails, InputStream item) throws VeraPDFException {
        this.debugAndLog(fileDetails.getName());
        ProcessorResult result = this.processor.process(fileDetails, item);
        this.processResult(result, this.processor.getConfig().getValidatorConfig().isLogsEnabled());
    }

    private void processItem(File item) throws VeraPDFException {
        this.debugAndLog(item.getAbsolutePath());
        ProcessorResult result = this.processor.process(item);
        this.processResult(result, this.processor.getConfig().getValidatorConfig().isLogsEnabled());
    }

    private static String badItemMessage(File item, boolean isDir) {
        String itemType;
        String string = itemType = isDir ? "directory" : "file";
        if (item == null) {
            return "Null " + itemType + " item passed for processing.";
        }
        String rootMessage = "Couldn't process: " + item.getAbsolutePath() + " is not a ";
        String messageTrail = item.canRead() ? itemType + "." : "readable " + itemType + ".";
        return rootMessage + messageTrail;
    }
}

