/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.processor;

import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlElementWrapper;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.adapters.XmlAdapter;
import java.util.Collection;
import java.util.EnumMap;
import java.util.EnumSet;
import org.verapdf.features.FeatureExtractionResult;
import org.verapdf.metadata.fixer.FixerFactory;
import org.verapdf.pdfa.results.MetadataFixerResult;
import org.verapdf.pdfa.results.ValidationResult;
import org.verapdf.pdfa.results.ValidationResults;
import org.verapdf.processor.ProcessorResult;
import org.verapdf.processor.TaskResult;
import org.verapdf.processor.TaskResultImpl;
import org.verapdf.processor.TaskType;
import org.verapdf.processor.reports.ItemDetails;
import org.verapdf.report.FeaturesReport;

@XmlRootElement(name="processorResult")
class ProcessorResultImpl
implements ProcessorResult {
    private static final ProcessorResult defaultInstance = new ProcessorResultImpl();
    @XmlAttribute
    private final boolean isPdf;
    @XmlAttribute
    private final boolean isEncryptedPdf;
    @XmlAttribute
    private final boolean isOutOfMemory;
    @XmlAttribute
    private final boolean hasException;
    @XmlElement
    private final ItemDetails itemDetails;
    private final EnumMap<TaskType, TaskResult> taskResults;
    @XmlElement
    private final ValidationResult validationResult;
    private final FeatureExtractionResult featuresResult;
    @XmlElement
    private final MetadataFixerResult fixerResult;

    private ProcessorResultImpl() {
        this(ItemDetails.defaultInstance(), TaskResultImpl.defaultInstance());
    }

    private ProcessorResultImpl(ItemDetails details, TaskResult result) {
        this(details, false, false, false, result);
    }

    private ProcessorResultImpl(ItemDetails details, boolean isEncrypted, boolean isOutOfMemory, TaskResult result) {
        this(details, true, isEncrypted, isOutOfMemory, result);
    }

    private ProcessorResultImpl(ItemDetails details, boolean isValidPdf, boolean isEncrypted, boolean isOutOfMemory, TaskResult result) {
        this(details, isValidPdf, isEncrypted, isOutOfMemory, ProcessorResultImpl.resMap(result), ValidationResults.defaultResult(), new FeatureExtractionResult(), FixerFactory.defaultResult());
    }

    private ProcessorResultImpl(ItemDetails details, EnumMap<TaskType, TaskResult> results, ValidationResult validationResult, FeatureExtractionResult featuresResult, MetadataFixerResult fixerResult) {
        this(details, true, false, false, results, validationResult, featuresResult, fixerResult);
    }

    private ProcessorResultImpl(ItemDetails details, boolean isPdf, boolean isEncrypted, boolean isOutOfMemory, EnumMap<TaskType, TaskResult> results, ValidationResult validationResult, FeatureExtractionResult featuresResult, MetadataFixerResult fixerResult) {
        this.itemDetails = details;
        this.isPdf = isPdf;
        this.isEncryptedPdf = isEncrypted;
        this.isOutOfMemory = isOutOfMemory;
        this.taskResults = results;
        this.hasException = !this.isEncryptedPdf && !this.isOutOfMemory && this.isPdf && this.taskResults.values().stream().anyMatch(res -> res.getException() != null);
        this.validationResult = validationResult;
        this.featuresResult = featuresResult;
        this.fixerResult = fixerResult;
    }

    @Override
    public EnumMap<TaskType, TaskResult> getResults() {
        return this.taskResults;
    }

    @Override
    @XmlElementWrapper(name="taskResult")
    @XmlElement(name="taskResult")
    public Collection<TaskResult> getResultSet() {
        return this.taskResults.values();
    }

    @Override
    public ItemDetails getProcessedItem() {
        return this.itemDetails;
    }

    @Override
    public EnumSet<TaskType> getTaskTypes() {
        return this.taskResults.isEmpty() ? EnumSet.noneOf(TaskType.class) : EnumSet.copyOf(this.taskResults.keySet());
    }

    static ProcessorResult defaultInstance() {
        return defaultInstance;
    }

    static ProcessorResult fromValues(ItemDetails details, EnumMap<TaskType, TaskResult> results, ValidationResult validationResult, FeatureExtractionResult featuresResult, MetadataFixerResult fixerResult) {
        return new ProcessorResultImpl(details, true, false, false, results, validationResult, featuresResult, fixerResult);
    }

    static ProcessorResult invalidPdfResult(ItemDetails details, TaskResult res) {
        return new ProcessorResultImpl(details, res);
    }

    static ProcessorResult encryptedResult(ItemDetails details, TaskResult res) {
        return new ProcessorResultImpl(details, true, false, res);
    }

    static ProcessorResult outOfMemoryResult(ItemDetails details, TaskResult res) {
        return new ProcessorResultImpl(details, false, true, res);
    }

    static ProcessorResult veraExceptionResult(ItemDetails details, TaskResult res) {
        return new ProcessorResultImpl(details, false, false, res);
    }

    @Override
    public ValidationResult getValidationResult() {
        return this.validationResult;
    }

    @Override
    @XmlElement
    public FeaturesReport getFeaturesReport() {
        return FeaturesReport.fromValues(this.featuresResult);
    }

    @Override
    public MetadataFixerResult getFixerResult() {
        return this.fixerResult;
    }

    @Override
    public TaskResult getResultForTask(TaskType taskType) {
        return this.taskResults.get((Object)taskType);
    }

    @Override
    public boolean isPdf() {
        return this.isPdf;
    }

    @Override
    public boolean isEncryptedPdf() {
        return this.isEncryptedPdf;
    }

    @Override
    public boolean isOutOfMemory() {
        return this.isOutOfMemory;
    }

    @Override
    public boolean hasException() {
        return this.hasException;
    }

    private static EnumMap<TaskType, TaskResult> resMap(TaskResult result) {
        EnumMap<TaskType, TaskResult> resultMap = new EnumMap<TaskType, TaskResult>(TaskType.class);
        if (result != null && result.getType() != null) {
            resultMap.put(result.getType(), result);
        }
        return resultMap;
    }

    static class Adapter
    extends XmlAdapter<ProcessorResultImpl, ProcessorResult> {
        Adapter() {
        }

        public ProcessorResult unmarshal(ProcessorResultImpl procResultImpl) {
            return procResultImpl;
        }

        public ProcessorResultImpl marshal(ProcessorResult procResult) {
            return (ProcessorResultImpl)procResult;
        }
    }
}

