/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.processor;

import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.util.EnumSet;
import org.verapdf.features.FeatureExtractorConfig;
import org.verapdf.features.FeatureFactory;
import org.verapdf.metadata.fixer.FixerFactory;
import org.verapdf.metadata.fixer.MetadataFixerConfig;
import org.verapdf.pdfa.validation.profiles.Profiles;
import org.verapdf.pdfa.validation.profiles.ValidationProfile;
import org.verapdf.pdfa.validation.validators.ValidatorConfig;
import org.verapdf.pdfa.validation.validators.ValidatorFactory;
import org.verapdf.processor.ProcessorConfig;
import org.verapdf.processor.TaskType;
import org.verapdf.processor.plugins.PluginsCollectionConfig;

@XmlRootElement(name="processorConfig")
final class ProcessorConfigImpl
implements ProcessorConfig {
    private static final String defaultMdFolder = ".";
    private static final ProcessorConfig defaultInstance = new ProcessorConfigImpl();
    @XmlElement
    private final EnumSet<TaskType> tasks;
    @XmlElement
    private final ValidatorConfig validatorConfig;
    @XmlElement
    private final FeatureExtractorConfig featureConfig;
    @XmlElement
    private final PluginsCollectionConfig pluginsCollectionConfig;
    @XmlElement
    private final MetadataFixerConfig fixerConfig;
    @XmlElement
    private final ValidationProfile customProfile;
    @XmlAttribute
    private final String mdFolder;

    private ProcessorConfigImpl() {
        this(ValidatorFactory.defaultConfig(), FeatureFactory.defaultConfig(), PluginsCollectionConfig.defaultConfig(), FixerFactory.defaultConfig(), EnumSet.noneOf(TaskType.class));
    }

    private ProcessorConfigImpl(ValidatorConfig config, FeatureExtractorConfig featureConfig, PluginsCollectionConfig pluginsCollectionConfig, MetadataFixerConfig fixerConfig, EnumSet<TaskType> tasks) {
        this(config, featureConfig, pluginsCollectionConfig, fixerConfig, tasks, Profiles.defaultProfile());
    }

    private ProcessorConfigImpl(ValidatorConfig config, FeatureExtractorConfig featureConfig, PluginsCollectionConfig pluginsCollectionConfig, MetadataFixerConfig fixerConfig, EnumSet<TaskType> tasks, String mdFolder) {
        this(config, featureConfig, pluginsCollectionConfig, fixerConfig, tasks, Profiles.defaultProfile(), mdFolder);
    }

    private ProcessorConfigImpl(ValidatorConfig config, FeatureExtractorConfig featureConfig, PluginsCollectionConfig pluginsCollectionConfig, MetadataFixerConfig fixerConfig, EnumSet<TaskType> tasks, ValidationProfile customProfile) {
        this(config, featureConfig, pluginsCollectionConfig, fixerConfig, tasks, customProfile, defaultMdFolder);
    }

    private ProcessorConfigImpl(ValidatorConfig config, FeatureExtractorConfig featureConfig, PluginsCollectionConfig pluginsCollectionConfig, MetadataFixerConfig fixerConfig, EnumSet<TaskType> tasks, ValidationProfile customProfile, String mdFolder) {
        this.tasks = EnumSet.copyOf(tasks);
        this.validatorConfig = config;
        this.featureConfig = featureConfig;
        this.pluginsCollectionConfig = pluginsCollectionConfig;
        this.fixerConfig = fixerConfig;
        this.customProfile = customProfile;
        this.mdFolder = mdFolder;
    }

    public boolean isFixMetadata() {
        return this.tasks.contains((Object)TaskType.FIX_METADATA);
    }

    @Override
    public ValidatorConfig getValidatorConfig() {
        return this.validatorConfig;
    }

    @Override
    public FeatureExtractorConfig getFeatureConfig() {
        return this.featureConfig;
    }

    @Override
    public PluginsCollectionConfig getPluginsCollectionConfig() {
        return this.pluginsCollectionConfig;
    }

    @Override
    public MetadataFixerConfig getFixerConfig() {
        return this.fixerConfig;
    }

    @Override
    public EnumSet<TaskType> getTasks() {
        return EnumSet.copyOf(this.tasks);
    }

    @Override
    public boolean hasTask(TaskType toCheck) {
        return this.tasks.contains((Object)toCheck);
    }

    @Override
    public ValidationProfile getCustomProfile() {
        return this.customProfile;
    }

    @Override
    public boolean hasCustomProfile() {
        return this.customProfile.equals(Profiles.defaultProfile());
    }

    @Override
    public String getMetadataFolder() {
        return this.mdFolder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ProcessorConfigImpl)) {
            return false;
        }
        ProcessorConfigImpl that = (ProcessorConfigImpl)o;
        if (this.tasks != null ? !this.tasks.equals(that.tasks) : that.tasks != null) {
            return false;
        }
        if (this.validatorConfig != null ? !this.validatorConfig.equals(that.validatorConfig) : that.validatorConfig != null) {
            return false;
        }
        if (this.featureConfig != null ? !this.featureConfig.equals(that.featureConfig) : that.featureConfig != null) {
            return false;
        }
        if (this.pluginsCollectionConfig != null ? !this.pluginsCollectionConfig.equals(that.pluginsCollectionConfig) : that.pluginsCollectionConfig != null) {
            return false;
        }
        if (this.fixerConfig != null ? !this.fixerConfig.equals(that.fixerConfig) : that.fixerConfig != null) {
            return false;
        }
        if (this.customProfile != null ? !this.customProfile.equals(that.customProfile) : that.customProfile != null) {
            return false;
        }
        return this.mdFolder != null ? this.mdFolder.equals(that.mdFolder) : that.mdFolder == null;
    }

    public int hashCode() {
        int result = this.tasks != null ? this.tasks.hashCode() : 0;
        result = 31 * result + (this.validatorConfig != null ? this.validatorConfig.hashCode() : 0);
        result = 31 * result + (this.featureConfig != null ? this.featureConfig.hashCode() : 0);
        result = 31 * result + (this.pluginsCollectionConfig != null ? this.pluginsCollectionConfig.hashCode() : 0);
        result = 31 * result + (this.fixerConfig != null ? this.fixerConfig.hashCode() : 0);
        result = 31 * result + (this.customProfile != null ? this.customProfile.hashCode() : 0);
        result = 31 * result + (this.mdFolder != null ? this.mdFolder.hashCode() : 0);
        return result;
    }

    static ProcessorConfig defaultInstance() {
        return defaultInstance;
    }

    static ProcessorConfig fromValues(ValidatorConfig config, FeatureExtractorConfig featureConfig, PluginsCollectionConfig pluginsCollectionConfig, MetadataFixerConfig fixerConfig, EnumSet<TaskType> tasks) {
        return new ProcessorConfigImpl(config, featureConfig, pluginsCollectionConfig, fixerConfig, tasks);
    }

    static ProcessorConfig fromValues(ValidatorConfig config, FeatureExtractorConfig featureConfig, PluginsCollectionConfig pluginsCollectionConfig, MetadataFixerConfig fixerConfig, EnumSet<TaskType> tasks, String mdFolder) {
        return new ProcessorConfigImpl(config, featureConfig, pluginsCollectionConfig, fixerConfig, tasks, mdFolder);
    }

    static ProcessorConfig fromValues(ValidatorConfig config, FeatureExtractorConfig featureConfig, PluginsCollectionConfig pluginsCollectionConfig, MetadataFixerConfig fixerConfig, EnumSet<TaskType> tasks, ValidationProfile profile) {
        return new ProcessorConfigImpl(config, featureConfig, pluginsCollectionConfig, fixerConfig, tasks, profile);
    }

    static ProcessorConfig fromValues(ValidatorConfig config, FeatureExtractorConfig featureConfig, PluginsCollectionConfig pluginsCollectionConfig, MetadataFixerConfig fixerConfig, EnumSet<TaskType> tasks, ValidationProfile profile, String mdFolder) {
        return new ProcessorConfigImpl(config, featureConfig, pluginsCollectionConfig, fixerConfig, tasks, profile, mdFolder);
    }
}

